#include "BmpLoader.h"


CBmpLoader::CBmpLoader(CImageRenderer *renderer) :
	CBinaryLoader(renderer)
{
	
}

CBmpLoader::~CBmpLoader() {
	
}

/*! \todo fix, there is a sig, just an ugly one */
bool CBmpLoader::isFileType(const char *signature, const char *filename) {
	
	if (strncmp(signature,"BM",2)==0) {
		return true;
	}
	return false;
}

void CBmpLoader::loadFileFromDataImp(const char *data, const int length, CImageData *imageData) {
	
	CBinaryData *binaryData = (CBinaryData *)imageData;
	binaryData->m_fileType  = BMP;

	BITMAPFILEHEADER bf;
	memcpy(&bf, data, sizeof(bf));


	BITMAPINFO bi;
	memset(&bi.bmiHeader, 0, sizeof(bi));
	memcpy(&bi.bmiHeader, data+14, sizeof(bi));

	CDC dc;
	dc.CreateCompatibleDC(NULL); 
	binaryData->m_bitmap = new CBitmap();
	binaryData->m_width  = bi.bmiHeader.biWidth;
	binaryData->m_height = bi.bmiHeader.biHeight;
	binaryData->m_bitmap->CreateBitmap(binaryData->m_width, binaryData->m_height, dc.GetDeviceCaps(PLANES), dc.GetDeviceCaps(BITSPIXEL), NULL);
	int ret = ::SetDIBits(dc.GetSafeHdc(), *binaryData->m_bitmap, 0, binaryData->m_height, data+bf.bfOffBits, &bi, DIB_RGB_COLORS);
} 

