#include "BinaryRenderer.h"
#include "ImageContext.h"
#include "BinaryData.h"
#include "AcidImage.h"


CBinaryRenderer::CBinaryRenderer() {

}


CBinaryRenderer::~CBinaryRenderer() {

}


int CBinaryRenderer::getWidth(CImageContext *context, CImageData *data) {

	CBinaryData *binaryData = (CBinaryData *)data;
	if (context->m_scaleWidth) 
		if (binaryData->m_width>context->m_scaleWidth)
			return context->m_scaleWidth;

	return binaryData->m_width;
}


int CBinaryRenderer::getHeight(CImageContext *context, CImageData *data) {
	CBinaryData *binaryData = (CBinaryData *)data;

	if (context->m_scaleWidth) {
		if (binaryData->m_width>context->m_scaleWidth) {
			return (binaryData->m_height*context->m_scaleWidth)/binaryData->m_width;
		}
	}

	return binaryData->m_height;
}


void CBinaryRenderer::setImage(CImageContext *, CImageData *) {

}


int CBinaryRenderer::invalidateRect(CImageContext *context, CImageData *data, CRect r, int &xoffs, int &yoffs) {

	CBinaryData *binaryData = (CBinaryData *)data;

	xoffs = 0;
	yoffs = 0;

	CDC memDC;
	memDC.CreateCompatibleDC(context->m_pDC);
	memDC.SelectObject(binaryData->m_bitmap);
	/*! \todo win98 machines don't do a very good job with stretchblt */
	if (context->m_scaleWidth) 
		if (binaryData->m_width>context->m_scaleWidth) {
			int top  = (r.top*binaryData->m_width)/context->m_scaleWidth;
			int h    = (r.Height()*binaryData->m_width)/context->m_scaleWidth;
			context->m_pDC->SetStretchBltMode(STRETCH_HALFTONE);
			context->m_pDC->StretchBlt(0, 0, r.Width(), r.Height(), &memDC, 0, top, binaryData->m_width, h, SRCCOPY);
			return 0;
		}

	context->m_pDC->BitBlt(0, 0, r.Width(), r.Height(), &memDC, r.left, r.top, SRCCOPY);
	return 0;
}


int CBinaryRenderer::invalidateRectAnimation(CImageContext *, CImageData *, CRect, int &, int &) {

	::MessageBox(NULL, "CBinaryRenderer::invalidateRectAnimation called in non-animatable class", "Error", MB_OK);
	return 0;
}
