#include "BinLoader.h"


CBinLoader::CBinLoader(CImageRenderer *renderer) :
	CTextLoader(renderer)
{

}


CBinLoader::~CBinLoader() {


}


bool CBinLoader::isFileType(const char *, const char *filename) {

	if (filename && stricmp(filename,"bin")==0) {
		return true;
	}
	return false;	
}
 
static const char bin_conversion_table[8] = {
	BIN_BLACK,
	BIN_BLUE,
	BIN_GREEN,
	BIN_CYAN,
	BIN_RED,
	BIN_MAGENTA,
	BIN_YELLOW,
	BIN_WHITE
};


void CBinLoader::loadFileFromDataImp(const char *data, const int length, CImageData *imageData) {
	
	CTextData *textData = (CTextData *)imageData;
	textData->m_fileType = BIN;
	
	//If sauce specifies the bin's width
	int width = 160;
	if (textData->m_sauce				&& 
		textData->m_sauce->DataType==5	&& 
		textData->m_sauce->FileType>0) {

		width = (textData->m_sauce->FileType&~1)*2;
		textData->m_iceColors = textData->m_sauce->FileType&1;
	} 
	
	textData->m_list->init(width*2);
	
	// read in the characters
	int offset = 0;
	while(offset<length && data[offset]!=CTRLZ) {
		char *line = textData->m_list->forwardCat();
		memcpy(line, data+offset, width*2);		offset += width*2;
		
		for (int i=1; i<(width*2); i+=2) {
			char fg = line[i]&0x7;
			char bg = (line[i]>>4)&0x7;
			fg = bin_conversion_table[fg];
			bg = bin_conversion_table[bg];
			line[i] = (line[i]&0x88)|fg|(bg<<4);
		}
		
	}
}