#include "BgiFont.h"
#include "resource.h"
#include "StdAfx.h"

#define Major_Version	1
#define Minor_Version	0
#define SIGNATURE		'+'


char		*Font;					/* Pointer to font storage	*/
char		Prefix[Prefix_Size];	/* File Prefix Holder		*/
int			Offset[256];			/* Font data offsets		*/
char		Char_Width[256];

char  *OpName[] = {
  "End    ",
  "Do Scan",
  "Move To",
  "Line To"
 };


void dvalue( char *str, unsigned int value )
{
#ifdef __DEBUG
	static char s[100];
	sprintf(s, "%-50s  %04xh  (%6u. )\n", str, value, value);
	OutputDebugString(s);
#endif
}


void memRead(void *dest, const char *buffer, int len, int &offset) {
	memcpy(dest, buffer+offset, len);
	offset += len;
}

void trace(const char *str, ...) {
#ifdef __DEBUG
	static char s[100];
	
	va_list l;
	vsprintf(s, str, l);
	OutputDebugSting(str);
#endif
}

void CBgiFont::loadFont(BgiFontType fontType) {

	int resource = 1;
	/*
	switch(fontType) {		
		case	TRIPLEX:	resource = IDR_BGI_FONT_TRIP;	break;
		case	SANS_SERIF:	resource = IDR_BGI_FONT_SANS;	break;
		case	GOTHIC:		resource = IDR_BGI_FONT_GOTH;	break;
		case	SCRIPT:		resource = IDR_BGI_FONT_SCRI;	break;
		case	SIMPLEX:	resource = IDR_BGI_FONT_SIMP;	break;
		case	COMPLEX:	resource = IDR_BGI_FONT_LCOM;	break;
		case	EUROPEAN:	resource = IDR_BGI_FONT_EURO;	break;
		case	BOLD:		resource = IDR_BGI_FONT_BOLD;	break;
		case	TRIPLEX_SCRIPT:	resource = IDR_BGI_FONT_TSCR;	break;
		// \todo figure this out.. also not that LITT is still not being used 
		case	DEFAULT:	
		case	SMALL:		resource = 0;
	}
*/
	
	char  *buffer= 0;
	int	bufferLength = 0;
	int offs = 0;
	if (resource) {
		HRSRC hrsrc = FindResource(NULL, MAKEINTRESOURCE(resource), "BGI_FONT");
		if (hrsrc)
		{
			HGLOBAL hglobal = LoadResource(NULL, hrsrc);
			if (hglobal)
			{
				bufferLength = SizeofResource(NULL, hrsrc);
				buffer		 = (char *)LockResource(hglobal);		
				
				/*! \note says you don't need to free the resources used by this function, but 
				i really don't believe big g */
			}//if loaded resource
		}//if found resource
	}
		
	/*	Read in and display the file prefix record.			*/	
	memRead(m_prefix, buffer, Prefix_Size, offs);

	/* Begin at base of prefix	*/
	char *cptr = m_prefix;				
	while( 0x1a != *cptr ) ++cptr;			/* Move to EOF in prefix	*/
	*cptr = '\0';							/* Cut prefix at EOF            */
	m_fheader = (FHEADER *)(cptr+1);	/* Point at Font Header Record	*/
	
	/*	Read in and display the font header record.			*/	
	memRead(&m_header, buffer, sizeof(HEADER), offs);
	
	/*	Read file offset table into memory.				*/	
	memRead(&Offset[m_header.first], buffer, m_header.nchrs*sizeof(int), offs);
	
	/*	Load the character width table into memory.			*/	
	memRead(&Char_Width[m_header.first], buffer, m_header.nchrs*sizeof(char), offs);
	
	/*  Load the stroke information */	
	int last_chr = m_header.first + m_header.nchrs;
	for(int i=m_header.first; i<last_chr; ++i) {
		if( !Offset[i] && i!=m_header.first ) continue;
		m_chars[i] = new CBgiFontCharacter(Char_Width[i], (unsigned int *)buffer, Offset[i]);
    }	
}


CBgiFont::CBgiFont(BgiFontType fontType) {

	int i = sizeof(m_chars);
	memset(m_chars, 0, sizeof(m_chars));
	loadFont(fontType);
}

CBgiFont::~CBgiFont() {

	for (int i=0; i<256; i++)
		if (m_chars[i])
			delete m_chars[i];

}

/*
void BezierCurve(CoArr x, CoArr y, int n, int value)
{
	int i;
	double delta=1.0/n;
	double t=0, T;
	int a,b;

	setcolor(8);

	for(i=0;i<4;i++)
		line(x[i],y[i],x[(i+1)%4],y[(i+1)%4]);

	for(i=0;i<n;i++)
	{
		t+=delta;
		T=1-t;
		a=x[0]*T*T*T+3*t*T*T*x[1]+3*t*t*T*x[2]+t*t*t*x[3];
		b=y[0]*T*T*T+3*t*T*T*y[1]+3*t*t*T*y[2]+t*t*t*y[3];
		putpixel(a,b,value);
	}
}
*/