#include "ansifont.h"


CAnsiFont::CAnsiFont(const int width, const int height, const int numChars, const unsigned char *data) :
	m_charWidth(width),
	m_charHeight(height),
	m_numChars(numChars)
{
	generateMipMaps(data);
}

CAnsiFont::~CAnsiFont() {
	for (int i=0; i<4; i++)
		delete [] m_chars[i];
}

void CAnsiFont::generateMipMaps(const unsigned char *data) {
	
	//Allocate the memory for the mipmaps
	int i, size = m_charWidth*m_charHeight*m_numChars;
	for (i=0; i<4; i++) {
		m_chars[i] = new unsigned int [size/(1<<i)];
	}
	
	
	//Expand bits to bytes
	const unsigned char *temp = data;
	unsigned int *dest = m_chars[0];
	for (i=0; i<m_numChars; i++) {
		
		for(int h=0; h<m_charHeight; h++) {
			
			int font_bitmap = *temp;
			if (m_charWidth==16) {
				font_bitmap |= (int)(*(temp+1))<<8; 
			}
			
			int andAmt = 1<<(m_charWidth-1);
			for (int w=0; w<m_charWidth; w++) {
		
				*dest++  = (font_bitmap&andAmt)?0xFFFFFF:0;
				andAmt>>= 1;
			}
			
			temp += m_charWidth/8;
		}
	}
	
	//Finally, generate the mip maps
	
	//For each font set
	int s = m_charWidth*m_charHeight;
	for (i=1; i<4; i++) {
		
		int scale = 1<<i;
		unsigned int *dest = m_chars[i];
		for (int ch=0; ch<m_numChars; ch++) {
			
			for (int h=0; h<m_charHeight; h+=scale) {
				for (int w=0; w<m_charWidth; w+=scale) {
					
					unsigned int sum = 0;
					for (int h2=h; h2<(h+scale); h2++) {
						//unsigned int *font_bitmap = getCharPointer(ch, h2, 0)+w;
						unsigned int *font_bitmap = &m_chars[0][(unsigned int)ch*s + m_charWidth*h2] + w;
						for (int w2=w; w2<(w+scale); w2++) {
							sum += (*font_bitmap++)&0xff;
						}
					}
					
					sum = (unsigned char)(sum/(scale*scale));
					*dest++ = sum|(sum<<8)|(sum<<16);					
				}
			}
		}
	}
	
}

unsigned int *CAnsiFont::getCharPointer(unsigned char ch, int row, int scale) {	
	
	int w = m_charWidth/(1<<scale);
	int h = m_charHeight/(1<<scale);
	
	int index = (unsigned int)ch*w*h + w*row;
	return &m_chars[scale][index];
}