// AcidViewView.h : interface of the CAcidViewView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_ACIDVIEWVIEW_H__C8093DBB_E30B_4DF5_AB6B_F529D50CBC96__INCLUDED_)
#define AFX_ACIDVIEWVIEW_H__C8093DBB_E30B_4DF5_AB6B_F529D50CBC96__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ImageContext.h"

class CAcidViewDoc;

const UINT    WM_IMAGE_DONE =  RegisterWindowMessage(_T("74AF4815-09BA-421f-9797-598E496B3BB2"));


/*! \note In a perfect world this would inherit from CScrollView and handling full screen
	mode would require nothing more than a simple conditional in OnScrollBy.  However we live
	in a world with flaws where attempting such causes great pain for the trivial reward of 
	removing WM_HSCROLL	and WM_VSCROLL callbacks.  Perhaps another time.  Another revision. */

class CAcidViewView : public CView
{
protected: // create from serialization only
	CAcidViewView();
	DECLARE_DYNCREATE(CAcidViewView)

	int				m_scrollAmt, m_scrollTimer;

// Attributes
public:
	CImageContext	*m_context;

	bool			m_smoothScroll, m_enableScroll;
	CPoint			m_lastScrollPos;
	bool			m_fullRedraw;

	CBitmap			m_backBuffer[2];
	CSize			m_size, m_allocatedSize;
	bool			m_fullScreen;
	DEVMODE			m_oldMode;
	CRect			m_updateRC;

	CSize			m_fullScreenSize;
	int				m_slideShowDelay;
	clock_t			m_delayStart;

	CDC				*m_fullScreenDC, *m_memDC;

// Operations
public:

	CAcidViewDoc* GetDocument();
	void	ClearBackBuffer();
	BOOL	RecreateBackBuffer(int,int);
	void	DecreaseResolution();
	void	IncreaseResolution();
	void	SetResolution(ViewResolution);
	void	SetScrollBars(BOOL b); 
	void	SetSpeed(int i);
	void	ViewSauce();
	void	SmoothScroll();
	void	FullScreen();
	int		GetDestinationWidth();
	void	SetBINWidth();

	void	Refresh(bool animate=false);
	void	SpeedAlwaysOn();
	void	ChangeFont(FontType);
	void	ChangePalette(PaletteType);
	void	ToggleLineMode(int incAmt=1);
	void	ToggleSpeed();

	void	UpdateViewSauce(CCmdUI *);
	void	UpdateSpeedAlwaysOn(CCmdUI *);
	void	UpdateFonts(CCmdUI *);
	void	UpdateViewPalette(CCmdUI *);

	void	GetStatusString(CString &);
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAcidViewView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CAcidViewView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CAcidViewView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnMButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in AcidViewView.cpp
inline CAcidViewDoc* CAcidViewView::GetDocument()
   { return (CAcidViewDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_ACIDVIEWVIEW_H__C8093DBB_E30B_4DF5_AB6B_F529D50CBC96__INCLUDED_)
