#include <log4cpp/Category.hh>
#include <log4cpp/Appender.hh>
#include <log4cpp/OstreamAppender.hh>
#include <log4cpp/FileAppender.hh>
#include <log4cpp/Layout.hh>
#include <log4cpp/BasicLayout.hh>
#include <log4cpp/NDC.hh>

#include <caosGL/gfx/cSurfaceProvider.h>
#include <caosGL/gfx/cScene.h>
#include <caosGL/gfx/cTime.h>
#include <caosGL/gfx/cSceneGraph.h>
#include <caosGL/core/cEngine.h>
#include <caosGL/core/cParser.h>
#include <caosGL/core/cSystem.h>
#include <caosGL/core/cTimer.h>
#include <caosGL/core/cOpenGLWindow.h>
#include <caosGL/core/cSurface.h>
#include <caosGL/core/cRegistry.h>
#include <caosGL/core/cSndNode.h>

#include <windows.h>
#include <math.h>

using namespace caosGL::gfx;
using namespace caosGL::core;

static log4cpp::Category& cat = log4cpp::Category::getInstance ("cEngineTester");
cSndNode * muzik = cNULL;
static tBool paused = false;
static tInt xPos = 0;
static tDouble myTime = 0;

LRESULT CALLBACK wndProc (	HWND	hWnd,
							UINT	uMsg,
							WPARAM	wParam,
							LPARAM	lParam)
{
	switch (uMsg) {
	case WM_CLOSE:
		PostQuitMessage (0); 
		return 0;
	case WM_CHAR: 
		switch (wParam) {
		case 27:
//			MessageBox(NULL,"Petons!","caosGL!",MB_OK);
			PostQuitMessage (0); 
			return 0;
		case 'p':
			if (!paused) {
				cTime::stop ();
				if (muzik)
					muzik->pause();
				paused = true;
			} else {
				cTime::resume ();
				if (muzik)
					muzik->play();
				paused = false;
			}
			return 0;
		}
		break;
	case WM_KEYDOWN: 
		switch (wParam) {
		case VK_LEFT:
			if (paused) {
				cTime::set (cTime::elapsed () - 0.03);
				if (muzik) {
					muzik->pos (cTime::elapsed ());
				}
			}
			return 0;
		case VK_RIGHT:
			if (paused) {
				cTime::set (cTime::elapsed () + 0.03);
				if (muzik) {
					muzik->pos (cTime::elapsed ());
				}
			}
			return 0;
		}
		break;
	case WM_LBUTTONDOWN:
		xPos = LOWORD(lParam);
		myTime = cTime::elapsed ();
		break;
	case WM_MOUSEMOVE:
		if (paused) {
			if (wParam&MK_LBUTTON) {
				cTime::set (myTime + 0.01*(LOWORD(lParam)-xPos));
				if (muzik) {
					muzik->pos (cTime::elapsed ());
				}
				cat.error ("setting to: %f", (myTime + 0.01*(LOWORD(lParam)-xPos)));
			}
		}
		break;
	}
	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}


int main (int argc, const char *argv[]) {
	log4cpp::Appender * app0 = new log4cpp::FileAppender ("file", "consoleTester.log", true);
	log4cpp::Layout* layout0 = new log4cpp::BasicLayout();
	app0->setLayout(layout0);
	cat.addAppender (app0);
	log4cpp::Appender * app1 = new log4cpp::OstreamAppender ("default", &std::cout);
	log4cpp::Layout* layout1 = new log4cpp::BasicLayout();
	app1->setLayout(layout1);
	cat.addAppender (app1);
	cat.setPriority (1000);


	cAbsWindow * window = cOpenGLWindow::instance ();
	cSystem * sys = cSystem::instance ();

	if (!window->open (cParser::parseInt (sys->get("width")),
		cParser::parseInt (sys->get("height")), wndProc, cParser::parseBool (sys->get("fullscreen")))) {
		cat.error ("Shit!!");
	}

	tBool pedantic = cParser::parseBool (sys->get ("pedantic"));
	if (pedantic)
		Sleep (1500);

	string loadImgStr = pedantic?sys->get ("loadImg"):"null";
	cScene * clrScr, * loadImg;

	if (loadImgStr != "null") {
		clrScr = dynamic_cast <cScene*> (cRegistry::createNode ("caosGL::effects::cReseter", "loading.clr", cNULL));
		loadImg = dynamic_cast <cScene*> (cRegistry::createNode ("caosGL::effects::cImage", "loading.img", cNULL));

		clrScr->set ('colr', "true");clrScr->set ('dept', "true");clrScr->set ('proj', "true");clrScr->set ('modl', "true");
		loadImg->set ('file', loadImgStr);
		
		clrScr->compile ();
		loadImg->compile ();
		
		for (tInt i = 0; i<255; i+=5) {
			loadImg->set ('alph', i);
			clrScr->visit  (0); clrScr->draw  (0); clrScr->leave  ();
			loadImg->visit (0); loadImg->draw (0); loadImg->leave ();
			window->update ();
		}
	}
	
	cTimer timer;
	timer.start ();
	cEngine * engine = cEngine::instance ();
	engine->setUp ();
	timer.stop ();
	cat.info ("Loaded all in %f seconds.", timer.elapsed ());
	timer.set (0);

	if (loadImgStr != "null") {
		for (tInt j = 255; j>0; j-=5) {
			loadImg->set ('alph', j);
			clrScr->visit  (0); clrScr->draw  (0); clrScr->leave  ();
			loadImg->visit (0); loadImg->draw (0); loadImg->leave ();
			window->update ();
		}
	}

	if (pedantic)
		Sleep (1500);

	cSceneGraph::getRootNode ()->printTree();
	
	muzik = dynamic_cast <cSndNode*> (cRegistry::getNode ("muzik"));
	if (muzik)
		muzik->pos (cParser::parseDouble(sys->get ("start")));
	engine->start (cParser::parseDouble(sys->get ("start")));

	MSG		msg;
	bool doIt = true;
	timer.start ();
	tInt numFrames = 0;
	tInt lastSecFrames = 0;
	tInt thisSecFrames = 0;
	tFloat lastTime = timer.elapsed();
	while (doIt) {
		if (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE)) {
			if(msg.message == WM_QUIT)
				doIt = false;
			TranslateMessage (&msg);
			DispatchMessage (&msg);
		}  else {
			doIt = engine->update ();
			window->update ();
			++numFrames;
			++thisSecFrames;
/****************************************************************/
			if (!pedantic) {
				tFloat t = timer.elapsed();

				printf ("\rt=%.2f @ %.2ffps                        \r", cTime::elapsed (), ((lastSecFrames+thisSecFrames)/(t-lastTime+1)));
				if (t-lastTime > 1) {
					lastTime = t;
					lastSecFrames = thisSecFrames;
					thisSecFrames = 0;
				}
			}
/****************************************************************/
		}
	}
	timer.stop ();
	cat.info ("Did %i frames in %f seconds @ %f fps.", numFrames, timer.elapsed (), (numFrames/timer.elapsed ()));
	printf ("\nt=%.2f @ %.2ffps\n\n", cTime::elapsed (), ((lastSecFrames+thisSecFrames)/(timer.elapsed()-lastTime+1)));

	window->close ();
	return 
	msg.wParam;
}
