/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/gfx/cScene.h>

// extern includes
#include <caosGL/core/cTimer.h>
#include <caosGL/core/cParser.h>

#include <caosGL/gfx/cTime.h>

using namespace caosGL::core;

namespace caosGL {
	namespace gfx {
		/**
		 *<br> class:		cTime
		 *<br> namespace:	caosGL::gfx
		 *<br> inherits:	caosGL::gfx::cBaseNode
		 *<br> implements:	<none>
		 *<br> purpose:		encapsuates cTimer as a node.
		 *
		 */

		static vector <tAttr> attributeNames;
		static vector <caosGL::core::cTimer *> timers;
		static caosGL::core::cTimer timer;

		/********************************************************************************************/
		cTime::cTime (const string & n, cGroup * f) : super (n,f) {
			init ();
		}

		/********************************************************************************************/
		cTime::~cTime () {
			timers.clear ();
		}

		/********************************************************************************************/
		tVoid cTime::push () {
//			timers.push_back (new cTimer (timer));
		}

		/********************************************************************************************/
		tVoid cTime::pop () {
/*			if (timers.size () == 0) return;
			cTimer * t = timers.back ();
			timer = *t;
			timers.pop_back ();*/
		}

		/********************************************************************************************/
		const tInt cTime::level () {
			return timers.size ();
		}

		/********************************************************************************************/
		tVoid cTime::set (tFloat t) {
			timer.set (t);
		}

		/********************************************************************************************/
		tVoid cTime::start () {
			timer.start ();
		}

		/********************************************************************************************/
		tVoid cTime::resume () {
			timer.resume ();
		}

		/********************************************************************************************/
		tVoid cTime::stop () {
			timer.stop ();
		}

		/********************************************************************************************/
		const tFloat cTime::elapsed () {
			return timer.elapsed ();
		}

		/********************************************************************************************/
		const tLong cTime::frequency () {
			return timer.frequency ();
		}

		/********************************************************************************************/
		const tFloat cTime::resolution () {
			return timer.resolution ();
		}

		// from cBaseNode
		/********************************************************************************************/
		tBool cTime::compile () {
			return true;
		}

		// from cBaseNode
		/********************************************************************************************/
		tBool cTime::visit (tFloat t) {
			return evaluateAll (t);
		}

		// from cBaseNode
		/********************************************************************************************/
		tVoid cTime::leave () {
			return;
		}

		// from cBaseNode
		/********************************************************************************************/
		tBool cTime::init () {
			#define ATTRIB(n,t,v,d) ATTRIB_INIT_VAR(n,v)
			#include cTime_attribsFile
			#undef ATTRIB
			return true;
			return true;
		}

		// from cBaseNode
		/********************************************************************************************/
		const tBool cTime::set (const tDWord key, const string & value) {
			if (super::set (key, value)) return true;
			switch (key) {
				#define ATTRIB(n,t,v,d) ATTRIB_SET_S(n)
				#include cTime_attribsFile
				#undef ATTRIB
			case 'time': {timer.set (cParser::parseDouble (value));} return false;
			case '    ': return false;
			default: return false;
			}
			return false;
		}
		
		// from cBaseNode
		/********************************************************************************************/
		const tBool cTime::set (const tDWord key, const tFloat & value) {
			if (super::set (key, value)) return true;
			switch (key) {
				#define ATTRIB(n,t,v,d) ATTRIB_SET_N(n)
				#include cTime_attribsFile
				#undef ATTRIB
			case 'time': {timer.set (value);} return false;
			case '    ': return false;
			default: return false;
			}
			return false;
		}

		// from cBaseNode
		/********************************************************************************************/
		const tBool cTime::get (const tDWord key, string & value) const {
			if (super::get (key, value)) return true;
			switch (key) {
				#define ATTRIB(n,t,v,d) ATTRIB_GET(n)
				#include cTime_attribsFile
				#undef ATTRIB
			case 'time': { value = cParser::toString (timer.elapsed ()); } return false;
			case '    ': return false;
			default: return false;
			}
			return false;
		}

		// from cBaseNode
		/********************************************************************************************/
		const vector <tAttr> * cTime::getAttributeNames () const {
			if (attributeNames.size () == 0) {
				const vector <tAttr> * v = super::getAttributeNames ();
				attributeNames.insert (attributeNames.begin (), v->begin (), v->end ());
				#define ATTRIB(n,t,v,d) ATTRIB_ATTRIBNAMES(n,d)
				#include cTime_attribsFile
				#undef ATTRIB
				attributeNames.push_back(make_pair('time',string("Sets & gets the global time")));
			}
			return &attributeNames;
		}

		// from cBaseNode
		/********************************************************************************************/
		const string cTime::getTypeName () const { return "caosGL::gfx::cTime"; }
	}
}

// for node creation
#include <caosGL/core/cRegistry.h>
#include <caosGL/gfx/cNodeCreator.h>

class cTimeNodeCreator : public cNodeCreator {
public:
	cTimeNodeCreator () {
		name ("caosGL::gfx::cTime");
	}
	cBaseNode * createNode (const string n, cGroup * f) {
		return new caosGL::gfx::cTime (n,f);
	}
};
caosGL::core::cRegisterNodeCreator <cTimeNodeCreator> cTimeNodeCreatorInstance;

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof