/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
//#include <some.h>

// extern includes
#include <caosGL/core/cVFS.h>
#include <caosGL/core/cSurface.h>

using namespace caosGL::core;

#include <caosGL/gfx/cSurfaceProvider.h>

// much of this code has been shamelessly ripped from tesla, thx guys!

extern "C" {
#include <jpeglib.h>
#include <jerror.h>
}

typedef struct {
  struct jpeg_source_mgr pub;	/* public fields */
  JOCTET * buffer;		/* start of buffer */
  char	*name;			/* my file name */

} my_source_mgr;

struct my_error_mgr{
	struct jpeg_error_mgr pub;	/* "public" fields */
};
/*******************************************************************************************/
void term_source(j_decompress_ptr cinfo) {
}
/*******************************************************************************************/
void skip_input_data(j_decompress_ptr cinfo,long bytes_to_skip) {
	my_source_mgr* src;
	src= (my_source_mgr*)cinfo->src;
	src->pub.bytes_in_buffer-=bytes_to_skip;
	src->pub.next_input_byte+=bytes_to_skip;
}
/*******************************************************************************************/
unsigned char fill_input_buffer(j_decompress_ptr cinfo)
{
	return 0;
}
/*******************************************************************************************/
void init_source(j_decompress_ptr cinfo) {
}
/*******************************************************************************************/
void my_error_exit( j_common_ptr cinfo ) {

}

namespace caosGL {
	namespace gfx {
		/**
		 *<br> class:		cSurfaceProvider
		 *<br> namespace:	caosGL::gfx
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		Loads a .jpg as a cSurface.
		 *
		 */

		static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::gfx::cSurfaceProvider");
//		static cSurfaceProvider * _instance = cNULL;
//		static map <string,cSurface*> proxy;
		cSurfaceProvider * cSurfaceProvider::_instance = cNULL;
		map <string,cSurface*> cSurfaceProvider::proxy;

		/********************************************************************************************/
		cSurfaceProvider::cSurfaceProvider () {
		}

		/********************************************************************************************/
		cSurfaceProvider::~cSurfaceProvider () {
			
		}

		/********************************************************************************************/
		cSurfaceProvider * cSurfaceProvider::instance () {
			if (_instance == cNULL) {
				_instance = makeInstance ();
			}
			return _instance;
		}

		/********************************************************************************************/
		cSurfaceProvider * cSurfaceProvider::makeInstance () {
			return new cSurfaceProvider ();
		}

		/********************************************************************************************/
		caosGL::core::cSurface * cSurfaceProvider::getSurface (const string & names) {
			// i think that i'm only going to support the jpeg format
			// maybe the gif in some weird future, but not yet...

			// check if it's there already.
			map <string,cSurface *>::const_iterator it = proxy.find (names);
			if (it != proxy.end ()) {
				//cat.debug ("Found %s in the proxy", names.c_str ());
				return it->second;
			}
//			cat.alert ("<param name=\"file\" value=\"%s\" />", names.c_str());


			// ok, this is the default format for specifiying an image:
			// <t>;<fileName>,<alpha>
			// only the file name is compolsury
			// t can be either: 
			//   n = nearest
			//   l = linear
			//   m = mipmapping

			string alpha;
			string name;
			string opts;
			cGLTexture::eGLTextureType type = cGLTexture::eGLTextureType_Mipmap;
			// alpha name separation.
			int pos = names.find (',');
			if (pos != string::npos) {
				// got an alpha name, lets separate
				
				alpha = names.substr (pos+1,names.length()-pos);
				name = names.substr (0, pos);
				//cat.info ("Alpha image: %s & %s", name.c_str(), alpha.c_str ());
			} else {
				name = names;
			}

			pos = name.find (';');
			if (pos != string::npos) {
				// got type parameter
				cat.info ("Got filter type: %c", name[0]);
				switch (name[0]) {
				case 'n': type = cGLTexture::eGLTextureType_Nearest; break;
				case 'l': type = cGLTexture::eGLTextureType_Linear;  break;
				case 'm': type = cGLTexture::eGLTextureType_Mipmap;  break;

				}
				name = name.substr (pos+1, name.length()-pos);
			}

			istream * is = cVFS::instance ()->getStream (name);
			//cat.info ("Getting image %s", name.c_str ());
			
			if (is->good ()) {
			} else {
				cat.warn ("Tried to open %s, but failed.", name.c_str ());
				delete is;
				return cNULL;
			}
			
			is->seekg (0,ios_base::end);
			long length = is->tellg ();
			is->seekg (0);

			struct jpeg_decompress_struct cinfo;
			struct my_error_mgr jerr;
			JSAMPARRAY buffer; /* Output row buffer */
			int row_stride;    /* physical row width in output buffer */

			cSurface * surface = cNULL;

			unsigned int dwWidth, dwHeight, dwBPP;
			unsigned char * pRawData;

			/* init error handler */
			cinfo.err = jpeg_std_error( &jerr.pub );
			jerr.pub.error_exit = my_error_exit;


			/* init decompression */
			jpeg_create_decompress( &cinfo );

			my_source_mgr* src;

			if ( cinfo.src == 0 ) {
				cinfo.src=(struct jpeg_source_mgr*)(*cinfo.mem->alloc_small)((j_common_ptr)&cinfo,JPOOL_PERMANENT,sizeof(my_source_mgr));
				src = (my_source_mgr*)cinfo.src;
				src->buffer=(JOCTET *)(*cinfo.mem->alloc_small)((j_common_ptr)&cinfo,JPOOL_PERMANENT,length*sizeof(JOCTET));
			}


			tByte * buf = new tByte [length];
			is->read ((tChar*)src->buffer, length);

			src = (my_source_mgr*)cinfo.src;
			src->pub.init_source = init_source;
			src->pub.fill_input_buffer = fill_input_buffer;
			src->pub.skip_input_data = skip_input_data;
			src->pub.resync_to_restart = jpeg_resync_to_restart;
			src->pub.term_source = term_source;
			src->pub.bytes_in_buffer = length;   /* forces fill_input_buffer on first read */
			src->pub.next_input_byte = src->buffer; /* until buffer loaded */

			/* get info about jpeg file */
			jpeg_read_header( &cinfo, 1 );

			if ( cinfo.num_components == 1 ) 
				dwBPP = 8;
			else if ( cinfo.num_components == 3 ) 
				dwBPP = 24;
			else {
				delete is;
				delete [] buf;
				return surface;
			}

			dwWidth = cinfo.image_width;
			dwHeight = cinfo.image_height;
			pRawData = new unsigned char [dwWidth*dwHeight*(dwBPP>>3)];

			/* decompress data */
			jpeg_start_decompress( &cinfo );
			row_stride = cinfo.output_width*cinfo.output_components;

			buffer = (*cinfo.mem->alloc_sarray)((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);
			unsigned int dwRow = dwHeight;

			while( cinfo.output_scanline < cinfo.output_height ) {
				jpeg_read_scanlines( &cinfo, buffer, 1 );
				memcpy( pRawData + (--dwRow)*dwWidth*(dwBPP>>3), buffer[0], row_stride );
			}

			jpeg_finish_decompress( &cinfo );
			jpeg_destroy_decompress( &cinfo );

			/* create image */
			surface = new cSurface (names, dwWidth, dwHeight, type);

			tDWord * bbuf = surface->lock ();
			if (alpha.length() != 0) {
				cSurface * alphaS = getSurface (alpha);
				if (alphaS->width() == dwWidth && alphaS->height() == dwHeight) {
					tDWord * ab = alphaS->lock ();
					transfer (bbuf, pRawData, dwWidth, dwHeight, dwBPP, ab);
					alphaS->release ();
				}
			} else {
				transfer (bbuf, pRawData, dwWidth, dwHeight, dwBPP);
			}
			surface->release ();
			
			delete [] buf;
			delete [] pRawData;
			delete is;

			proxy.insert (map <string, cSurface *>::value_type (names, surface));


			return surface;
		}

		/********************************************************************************************/
		tVoid cSurfaceProvider::transfer (tDWord * buf, tByte * data, tInt width, tInt height, tInt bpp, tDWord * alpha) {
			if (alpha == cNULL) {
				switch (bpp) {
				case 8: {
					cat.error ("It's an 8 bit image, let's imagine it's greyscale for the moment, i'll put palette stuff in later.");
					for (tInt i = width*height ; i-->0;) {
						*buf++ = (tDWord) packRGB (*data, *data, *data); ++data;
					}
						} break;
				case 24: {
					for (tInt i = width*height ; i-->0;) {
						tByte r = *data++;
						tByte g = *data++;
						tByte b = *data++;
						*buf++ = packRGB (r,g,b);
					}
						} break;
				case 32: {
					for (tInt i = width*height ; i-->0;) {
						tByte r = *data++;
						tByte g = *data++;
						tByte b = *data++;
						tByte a = *data++;
						*buf++ = packARGB (a,r,g,b);
					}
						} break;
				default: {
					cat.error ("The number of bpp for the image to load is not valid (%d)",  bpp);
						 } break;
				}
			} else {
				switch (bpp) {
				case 8: {
					cat.error ("It's an 8 bit image, let's imagine it's greyscale for the moment, i'll put palette stuff in later.");
					for (tInt i = width*height ; i-->0;) {
						*buf++ = (tDWord) packRGB (*data, *data, *data); ++data;
					}
						} break;
				case 24: {
					for (tInt i = width*height ; i-->0;) {
						tInt a = (red (*alpha) + green (*alpha) + blue (*alpha)) / 3;
						++alpha;
						tByte r = *data++;
						tByte g = *data++;
						tByte b = *data++;
						*buf++ = packARGB (a,r,g,b);
//						*buf++ = packARGB (a,a,a,a);
					}
						} break;
				case 32: {
					for (tInt i = width*height ; i-->0;) {
						tByte r = *data++;
						tByte g = *data++;
						tByte b = *data++;
						tByte a = *data++;
						*buf++ = packARGB (a,r,g,b);
					}
						} break;
				default: {
					cat.error ("The number of bpp for the image to load is not valid (%d)",  bpp);
						 } break;
				}
			}
		}

		/********************************************************************************************/
		tVoid cSurfaceProvider::ensureSize (const tInt width, const tInt height) {
			tDWord bits = 0x01<<31;
			tInt w, h;

			while ((width&bits)==0&&bits)
				bits>>=1;
			w = bits;
			bits>>=1;
			while (bits) {
				if ((width&bits)!=0) {
					w <<= 1;
					break;
				}
				bits>>=1;
			}

			bits = 0x01<<31;
			while ((height&bits)==0&&bits)
				bits>>=1;
			h = bits;
			bits>>=1;
			while (bits) {
				if ((height&bits)!=0) {
					h <<= 1;
					break;
				}
				bits>>=1;
			}

		}
	}
}

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof