/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/gfx/cStateSet.h>

// extern includes
#include <caosGL/core/Dyngl.h>

#include <caosGL/gfx/cState.h>

#define MAX_OGL_CAPABILITIES 255

namespace caosGL {
	namespace gfx {
		/**
		 *<br> class:		cState
		 *<br> namespace:	caosGL::gfx
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		encapsulates openGL state changes
		 *
		 */

		cStateSet cState::stateSet;
	    static log4cpp::Category& cat = log4cpp::Category::getInstance ("gfx.cState");


		/********************************************************************************************/
		tVoid cState::apply (cStateSet & state) {
			stateSet = state;
			for (tInt i = 0; i < cState::oGL_LAST ; i+=2) {
				if (stateSet._cap[i])
					enable (static_cast<eState>(i));
				else 
					disable (static_cast<eState>(i));
			}

		}

		/********************************************************************************************/
		cStateSet & cState::getState () {
			return stateSet;
		}

		/********************************************************************************************/
		tVoid cState::enable (eState state) {
			if (stateSet._cap [state]) return;
			
//			cat.debug ("Called enable (%i) with miss",state);
			glEnable (stateSet._cap [state+1]);
			stateSet._cap [state] = 1;
		}
		/********************************************************************************************/
		tVoid cState::disable (eState state) {
			if (!stateSet._cap [state]) return;

//			cat.debug ("Called disable (%i) with miss",state);
			glDisable (stateSet._cap [state+1]);
			stateSet._cap [state] = 0;
		}

		/********************************************************************************************/
		tBool cState::isEnabled (eState state) {
			return stateSet._cap [state] == 1;
		}

		/********************************************************************************************/
		tVoid cState::value (tBool & value) {
			
		}
		
		/********************************************************************************************/
		tVoid cState::value (tFloat & value) {
		}
		
		/********************************************************************************************/
		tVoid cState::value (tDWord & value) {
		}

		/********************************************************************************************/
		tVoid cState::init () {
			// fuck this could be boring!
			stateSet._cap [oGL_ALPHA_TEST			+1] = GL_ALPHA_TEST;
			stateSet._cap [oGL_AUTO_NORMAL			+1] = GL_AUTO_NORMAL;
			stateSet._cap [oGL_BLEND				+1] = GL_BLEND;
			stateSet._cap [oGL_CLIP_PLANE0			+1] = GL_CLIP_PLANE0;
			stateSet._cap [oGL_CLIP_PLANE1			+1] = GL_CLIP_PLANE1;
			stateSet._cap [oGL_CLIP_PLANE2			+1] = GL_CLIP_PLANE2;
			stateSet._cap [oGL_CLIP_PLANE3			+1] = GL_CLIP_PLANE3;
			stateSet._cap [oGL_CLIP_PLANE4			+1] = GL_CLIP_PLANE4;
			stateSet._cap [oGL_CLIP_PLANE5			+1] = GL_CLIP_PLANE5;
			stateSet._cap [oGL_COLOR_MATERIAL		+1] = GL_COLOR_MATERIAL;
			stateSet._cap [oGL_CULL_FACE			+1] = GL_CULL_FACE;
			stateSet._cap [oGL_DEPTH_TEST			+1] = GL_DEPTH_TEST;
			stateSet._cap [oGL_DITHER				+1] = GL_DITHER;
			stateSet._cap [oGL_FOG					+1] = GL_FOG;
			stateSet._cap [oGL_LIGHT0				+1] = GL_LIGHT0;
			stateSet._cap [oGL_LIGHT1				+1] = GL_LIGHT1;
			stateSet._cap [oGL_LIGHT2				+1] = GL_LIGHT2;
			stateSet._cap [oGL_LIGHT3				+1] = GL_LIGHT3;
			stateSet._cap [oGL_LIGHT4				+1] = GL_LIGHT4;
			stateSet._cap [oGL_LIGHT5				+1] = GL_LIGHT5;
			stateSet._cap [oGL_LIGHT6				+1] = GL_LIGHT6;
			stateSet._cap [oGL_LIGHT7				+1] = GL_LIGHT7;
			stateSet._cap [oGL_LIGHTING				+1] = GL_LIGHTING;
			stateSet._cap [oGL_LINE_SMOOTH			+1] = GL_LINE_SMOOTH;
			stateSet._cap [oGL_LINE_STIPPLE			+1] = GL_LINE_STIPPLE;
			stateSet._cap [oGL_LOGIC_OP				+1] = GL_LOGIC_OP;
			stateSet._cap [oGL_MAP1_COLOR_4			+1] = GL_MAP1_COLOR_4;
			stateSet._cap [oGL_MAP1_INDEX			+1] = GL_MAP1_INDEX;
			stateSet._cap [oGL_MAP1_NORMAL			+1] = GL_MAP1_NORMAL;
			stateSet._cap [oGL_MAP1_TEXTURE_COORD_1	+1] = GL_MAP1_TEXTURE_COORD_1;
			stateSet._cap [oGL_MAP1_TEXTURE_COORD_2	+1] = GL_MAP1_TEXTURE_COORD_2;
			stateSet._cap [oGL_MAP1_TEXTURE_COORD_3	+1] = GL_MAP1_TEXTURE_COORD_3;
			stateSet._cap [oGL_MAP1_TEXTURE_COORD_4	+1] = GL_MAP1_TEXTURE_COORD_4;
			stateSet._cap [oGL_MAP1_VERTEX_3		+1] = GL_MAP1_VERTEX_3;
			stateSet._cap [oGL_MAP1_VERTEX_4		+1] = GL_MAP1_VERTEX_4;
			stateSet._cap [oGL_MAP2_COLOR_4			+1] = GL_MAP2_COLOR_4;
			stateSet._cap [oGL_MAP2_INDEX			+1] = GL_MAP2_INDEX;
			stateSet._cap [oGL_MAP2_NORMAL			+1] = GL_MAP2_NORMAL;
			stateSet._cap [oGL_MAP2_TEXTURE_COORD_1	+1] = GL_MAP2_TEXTURE_COORD_1;
			stateSet._cap [oGL_MAP2_TEXTURE_COORD_2	+1] = GL_MAP2_TEXTURE_COORD_2;
			stateSet._cap [oGL_MAP2_TEXTURE_COORD_3	+1] = GL_MAP2_TEXTURE_COORD_3;
			stateSet._cap [oGL_MAP2_TEXTURE_COORD_4	+1] = GL_MAP2_TEXTURE_COORD_4;
			stateSet._cap [oGL_MAP2_VERTEX_3		+1] = GL_MAP2_VERTEX_3;
			stateSet._cap [oGL_MAP2_VERTEX_4		+1] = GL_MAP2_VERTEX_4;
			stateSet._cap [oGL_NORMALIZE			+1] = GL_NORMALIZE;
			stateSet._cap [oGL_POINT_SMOOTH			+1] = GL_POINT_SMOOTH;
			stateSet._cap [oGL_POLYGON_SMOOTH		+1] = GL_POLYGON_SMOOTH;
			stateSet._cap [oGL_POLYGON_STIPPLE		+1] = GL_POLYGON_STIPPLE;
			stateSet._cap [oGL_SCISSOR_TEST			+1] = GL_SCISSOR_TEST;
			stateSet._cap [oGL_STENCIL_TEST			+1] = GL_STENCIL_TEST;
			stateSet._cap [oGL_TEXTURE_1D			+1] = GL_TEXTURE_1D;
			stateSet._cap [oGL_TEXTURE_2D			+1] = GL_TEXTURE_2D;
			stateSet._cap [oGL_TEXTURE_GEN_Q		+1] = GL_TEXTURE_GEN_Q;
			stateSet._cap [oGL_TEXTURE_GEN_R		+1] = GL_TEXTURE_GEN_R;
			stateSet._cap [oGL_TEXTURE_GEN_S		+1] = GL_TEXTURE_GEN_S;
			stateSet._cap [oGL_TEXTURE_GEN_T		+1] = GL_TEXTURE_GEN_T;
			for (tInt i = 0; i < cState::oGL_LAST ; i+=2) {
				stateSet._cap [i] = glIsEnabled (stateSet._cap [i+1]);
			}
		}
	}
}

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof