
/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/core/cRegistry.h>
#include <caosGL/gfx/cBaseNode.h>
#include <caosGL/gfx/cGroup.h>
#include <caosGL/gfx/cTime.h>
#include <caosGL/gfx/iDrawable.h>
#include <caosGL/gfx/cLayer.h>

// extern includes
#include <map>

#include <caosGL/gfx/cSceneGraph.h>


namespace caosGL {
	namespace gfx {
		/**
		 *<br> class:		cSceneGraph
		 *<br> namespace:	caosGL::gfx
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		Implements the functionality of a scene graph, which, in my case, is just a 
		 *					tree that can be traversed. The nodes are traversed depth-first. If the
		 *					visit () method of a given node returns false, no further traversal will
		 *					be done down that branch.
		 *
		 */

		static log4cpp::Category& cat = log4cpp::Category::getInstance ("sys.sceneGraph");

		/********************************************************************************************/
		static cLayer * rn = dynamic_cast<cLayer*> (caosGL::core::cRegistry::createNode("caosGL::gfx::cLayer", "world", cNULL));
		
		/********************************************************************************************/
		cSceneGraph::cSceneGraph () {
		}

		/********************************************************************************************/
		cSceneGraph::~cSceneGraph () {
		}

		/********************************************************************************************/
		tBool cSceneGraph::compile () {
			return compile (rn->getNodes ());
		}

		/********************************************************************************************/
		tBool cSceneGraph::compile (const tNodeList * nodeList) {
			tBool ret = false;
			for (tNodeList::const_iterator it = nodeList->begin (); it != nodeList->end (); it++) {
				cBaseNode * bn = (*it);
				cGroup * gr = dynamic_cast <cGroup *> (bn);
				if (gr) {
					compile (gr->getNodes ());
				}
				
				bn->compile ();

				ret = true;
			}
			return ret;
		}

		/********************************************************************************************/
		cGroup * cSceneGraph::getRootNode () {
			return rn;
		}

		/********************************************************************************************/
		tBool cSceneGraph::traverse () {
//**/		cat.info ("_____________________________\nTraversing graph at time %f", cTime::elapsed ());
			return traverse (rn->getNodes (), cTime::elapsed ());
		}

		/********************************************************************************************/
		tBool cSceneGraph::traverse (const tNodeList * nodeList, tFloat t) {
			tBool ret = false;
			for (tNodeList::const_iterator it = nodeList->begin (); it != nodeList->end (); it++) {
				cBaseNode * bn = (*it);
				
				if (!bn->visit (t)) {
//**/				cat.debug ("DID NOT VISIT %s::%s", bn->getTypeName ().c_str (), bn->name ().c_str ());
					continue;
				}
//**/			cat.debug ("Visiting node %s::%s", bn->getTypeName ().c_str (), bn->name ().c_str ());


				iDrawable * dr = dynamic_cast <iDrawable *> (bn);
				if (dr) {
					dr->draw (t);
				}

				cGroup * gr = dynamic_cast <cGroup *> (bn);
				if (gr) {
					traverse (gr->getNodes (), t);
				}

//**/			cat.debug ("Leaving node %s", bn->name ().c_str ());

				bn->leave ();
				ret = true;
			}
			return ret;
		}
	}
}

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof