/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes

// extern includes
#include <caosGL/core/cVFS.h>
#include <caosGL/core/cParser.h>
#include <caosGL/core/cRegistry.h>
#include <caosGL/core/cUtil.h>
#include <caosGL/gfx/cAnimCurveReader.h>
#include <caosGL/gfx/cMesh.h>
#include <caosGL/gfx/caosnodeTypes.h>
#include <caosGL/gfx/caoschunks.h>
#include <caosGL/gfx/caoshelper.h>

#include <caosGL/gfx/c3DLoader.h>

using namespace caosGL::core;

namespace caosGL {
	namespace gfx {
		/**
		 *<br> class:		c3DLoader
		 *<br> namespace:	caosGL::gfx
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		Loads a scene into a cGroup.
		 *
		 */

		static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::gfx::c3DLoader");
		c3DLoader * c3DLoader::_instance = cNULL;
		/********************************************************************************************/
		c3DLoader::c3DLoader () { } 
		/********************************************************************************************/
		c3DLoader::~c3DLoader () {} 
		/********************************************************************************************/
		c3DLoader * c3DLoader::instance () {
			if (_instance == cNULL) {
				_instance = makeInstance ();
			}
			return _instance;
		}
		/********************************************************************************************/
		c3DLoader * c3DLoader::makeInstance () {
			return new c3DLoader ();
		}

		// as i said, normal stuff...
		/********************************************************************************************/
		cGroup * c3DLoader::loadCaos (const string & file, const string & pre) {
			bc = 0; // reset bytecount...
			s = cVFS::instance()->getStream(file);
			fileName = file;
			prefix = pre + ".";
			node = rootNode = dynamic_cast<cGroup*> (caosGL::core::cRegistry::createNode("caosGL::gfx::cLayer", pre+"3d", cNULL));
			if (s->good ()) {
				read ();
				delete s;
				return rootNode;
			}
			delete s;
			return cNULL;
		}

		/********************************************************************************************/
		tBool c3DLoader::read () {
			if (!readHeader ()) return false;

			tDWord fli;
			tBool goOn = true;
			while (!eof()&&goOn) {
				if (!read(fli))
					break;

				switch (fli) {
				case fliCnkObjS:
					readObjStart ();
					break;
				default:
					cat.error ("Unknown or unexpected chunk #%s#, %x", cUtil::doFli(fli).c_str (), bc);
					goOn = false;
					break;
				}
				if (eof()) break;
			}
			return true;
		}

		/********************************************************************************************/
		tBool c3DLoader::readHeader () {
			tDWord fli;
			read (fli);
			if (fli != fliCnkHeader) {
				cat.error ("Not a header chunk");
				return false;
			}

			chunkHeader cnk;
			read (cnk.versionMajor);
			read (cnk.versionMinor);
			read (cnk.sizeN);
			read (cnk.sizeW);

			read (strBuf, cnk.sizeN);
			strBuf [cnk.sizeN] = '\0';
			name = strBuf;

			read (strBuf, cnk.sizeW);
			strBuf [cnk.sizeW] = '\0';
			writer = strBuf;

			cat.info ("Loading 3D scene version %i.%i (%s,%s)", cnk.versionMajor, 
				cnk.versionMinor, name.c_str(), writer.c_str());

			return true;
		}

		/********************************************************************************************/
		tBool c3DLoader::readAttribS () {
			chunkAttrS cnk;
			read (cnk.name);
			read (cnk.size);
			read (strBuf, cnk.size);
			strBuf [cnk.size] = '\0';
			string val (strBuf);
			if (cnk.name==cObji::fthr) { // shit thing so as to not muck up the graph!
				if (val != "world") {
					val = prefix + val;
					node->set(cnk.name,val);
					gotAFather = true;
				}
			} else {
				/**
				 * TODO: take this out!
				 */
				if (cnk.name=='file')
					node->set('tex',val);
				else 
					node->set(cnk.name,val);
			}
			return true;
		}

		/********************************************************************************************/
		tBool c3DLoader::readAttribD () {
			chunkAttr cnk;
			double v;
			read (cnk.name);
			read (v);
			node->set (cnk.name, v);
			return true;
		}

		/********************************************************************************************/
		tBool c3DLoader::readAttribI () {
			chunkAttr cnk;
			int v;
			read (cnk.name);
			read (v);
			node->set (cnk.name, v);
			return true;
		}

		/********************************************************************************************/
		tBool c3DLoader::readAttribB () {
			chunkAttr cnk;
			tBool v;
			read (cnk.name);
			read (v);
			node->set (cnk.name, cParser::toString(v));
			return true;
		}

		/********************************************************************************************/
		tBool c3DLoader::readObjStart () {
			tBool ret = true;
			chunkObjStart cnk;
			read (cnk.sizeT);
			read (cnk.sizeN);
			read (strBuf, cnk.sizeT);
			strBuf [cnk.sizeT] = '\0';
			type = strBuf;

			read (strBuf, cnk.sizeN);
			strBuf [cnk.sizeN] = '\0';
			name = strBuf;
			name = prefix + name;

			node = caosGL::core::cRegistry::createNode(nodeHelper(type), name, cNULL);
			if (node == cNULL) {
				return false;
			}

			gotAFather = false;

			tDWord fli;
			tBool goOn = true;
			while (!eof()&&goOn) {
				if (!read(fli))
					break;
				switch (fli) {
				case fliCnkAttrBool: {
					readAttribB();
					break;
				}
				case fliCnkAttrDouble: {
					readAttribD();
					break;
				}
				case fliCnkAttrInt: {
					readAttribI();
					break;
				}
				case fliCnkAttrString: {
					readAttribS();
					break;
				}
				case fliCnkMeshV: {
					readMeshVertexList ();
					break;
				}
				case fliCnkMeshF: {
					readMeshFaceList ();
					break;
				}
				case fliCnkMeshUV: {
					readMeshUVList ();
					break;
				}
				case fliCnkMeshN: {
					readMeshNormalList ();
					break;
				}
				case fliCnkMeshEdge: {
					readMeshEdgeList ();
					break;
				}
				case fliCnkObjE: {
					readObjEnd ();
					goOn = false;
					break;
				}
				case fliCnkCurveStart: {
					readCurveStart ();
					break;
				}
				default: {
					cat.error ("Unknown or unexpected chunk #%s#, %x", cUtil::doFli(fli).c_str (), bc);
					goOn = false;
					ret = false;
					break;
				}
				}
			}
			return ret;
		}

		/********************************************************************************************/
		tBool c3DLoader::readObjEnd () {
			if (!gotAFather) {
				node->set (cObji::fthr, rootNode->name());
			}
			return true;
		}

		/********************************************************************************************/
		tBool c3DLoader::readCurveStart () {
			tBool ret = true;
			chunkCurveStart cnk;
			read (cnk.sizeN);
			read (cnk.sizeO);
			read (cnk.attribFLI);
			attr = cnk.attribFLI;
			read ((tVoid*)&cnk.preInfinity, sizeof(cnk.preInfinity));
			read ((tVoid*)&cnk.postInfinity, sizeof(cnk.postInfinity));

			read (strBuf, cnk.sizeN);
			strBuf [cnk.sizeN] = '\0';
			name = strBuf;
			name = prefix + name; 

			read (strBuf,  cnk.sizeO);
			strBuf  [cnk.sizeO] = '\0';
			obj = strBuf;
			obj = prefix + name;

			keys.clear ();
//**/			cat.info ("Current obj: %s; curve: %s", node->name().c_str(), name.c_str());
			tDWord fli;
			tBool goOn = true;
			while (!eof()&&goOn) {
				read (fli);
				switch (fli) {
				case fliCnkCurveKey: {
					readKey ();
					break;
				}
				case fliCnkCurveEnd: {
					cAnimCurve * ac = cAnimCurveReader::assembleAnimCurve (name, keys, true, false);
					ac->obj(obj);
					ac->attr(attr);
					ac->set ('strt', -HUGE);
					ac->set ('end',   HUGE);
					ac->preInfinity((caosGL::gfx::cAnimCurve::eInfinityType)cnk.preInfinity);
					ac->postInfinity((caosGL::gfx::cAnimCurve::eInfinityType)cnk.postInfinity);
					node->addEvaluatable (ac);
					readCurveEnd ();
					goOn = false;
					break;
				}
				default: {
					cat.error ("Unknown or unexpected chunk #%s#, %x", cUtil::doFli(fli).c_str (), bc);
					goOn = false;
					ret = false;
					break;
				}
				}
			}
			return ret;
		}

		/********************************************************************************************/
		tBool c3DLoader::readKey () {
			cReadKey * key = new cReadKey ();
			double v;
			read (v);key->time=v;
			read (v);key->value=v;
			read ((tVoid*)&key->inTangentType, sizeof(key->inTangentType));
			read ((tVoid*)&key->outTangentType, sizeof(key->outTangentType));
			read (v);key->inAngle=v;
			read (v);key->inWeight=v;
			read (v);key->outAngle=v;
			read (v);key->outWeight=v;
			keys.push_back (key);
//**/			cat.info ("\t\tKey: %f, %f", key->time, key->value);
			return true;
		}

		/********************************************************************************************/
		tBool c3DLoader::readCurveEnd () {
			return true;
		}

		/********************************************************************************************/
		tBool c3DLoader::readMeshVertexList () {
			chunkMeshList cnk;
			read (cnk.num);
			tVector * vList = new tVector [cnk.num];
			read (vList, sizeof(tVector)*cnk.num);
			
			cMesh * msh = dynamic_cast <cMesh*> (node);
			if (msh) {
				msh->addVertexList (vList, cnk.num);
			}
			delete [] vList;
			return true;
		}

		/********************************************************************************************/
		tBool c3DLoader::readMeshFaceList () {
			chunkMeshList cnk;
			read (cnk.num);
			tFace * fList = new tFace [cnk.num];
			read (fList, sizeof(tFace)*cnk.num);

			cMesh * msh = dynamic_cast <cMesh*> (node);
			if (msh) {
				msh->addFaceList (fList, cnk.num);
			}
			delete [] fList;
			return true;
		}

		/********************************************************************************************/
		tBool c3DLoader::readMeshUVList () {
			chunkMeshList cnk;
			read (cnk.num);
			tUV * uvList = new tUV [cnk.num];
			read (uvList, sizeof(tUV)*cnk.num);

			cMesh * msh = dynamic_cast <cMesh*> (node);
			if (msh) {
				msh->addUVList (uvList, cnk.num);
			}
			delete [] uvList;
			return true;
		}

		/********************************************************************************************/
		tBool c3DLoader::readMeshNormalList () {
			chunkMeshList cnk;
			read (cnk.num);
			tNormal * nList = new tNormal [cnk.num];
			read (nList, sizeof(tNormal)*cnk.num);

			cMesh * msh = dynamic_cast <cMesh*> (node);
			if (msh) {
				msh->addNormalList (nList, cnk.num);
			}
			delete [] nList;
			return true;
		}

		/********************************************************************************************/
		tBool c3DLoader::readMeshEdgeList () {
			chunkMeshList cnk;
			read (cnk.num);
			tEdge * eList = new tEdge [cnk.num];
			read (eList, sizeof(tEdge)*cnk.num);

			cMesh * msh = dynamic_cast <cMesh*> (node);
			if (msh) {
				msh->addEdgeList (eList, cnk.num);
			}
			delete [] eList;
			return true;
		}

		/********************************************************************************************/
		tBool c3DLoader::read (tDWord & v) {
			s->read ((tChar*)&v, sizeof(v));
			bc+=s->gcount();
			if (s->good()) return true;
			return false;
		}

		/********************************************************************************************/
		tBool c3DLoader::read (tInt & v) {
			s->read ((tChar*)&v, sizeof(v));
			bc+=s->gcount();
			if (s->good()) return true;
			return false;
		}

		/********************************************************************************************/
		tBool c3DLoader::read (tDouble & v) {
			s->read ((tChar*)&v, sizeof(v));
			bc+=s->gcount();
			if (s->good()) return true;
			return false;
		}

		/********************************************************************************************/
		tBool c3DLoader::read (tFloat & v) {
			s->read ((tChar*)&v, sizeof(v));
			bc+=s->gcount();
			if (s->good()) return true;
			return false;
		}

		/********************************************************************************************/
		tBool c3DLoader::read (tBool & v) {
			s->read ((tChar*)&v, sizeof(v));
			bc+=s->gcount();
			if (s->good()) return true;
			return false;
		}

		/********************************************************************************************/
		tBool c3DLoader::read (tVoid * b, tDWord l) {
			s->read ((tChar*)b, l);
			bc+=s->gcount();
			if (s->good()) return true;
			return false;
		}

		/********************************************************************************************/
		tBool c3DLoader::eof() {
			return s->eof();
		}
	}
}

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof