/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/gfx/cScene.h>

// extern includes
#include <caosGL/gfx/cMatrix.h>
#include <caosGL/gfx/cVector.h>
#include <caosGL/gfx/cTextureSpace.h>
#include <caosGL/core/cOpenGLWindow.h>
#include <caosGL/core/cParser.h>
#include <caosGL/core/Dyngl.h>
#include <caosGL/core/math.h>
#include <caosGL/gfx/cState.h>
#include <gl\glu.h>

using namespace caosGL::gfx;
using namespace caosGL::core;

#define cVirus_attribsFile <caosGL/effects/cVirus.attribs>

namespace caosGL {
	namespace effects {
		static vector <tAttr> attributeNames;
		static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::effects::cVirus");

		class cViral {
		public:
			cViral () {sub=cNULL;}
			cViral (cViral * v) { set (v->p.x, v->p.y, v->p.z, v->d.x, v->d.y, v->d.z, v->w); d *= v->s; sub=cNULL;}
			cViral (tFloat x, tFloat y, tFloat z, tFloat dx, tFloat dy, tFloat dz, tFloat _w) { set (x,y,z,dx,dy,dz,_w); sub=cNULL;}
			tFloat s,w;
			cVector d,p,r;
			cViral * sub;
			tVoid set (tFloat x, tFloat y, tFloat z, tFloat dx, tFloat dy, tFloat dz, tFloat _w) {
				p.set (x, y, z);
				d.set (dx,dy,dz);
				w = _w;
				r.set(0,0,0);
			}
			tVoid update (cViral & v) {
				cMatrix m;
				m.makeTrans (d.x,d.y,d.z);
				m.postRot(v.r.z,  0, 0,-1);
				m.postRot(v.r.y,  0,-1, 0);
				m.postRot(v.r.x, -1, 0, 0);
				cVector n = v.p - m.getTrans();
				p += (n-p)*w;
				r = v.r;
			}
		};

		/**
		 *<br> class:		cVirus
		 *<br> namespace:	caosGL::effects
		 *<br> inherits:	caosGL::gfx::cScene
		 *<br> implements:	<none>
		 *<br> purpose:		A 6-legged virus. You just gotta love it!!
		 *
		 */

		class CAOSGL_API cVirus : public cScene {
			typedef cScene super;
		private:
			#define ATTRIB(n,t,v,d) ATTRIB_DEFINE_VAR(n,t)
			#include cVirus_attribsFile
			#undef ATTRIB
			string _fileName;
			tInt _list;
			cGLTexture * _img;
			cViral _root;
			cViral *ns[6]; // up, down, front, back, left, right

		public:
			/********************************************************************************************/
			cVirus (const string n, cGroup * f) : super (n,f) {
				init ();
			}

			/********************************************************************************************/
			~cVirus () {
			}

			/********************************************************************************************/
			tFloat ran (tFloat range) const {
				return (static_cast <tFloat> (rand ())/0x7fff)*range;
			}

			/********************************************************************************************/
			tBool draw (const tFloat time) {
//cat.info ("pos:%f,%f,%f;", _root.p.x, _root.p.y, _root.p.z);
				cViral *p0,*p1;
				glScaled (0.4,0.4,0.4);
				if (_img) {
					_img->prepare ();
					cState::enable (cState::oGL_TEXTURE_2D);
				} else {
					cState::disable (cState::oGL_TEXTURE_2D);
				}
				glMatrixMode(GL_PROJECTION);
				glPushMatrix ();
				glLoadIdentity();

				gluPerspective (80.0,1.3,0.01,100.0);
				glTranslatef (0, 0, -3);
				glMatrixMode(GL_MODELVIEW);

				cState::enable (cState::oGL_DEPTH_TEST);
				cState::disable (cState::oGL_LIGHTING);
				cState::enable (cState::oGL_BLEND);
				glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
				glColor4f (1,1,1,1);

				glLoadIdentity ();
				// root node...
				_root.p.x = _tX; _root.p.y = _tY; _root.p.z = _tZ; 
				_root.r.x = _rX; _root.r.y = _rY; _root.r.z = _rZ; 

				glTranslated (_root.p.x, _root.p.y, _root.p.z);
				glRotatef (_root.r.x, 1,0,0);
				glRotatef (_root.r.y, 0,1,0);
				glRotatef (_root.r.z, 0,0,1);
				glCallList(_list);
				glPopMatrix ();


				for (tInt i = 6; i-->0;) {
					glLoadIdentity ();
					ns[i]->update(_root);
					glTranslated (ns[i]->p.x, ns[i]->p.y, ns[i]->p.z);
					glRotatef (ns[i]->r.x, 1,0,0);
					glRotatef (ns[i]->r.y, 0,1,0);
					glRotatef (ns[i]->r.z, 0,0,1);
					glCallList(_list);
					p0 = ns[i]->sub;
					p1 = ns[i];
					while (p0) {
						glLoadIdentity ();
						p0->update(*p1);
						glTranslated (p0->p.x, p0->p.y, p0->p.z);
						glRotatef (p0->r.x, 1,0,0);
						glRotatef (p0->r.y, 0,1,0);
						glRotatef (p0->r.z, 0,0,1);
						glScaled (p0->s, p0->s, p0->s);
						glCallList(_list);
						p1 = p0;
						p0 = p0->sub;
					}
				}
				glMatrixMode(GL_PROJECTION);
				glPopMatrix ();
				return true;
			}

			// from iDrawable
			/********************************************************************************************/
			tBool transparent () const {
				return false;
			}

			// from iDrawable
			/********************************************************************************************/
			tVoid transparent (const tBool trasnp) {
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool compile () {
				if (_tex != "")
					_img = cTextureSpace::instance ()->get (_tex);
				_root.p.x = _tX; _root.p.y = _tY; _root.p.z = _tZ; 
				_root.r.x = _rX; _root.r.y = _rY; _root.r.z = _rZ; 
				_list = glGenLists (1);
				glNewList (_list, GL_COMPILE_AND_EXECUTE); {
					glBegin (GL_QUADS); {
						// up side 
						//glColor3ub (rand()%255, rand()%255, rand()%255);
						glTexCoord2f (0.0f, 0.0f); glVertex3f ( -0.10,  0.11, -0.10);
						glTexCoord2f (1.0f, 0.0f); glVertex3f (  0.10,  0.11, -0.10);
						glTexCoord2f (1.0f, 1.0f); glVertex3f (  0.10,  0.11,  0.10);
						glTexCoord2f (0.0f, 1.0f); glVertex3f ( -0.10,  0.11,  0.10);

						// down side, reverse winding
						//glColor3ub (rand()%255, rand()%255, rand()%255);
						glTexCoord2f (0.0f, 0.0f); glVertex3f ( -0.10, -0.11,  0.10);
						glTexCoord2f (1.0f, 0.0f); glVertex3f (  0.10, -0.11,  0.10);
						glTexCoord2f (1.0f, 1.0f); glVertex3f (  0.10, -0.11, -0.10);
						glTexCoord2f (0.0f, 1.0f); glVertex3f ( -0.10, -0.11, -0.10);

						// front
						//glColor3ub (rand()%255, rand()%255, rand()%255);
						glTexCoord2f (0.0f, 0.0f); glVertex3f ( -0.10,  0.10,  0.11);
						glTexCoord2f (1.0f, 0.0f); glVertex3f (  0.10,  0.10,  0.11);
						glTexCoord2f (1.0f, 1.0f); glVertex3f (  0.10, -0.10,  0.11);
						glTexCoord2f (0.0f, 1.0f); glVertex3f ( -0.10, -0.10,  0.11);

						// back, reverse winding
						//glColor3ub (rand()%255, rand()%255, rand()%255);
						glTexCoord2f (0.0f, 0.0f); glVertex3f ( -0.10, -0.10, -0.11);
						glTexCoord2f (1.0f, 0.0f); glVertex3f (  0.10, -0.10, -0.11);
						glTexCoord2f (1.0f, 1.0f); glVertex3f (  0.10,  0.10, -0.11);
						glTexCoord2f (0.0f, 1.0f); glVertex3f ( -0.10,  0.10, -0.11);

						// right
						//glColor3ub (rand()%255, rand()%255, rand()%255);
						glTexCoord2f (0.0f, 0.0f); glVertex3f (  0.11,  0.10,  0.10);
						glTexCoord2f (1.0f, 0.0f); glVertex3f (  0.11,  0.10, -0.10);
						glTexCoord2f (1.0f, 1.0f); glVertex3f (  0.11, -0.10, -0.10);
						glTexCoord2f (0.0f, 1.0f); glVertex3f (  0.11, -0.10,  0.10);

						// back, reverse winding
						//glColor3ub (rand()%255, rand()%255, rand()%255);
						glTexCoord2f (0.0f, 0.0f); glVertex3f ( -0.11, -0.10,  0.10);
						glTexCoord2f (1.0f, 0.0f); glVertex3f ( -0.11, -0.10, -0.10);
						glTexCoord2f (1.0f, 1.0f); glVertex3f ( -0.11,  0.10, -0.10);
						glTexCoord2f (0.0f, 1.0f); glVertex3f ( -0.11,  0.10,  0.10);
					} glEnd ();
				} glEndList ();

				cViral *ut,*dt,*lt,*rt,*ft,*bt;
				ns[0] = new cViral ( 0.0 +_root.p.x, 0.23+_root.p.y, 0.0 +_root.p.z, 0.0 , 0.23, 0.0 , _hard);ut=ns[0];ns[0]->s = 1;
				ns[1] = new cViral ( 0.0 +_root.p.x,-0.23+_root.p.y, 0.0 +_root.p.z, 0.0 ,-0.23, 0.0 , _hard);dt=ns[1];ns[1]->s = 1;
				ns[2] = new cViral (-0.23+_root.p.x, 0.0 +_root.p.y, 0.0 +_root.p.z,-0.23, 0.0 , 0.0 , _hard);lt=ns[2];ns[2]->s = 1;
				ns[3] = new cViral ( 0.23+_root.p.x, 0.0 +_root.p.y, 0.0 +_root.p.z, 0.23, 0.0 , 0.0 , _hard);rt=ns[3];ns[3]->s = 1;
				ns[4] = new cViral ( 0.0 +_root.p.x, 0.0 +_root.p.y, 0.23+_root.p.z, 0.0 , 0.0 , 0.23, _hard);ft=ns[4];ns[4]->s = 1;
				ns[5] = new cViral ( 0.0 +_root.p.x, 0.0 +_root.p.y,-0.23+_root.p.z, 0.0 , 0.0 ,-0.23, _hard);bt=ns[5];ns[5]->s = 1;
				for (tInt i = 0; i < _num ; i++) {
					cViral * u1 = new cViral (ut);u1->s = ((0.95/_num)*(_num-i)+0.05);ut->sub = u1; ut = u1;
					cViral * d1 = new cViral (dt);d1->s = ((0.95/_num)*(_num-i)+0.05);dt->sub = d1; dt = d1;
					cViral * l1 = new cViral (lt);l1->s = ((0.95/_num)*(_num-i)+0.05);lt->sub = l1; lt = l1;
					cViral * r1 = new cViral (rt);r1->s = ((0.95/_num)*(_num-i)+0.05);rt->sub = r1; rt = r1;
					cViral * f1 = new cViral (ft);f1->s = ((0.95/_num)*(_num-i)+0.05);ft->sub = f1; ft = f1;
					cViral * b1 = new cViral (bt);b1->s = ((0.95/_num)*(_num-i)+0.05);bt->sub = b1; bt = b1;
				}
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool visit (tFloat t) {
				if (!cBaseNode::visit (t)) return false;
				evaluateAll (t);
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			tVoid leave () {
				return;
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool init () {
				#define ATTRIB(n,t,v,d) ATTRIB_INIT_VAR(n,v)
				#include cVirus_attribsFile
				#undef ATTRIB
				_img = cNULL;
				_list = -1;
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool set (const tDWord key, const string & value) {
				if (super::set (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_SET_S(n)
					#include cVirus_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool set (const tDWord key, const tFloat & value) {
				if (super::set (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_SET_N(n)
					#include cVirus_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool get (const tDWord key, string & value) const {
				if (super::get (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_GET(n)
					#include cVirus_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const vector <tAttr> * getAttributeNames () const {
				if (attributeNames.size () == 0) {
					const vector <tAttr> * v = super::getAttributeNames ();
					attributeNames.insert (attributeNames.begin (), v->begin (), v->end ());
					#define ATTRIB(n,t,v,d) ATTRIB_ATTRIBNAMES(n,d)
					#include cVirus_attribsFile
					#undef ATTRIB
				}
				return &attributeNames;
			}

			// from cBaseNode
			/********************************************************************************************/
			const string getTypeName () const { return "caosGL::effects::cVirus"; }
		};
	}
}

// for node creation
#include <caosGL/core/cRegistry.h>
#include <caosGL/gfx/cNodeCreator.h>

class cVirusNodeCreator : public cNodeCreator {
public:
	cVirusNodeCreator () {
		name ("caosGL::effects::cVirus");
	}
	cBaseNode * createNode (const string n, cGroup * f) {
		return new caosGL::effects::cVirus (n,f);
	}
};
caosGL::core::cRegisterNodeCreator <cVirusNodeCreator> cVirusNodeCreatorInstance;

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof