/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/gfx/cGroup.h>

// extern includes
#include <caosGL/gfx/cTextureSpace.h>
#include <caosGL/core/cGLTextureSpace.h>
#include <caosGL/core/cGLTexture.h>
#include <caosGL/core/cParser.h>
#include <caosGL/core/Dyngl.h>
#include <caosGL/gfx/cState.h>
#include <GL/glu.h>

using namespace caosGL::gfx;
using namespace caosGL::core;

#define cRenderToTexture_attribsFile <caosGL/effects/cRenderToTexture.attribs>

namespace caosGL {
	namespace effects {
		static vector <tAttr> attributeNames;
		static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::effects::cRenderToTexture");

		/**
		 *<br> class:		cRenderToTexture
		 *<br> namespace:	caosGL::effects
		 *<br> inherits:	caosGL::gfx::cGroup
		 *<br> implements:	<none>
		 *<br> purpose:		Sets the view port up to render in a ^2-sized window, then caputers that 
		 *					texture for use somewhere else.
		 *
		 */

		class CAOSGL_API cRenderToTexture : public cGroup {
			typedef cGroup super;
		private:
			#define ATTRIB(n,t,v,d) ATTRIB_DEFINE_VAR(n,t)
			#include cRenderToTexture_attribsFile
			#undef ATTRIB
			tInt _vp [4];
			cGLTexture * _texture;

		public:
			/********************************************************************************************/
			cRenderToTexture (const string n, cGroup * f) : super (n,f) {
				init ();
			}

			/********************************************************************************************/
			~cRenderToTexture () {
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool compile () {
				if (_tex == "") {
					cat.error ("I must know the texture name at scene compile time");
					return false;
				}
				_texture = cTextureSpace::instance ()->get (_tex);
				_texture->generate ();
//				cTextureSpace::instance ()->put (_tex, _texture);
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool visit (tFloat t) {
				evaluateAll (t);
				if (!cBaseNode::visit (t))
					return false;

				// i need to get it everytime, just in case, which, basically, sux
				glGetIntegerv (GL_VIEWPORT, _vp);
				glViewport (0, 0, _sizX, _sizY);
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			tVoid leave () {
				_texture->prepare ();
				glCopyTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, 0, 0, _sizX, _sizY, 0);
				glViewport (_vp[0], _vp[1], _vp[2], _vp[3]);
				return;
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool init () {
				#define ATTRIB(n,t,v,d) ATTRIB_INIT_VAR(n,v)
				#include cRenderToTexture_attribsFile
				#undef ATTRIB
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool set (const tDWord key, const string & value) {
				if (super::set (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_SET_S(n)
					#include cRenderToTexture_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool set (const tDWord key, const tFloat & value) {
				if (super::set (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_SET_N(n)
					#include cRenderToTexture_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool get (const tDWord key, string & value) const {
				if (super::get (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_GET(n)
					#include cRenderToTexture_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const vector <tAttr> * getAttributeNames () const {
				if (attributeNames.size () == 0) {
					const vector <tAttr> * v = super::getAttributeNames ();
					attributeNames.insert (attributeNames.begin (), v->begin (), v->end ());
					#define ATTRIB(n,t,v,d) ATTRIB_ATTRIBNAMES(n,d)
					#include cRenderToTexture_attribsFile
					#undef ATTRIB
				}
				return &attributeNames;
			}

			// from cBaseNode
			/********************************************************************************************/
			const string getTypeName () const { return "caosGL::effects::cRenderToTexture"; }
		};
	}
}

// for node creation
#include <caosGL/core/cRegistry.h>
#include <caosGL/gfx/cNodeCreator.h>

class cRenderToTextureNodeCreator : public cNodeCreator {
public:
	cRenderToTextureNodeCreator () {
		name ("caosGL::effects::cRenderToTexture");
	}
	cBaseNode * createNode (const string n, cGroup * f) {
		return new caosGL::effects::cRenderToTexture (n,f);
	}
};
caosGL::core::cRegisterNodeCreator <cRenderToTextureNodeCreator> cRenderToTextureNodeCreatorInstance;

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof