/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/gfx/cScene.h>

// extern includes
#include <caosGL/core/math.h>
#include <caosGL/core/cParser.h>
#include <caosGL/core/Dyngl.h>
#include <caosGL/core/cOpenGLWindow.h>
#include <caosGL/core/cGLTexture.h>
#include <caosGL/gfx/cTextureSpace.h>
#include <caosGL/gfx/cState.h>
#include <GL/glu.h>

using namespace caosGL::gfx;
using namespace caosGL::core;

#define cProjectionWobler_attribsFile <caosGL/effects/cProjectionWobler.attribs>

namespace caosGL {
	namespace effects {
		static vector <tAttr> attributeNames;
		static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::effects::cProjectionWobler");

		/**
		 *<br> class:		cProjectionWobler
		 *<br> namespace:	caosGL::effects
		 *<br> inherits:	caosGL::gfx::cScene
		 *<br> implements:	<none>
		 *<br> purpose:		It projects the texture on this wobbly object in front of a camera. 
		 *					You can also move the scene around.
		 *
		 */

		class CAOSGL_API cProjectionWobler : public cScene {
			typedef cScene super;
		private:
			#define ATTRIB(n,t,v,d) ATTRIB_DEFINE_VAR(n,t)
			#include cProjectionWobler_attribsFile
			#undef ATTRIB
			cGLTexture * _img;
			tInt _list;

		public:
			/********************************************************************************************/
			cProjectionWobler (const string n, cGroup * f) : super (n,f) {
				init ();
			}

			/********************************************************************************************/
			~cProjectionWobler () {
			}

			// from iDrawable
			/********************************************************************************************/
			tBool draw (const tFloat time) {
				if (_img) {
					_img->prepare ();
				}
				_fase = time*5;
				

				glColor4f (1, 1, 1, _alph);
				cState::disable (cState::oGL_LIGHTING);
				cState::enable (cState::oGL_TEXTURE_2D);
				cState::enable (cState::oGL_BLEND);
				glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

				glMatrixMode(GL_PROJECTION);
				glLoadIdentity();

				gluPerspective (45.0,1.3,1,100.0);
				glTranslatef (0, 0, -6);
				glMatrixMode(GL_MODELVIEW);
				glLoadIdentity();
				glTranslatef (0, -4, 0);

				tInt vp [4];
				double mm [16], pm[16];
				glGetIntegerv (GL_VIEWPORT, vp);
				glGetDoublev (GL_MODELVIEW_MATRIX, mm);
				glGetDoublev (GL_PROJECTION_MATRIX, pm);

				tInt sectionsRound = 8;
				tInt sectionsHeight = 50;
				tFloat radius = 1;
				tFloat permutation = 0.4;
				tFloat heightStep = 0.1;


				for (tInt y = 0; y < sectionsHeight; y++) {
					for (tInt x = 0 ; x < sectionsRound; x++) {
						tFloat rpspy = radius+permutation*sin(_fase+(y));
						tFloat rpspy1 = radius+permutation*sin(_fase+(y+1));
						tFloat pi2xsr = 2*M_PI*x/sectionsRound;
						tFloat pi2x1sr = 2*M_PI*(x+1)/sectionsRound;
						tFloat sin0 = sin (pi2xsr);
						tFloat cos0 = cos (pi2xsr);
						tFloat sin1 = sin (pi2x1sr);
						tFloat cos1 = cos (pi2x1sr);

						// work it out from above! :p
						tFloat x0 = rpspy  * sin0;
						tFloat z0 = rpspy  * cos0;
						tFloat x1 = rpspy  * sin1;
						tFloat z1 = rpspy  * cos1;
						tFloat x2 = rpspy1 * sin1;
						tFloat z2 = rpspy1 * cos1;
						tFloat x3 = rpspy1 * sin0;
						tFloat z3 = rpspy1 * cos0;
						tFloat y0,y2;
						y0 = y*heightStep;
						y2 = (y+1)*heightStep;

						double u0,u1,u2,u3,v0,v1,v2,v3,w0;

						gluProject (x0,y0,z0, mm, pm, vp, &u0, &v0, &w0);// don't use z value...
						gluProject (x1,y0,z1, mm, pm, vp, &u1, &v1, &w0);
						gluProject (x2,y2,z2, mm, pm, vp, &u2, &v2, &w0);
						gluProject (x3,y2,z3, mm, pm, vp, &u3, &v3, &w0);
	
						glBegin (GL_QUADS); {
							glTexCoord2d (u0/vp[2], v0/vp[3]); glVertex3d (x0, y0, z0);
							glTexCoord2d (u1/vp[2], v1/vp[3]); glVertex3d (x1, y0, z1);
							glTexCoord2d (u2/vp[2], v2/vp[3]); glVertex3d (x2, y2, z2);
							glTexCoord2d (u3/vp[2], v3/vp[3]); glVertex3d (x3, y2, z3);
						} glEnd ();
					}
				}
				glMatrixMode(GL_PROJECTION);
				return true;
			}

			// from iDrawable
			/********************************************************************************************/
			tBool transparent () const {
				return _alph<255;
			}

			// from iDrawable
			/********************************************************************************************/
			tVoid transparent (const tBool trasnp) {
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool compile () {
				_img = cTextureSpace::instance ()->get (_tex);
				if (!_img)
					return false;
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool visit (tFloat t) {
				evaluateAll (t);
				if (!cBaseNode::visit (t))
					return false;

				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			tVoid leave () {
				return;
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool init () {
				#define ATTRIB(n,t,v,d) ATTRIB_INIT_VAR(n,v)
				#include cProjectionWobler_attribsFile
				#undef ATTRIB
				_list = -1;
				_img = cNULL;
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool set (const tDWord key, const string & value) {
				if (super::set (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_SET_S(n)
					#include cProjectionWobler_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool set (const tDWord key, const tFloat & value) {
				if (super::set (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_SET_N(n)
					#include cProjectionWobler_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool get (const tDWord key, string & value) const {
				if (super::get (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_GET(n)
					#include cProjectionWobler_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const vector <tAttr> * getAttributeNames () const {
				if (attributeNames.size () == 0) {
					const vector <tAttr> * v = super::getAttributeNames ();
					attributeNames.insert (attributeNames.begin (), v->begin (), v->end ());
					#define ATTRIB(n,t,v,d) ATTRIB_ATTRIBNAMES(n,d)
					#include cProjectionWobler_attribsFile
					#undef ATTRIB
				}
				return &attributeNames;
			}

			// from cBaseNode
			/********************************************************************************************/
			const string getTypeName () const { return "caosGL::effects::cProjectionWobler"; }
		};
	}
}

// for node creation
#include <caosGL/core/cRegistry.h>
#include <caosGL/gfx/cNodeCreator.h>

class cProjectionWoblerNodeCreator : public cNodeCreator {
public:
	cProjectionWoblerNodeCreator () {
		name ("caosGL::effects::cProjectionWobler");
	}
	cBaseNode * createNode (const string n, cGroup * f) {
		return new caosGL::effects::cProjectionWobler (n,f);
	}
};
caosGL::core::cRegisterNodeCreator <cProjectionWoblerNodeCreator> cProjectionWoblerNodeCreatorInstance;

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof