/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/gfx/cGroup.h>

// extern includes
#include <caosGL/core/cParser.h>
#include <caosGL/core/Dyngl.h>
#include <caosGL/core/cOpenGLWindow.h>


using namespace caosGL::gfx;
using namespace caosGL::core;

#define cDumper_attribsFile <caosGL/effects/cDumper.attribs>

namespace caosGL {
	namespace effects {
		static vector <tAttr> attributeNames;
		static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::effects::cDumper");

		/**
		 *<br> class:		cDumper
		 *<br> namespace:	caosGL::effects
		 *<br> inherits:	caosGL::gfx::cGroup
		 *<br> implements:	<none>
		 *<br> purpose:		Dumps debugging info, is a container class
		 *
		 */

		class CAOSGL_API cDumper : public cGroup {
			typedef cGroup super;
		private:
			#define ATTRIB(n,t,v,d) ATTRIB_DEFINE_VAR(n,t)
			#include cDumper_attribsFile
			#undef ATTRIB
			string name;

		public:
			/********************************************************************************************/
			cDumper (const string n, cGroup * f) : super (n,f) {
				init ();
			}

			/********************************************************************************************/
			~cDumper () {
			}

			/********************************************************************************************/
			tBool draw (const tFloat time) {
				cat.debug ("Dumper [%s] drawing", name.c_str());
				return true;
			}

			// from iDrawable
			/********************************************************************************************/
			tBool transparent () const {
				return false;
			}

			// from iDrawable
			/********************************************************************************************/
			tVoid transparent (const tBool trasnp) {
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool compile () {
				cat.debug ("Dumper [%s] compiling", name.c_str());
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool visit (tFloat t) {
				cat.debug ("Dumper [%s] visiting @ %f", name.c_str(), t);
				tFloat vals [16];
				glGetFloatv (GL_PROJECTION_MATRIX, vals);
				cat.debug ("\t%f,\t%f,\t%f,\t%f", vals[0],  vals[1],  vals[2],  vals[3]);
				cat.debug ("\t%f,\t%f,\t%f,\t%f", vals[4],  vals[5],  vals[6],  vals[7]);
				cat.debug ("\t%f,\t%f,\t%f,\t%f", vals[8],  vals[9],  vals[10], vals[11]);
				cat.debug ("\t%f,\t%f,\t%f,\t%f", vals[12], vals[13], vals[14], vals[15]);
				glGetFloatv (GL_MODELVIEW_MATRIX, vals);
				cat.debug ("\t%f,\t%f,\t%f,\t%f", vals[0],  vals[1],  vals[2],  vals[3]);
				cat.debug ("\t%f,\t%f,\t%f,\t%f", vals[4],  vals[5],  vals[6],  vals[7]);
				cat.debug ("\t%f,\t%f,\t%f,\t%f", vals[8],  vals[9],  vals[10], vals[11]);
				cat.debug ("\t%f,\t%f,\t%f,\t%f", vals[12], vals[13], vals[14], vals[15]);
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			tVoid leave () {
				cat.debug ("Dumper [%s] leaving", name.c_str());
				tFloat vals [16];
				glGetFloatv (GL_PROJECTION_MATRIX, vals);
				cat.debug ("\t%f,\t%f,\t%f,\t%f", vals[0],  vals[1],  vals[2],  vals[3]);
				cat.debug ("\t%f,\t%f,\t%f,\t%f", vals[4],  vals[5],  vals[6],  vals[7]);
				cat.debug ("\t%f,\t%f,\t%f,\t%f", vals[8],  vals[9],  vals[10], vals[11]);
				cat.debug ("\t%f,\t%f,\t%f,\t%f", vals[12], vals[13], vals[14], vals[15]);
				glGetFloatv (GL_MODELVIEW_MATRIX, vals);
				cat.debug ("\t%f,\t%f,\t%f,\t%f", vals[0],  vals[1],  vals[2],  vals[3]);
				cat.debug ("\t%f,\t%f,\t%f,\t%f", vals[4],  vals[5],  vals[6],  vals[7]);
				cat.debug ("\t%f,\t%f,\t%f,\t%f", vals[8],  vals[9],  vals[10], vals[11]);
				cat.debug ("\t%f,\t%f,\t%f,\t%f", vals[12], vals[13], vals[14], vals[15]);
				return;
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool init () {
				#define ATTRIB(n,t,v,d) ATTRIB_INIT_VAR(n,v)
				#include cDumper_attribsFile
				#undef ATTRIB
				cat.debug ("Dumper [%s] init", name.c_str());
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool set (const tDWord key, const string & value) {
				if (super::set (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_SET_S(n)
					#include cDumper_attribsFile
					#undef ATTRIB
				case 'name': {
					name = value;
				} return true;
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool set (const tDWord key, const tFloat & value) {
				if (super::set (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_SET_N(n)
					#include cDumper_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool get (const tDWord key, string & value) const {
				if (super::get (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_GET(n)
					#include cDumper_attribsFile
					#undef ATTRIB
				case 'name': {
					value = name;
				} return true;
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const vector <tAttr> * getAttributeNames () const {
				if (attributeNames.size () == 0) {
					const vector <tAttr> * v = super::getAttributeNames ();
					attributeNames.insert (attributeNames.begin (), v->begin (), v->end ());
					#define ATTRIB(n,t,v,d) ATTRIB_ATTRIBNAMES(n,d)
					#include cDumper_attribsFile
					#undef ATTRIB
				}
				return &attributeNames;
			}

			// from cBaseNode
			/********************************************************************************************/
			const string getTypeName () const { return "caosGL::effects::cDumper"; }
		};
	}
}

// for node creation
#include <caosGL/core/cRegistry.h>
#include <caosGL/gfx/cNodeCreator.h>

class cDumperNodeCreator : public cNodeCreator {
public:
	cDumperNodeCreator () {
		name ("caosGL::effects::cDumper");
	}
	cBaseNode * createNode (const string n, cGroup * f) {
		return new caosGL::effects::cDumper (n,f);
	}
};
caosGL::core::cRegisterNodeCreator <cDumperNodeCreator> cDumperNodeCreatorInstance;

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof