/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>
#include <caosGL/core/dllMain.h>

#include <caosGL/core/Dyngl.h>
#include <caosGL/core/resource.h>

#include <caosGL/core/cSystem.h>

// package includes

// extern includes
#include <caosGL/gfx/cState.h>
#include <stdio.h>
#include <windows.h>
#include <GL/glu.h>

#include <caosGL/core/cOpenGLWindow.h>

using namespace caosGL::gfx;
using namespace caosGL::core;
/*
#define dynwglMakeCurrent wglMakeCurrent
#define dynwglDeleteContext wglDeleteContext
#define dynwglCreateContext wglCreateContext
*/

static HINSTANCE hInstance;
static HWND hWnd;
static HGLRC hRC;
static HDC hDC;

namespace caosGL {
	namespace core {
		/**
		 *<br> class:		cWindow
		 *<br> namespace:	caosGL::core
		 *<br> inherits:	caosGL::core::cAbsWindow
		 *<br> implements:	<none>
		 *<br> purpose:		Creates a window, somewhere where things can be
		 *              drawn.
		 *
		 */

		/**
		 * This class includes code from nehe's (http://nehe.gamedev.net) tutorials.
		 *  Actually, what I just said is very lame: it's practically all from there!
		 *  It's just that I'm not too fond of the win32 api.
		 *
		 */

		static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::core::cOpenGLWindow");
		cAbsWindow * cOpenGLWindow::_instance = cNULL;

		/********************************************************************************************/
		cAbsWindow * cOpenGLWindow::instance () {
			if (_instance == cNULL) {
				_instance = makeInstance ();
			}
			return _instance;
		}

		/********************************************************************************************/
		cOpenGLWindow::cOpenGLWindow () { 
		}

		/********************************************************************************************/
		cAbsWindow * cOpenGLWindow::makeInstance () {
			return new cOpenGLWindow ();
		}
				
		/********************************************************************************************/
		cOpenGLWindow::~cOpenGLWindow () {
			close ();
		}
		
		/********************************************************************************************/
		const tBool cOpenGLWindow::open (tInt w, tInt h, WNDPROC wProc, tBool fs) {
			tChar str [255];
			_width = w;
			_height = h;
			sprintf (str, "%s  ::  caosGL v%i.%i.%i (c) 2002 %s",
				cSystem::instance ()->get ("name").c_str (), versionMajor,versionMinor,versionPatch,
				cSystem::instance ()->get ("author").c_str ());
			_clip.area (0,0,_width,_height);

			_opened = createGLWindow (str, _width, _height, fs, wProc);

			return _opened;
		}

		/********************************************************************************************/
		tVoid cOpenGLWindow::update () {
			SwapBuffers (hDC);
		}

		/********************************************************************************************/
		cArea & cOpenGLWindow::clip () {
			return _clip;
		}

		/********************************************************************************************/
		tVoid cOpenGLWindow::clip (const cArea & clip) {
			_clip = clip;
		}

		/********************************************************************************************/
		tInt cOpenGLWindow::width () const { return _width; }
		/********************************************************************************************/
		tInt cOpenGLWindow::height () const { return _height; }

		/********************************************************************************************/
		tVoid cOpenGLWindow::clear (const tBool depth) {
			cState::disable (cState::oGL_SCISSOR_TEST);
			glClearColor (0.0f,0.0f,0.0f,0.0f);
			if (depth)
				glClear (GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
			else 
				glClear (GL_COLOR_BUFFER_BIT);
		}

		/********************************************************************************************/
		tVoid cOpenGLWindow::clear (const tInt color, const tBool depth) {
			cState::disable (cState::oGL_SCISSOR_TEST);
			glClearColor (
				((color&0x00ff0000)>>16)/255.0,
				((color&0x0000ff00)>> 8)/255.0,
				((color&0x000000ff)    )/255.0,
				((color&0xff000000)>>24)/255.0);
			if (depth)
				glClear (GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
			else 
				glClear (GL_COLOR_BUFFER_BIT);
		}


		/********************************************************************************************/
		const tBool cOpenGLWindow::close () {
			if (!_opened) return false;

			if (_fullScreen) {									// Are We In Fullscreen Mode?
				ChangeDisplaySettings(NULL,0);					// If So Switch Back To The Desktop
				ShowCursor(TRUE);								// Show Mouse Pointer
			}

			if (hRC) {											// Do We Have A Rendering Context?
				if (!dynwglMakeCurrent(NULL,NULL)) {			// Are We Able To Release The DC And RC Contexts?
					MessageBox(NULL,"Release Of DC And RC Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
				}

				if (!dynwglDeleteContext(hRC)) {				// Are We Able To Delete The RC?
					MessageBox(NULL,"Release Rendering Context Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
				}
				hRC=NULL;										// Set RC To NULL
			}

			if (hDC && !ReleaseDC(hWnd,hDC)) {					// Are We Able To Release The DC
				MessageBox(NULL,"Release Device Context Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
				hDC=NULL;										// Set DC To NULL
			}

			if (hWnd && !DestroyWindow(hWnd)) {					// Are We Able To Destroy The Window?
				MessageBox(NULL,"Could Not Release hWnd.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
				hWnd=NULL;										// Set hWnd To NULL
			}

			if (!UnregisterClass("caosGL",hInstance)) {			// Are We Able To Unregister Class
				MessageBox(NULL,"Could Not Unregister Class.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
				hInstance=NULL;									// Set hInstance To NULL
			}
			_opened = false;
			return true;
		}

		
		/********************************************************************************************/
		/*	This Code Creates Our OpenGL Window.  Parameters Are:					*
		 *	title			- Title To Appear At The Top Of The Window				*
		 *	width			- Width Of The GL Window Or Fullscreen Mode				*
		 *	height			- Height Of The GL Window Or Fullscreen Mode			*
		 *	fullscreenflag	- Use Fullscreen Mode (TRUE) Or Windowed Mode (false)	*/

		tBool cOpenGLWindow::createGLWindow(tChar* title, tInt width, tInt height, tBool fullscreen, WNDPROC wProc) {
			GLuint		PixelFormat;			// Holds The Results After Searching For A Match
			WNDCLASS	wc;						// Windows Class Structure
			DWORD		dwExStyle;				// Window Extended Style
			DWORD		dwStyle;				// Window Style
			RECT		WindowRect;				// Grabs Rectangle Upper Left / Lower Right Values
			WindowRect.left=(long)0;			// Set Left Value To 0
			WindowRect.right=(long)width;		// Set Right Value To Requested Width
			WindowRect.top=(long)0;				// Set Top Value To 0
			WindowRect.bottom=(long)height;		// Set Bottom Value To Requested Height


			_fullScreen = fullscreen;
			hInstance = (HINSTANCE) hModule; //GetModuleHandle(NULL);				// Grab An Instance For Our Window
			wc.style			= CS_HREDRAW | CS_VREDRAW | CS_OWNDC;	// Redraw On Size, And Own DC For Window.
			wc.lpfnWndProc		= (WNDPROC) wProc;						// WndProc Handles Messages
			wc.cbClsExtra		= 0;									// No Extra Window Data
			wc.cbWndExtra		= 0;									// No Extra Window Data
			wc.hInstance		= hInstance;							// Set The Instance
			wc.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE (IDI_CAOSGL)); // IDI_WINLOGO
			wc.hCursor			= LoadCursor(NULL, IDC_ARROW);			// Load The Arrow Pointer
			wc.hbrBackground	= NULL;									// No Background Required For GL
			wc.lpszMenuName		= NULL;									// We Don't Want A Menu
			wc.lpszClassName	= "caosGL";								// Set The Class Name

			if (!RegisterClass(&wc)) {									// Attempt To Register The Window Class
				MessageBox(NULL,"Failed To Register The Window Class.","ERROR",MB_OK|MB_ICONEXCLAMATION);
				return false;											// Return false
			}
			
			if (fullscreen) {											// Attempt Fullscreen Mode?
				DEVMODE dmScreenSettings;								// Device Mode
				memset(&dmScreenSettings,0,sizeof(dmScreenSettings));	// Makes Sure Memory's Cleared
				dmScreenSettings.dmSize=sizeof(dmScreenSettings);		// Size Of The Devmode Structure
				dmScreenSettings.dmPelsWidth	= _width;				// Selected Screen Width
				dmScreenSettings.dmPelsHeight	= _height;				// Selected Screen Height
				dmScreenSettings.dmBitsPerPel	= 32;					// Selected Bits Per Pixel
#ifdef _DEBUG
				dmScreenSettings.dmDisplayFrequency	= 75;				// Selected Frequency
				dmScreenSettings.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT|DM_DISPLAYFREQUENCY;
#else
				dmScreenSettings.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;
#endif

				// Try To Set Selected Mode And Get Results.  NOTE: CDS_FULLSCREEN Gets Rid Of Start Bar.
				if (ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL) {
					_fullScreen=false;		// Windowed Mode Selected.  Fullscreen = false
				}
			}

			if (fullscreen)	{											// Are We Still In Fullscreen Mode?
				dwExStyle=WS_EX_APPWINDOW;								// Window Extended Style
				dwStyle=WS_POPUP;										// Windows Style
				ShowCursor(FALSE);										// Hide Mouse Pointer
			} else {
//					dwExStyle=WS_EX_TOOLWINDOW;								// Window Extended Style
				dwExStyle=WS_EX_APPWINDOW;
				dwStyle=WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU;
			}

			AdjustWindowRectEx(&WindowRect, dwStyle, false, dwExStyle);		// Adjust Window To True Requested Size

			// Create The Window
			if (!(hWnd=CreateWindowEx(	dwExStyle,							// Extended Style For The Window
										"caosGL",							// Class Name
										title,								// Window Title
										dwStyle |							// Defined Window Style
										WS_CLIPSIBLINGS |					// Required Window Style
										WS_CLIPCHILDREN,					// Required Window Style
										0, 0,								// Window Position
										WindowRect.right-WindowRect.left,	// Calculate Window Width
										WindowRect.bottom-WindowRect.top,	// Calculate Window Height
										NULL,								// No Parent Window
										NULL,								// No Menu
										hInstance,							// Instance
										NULL)))	{							// Dont Pass Anything To WM_CREATE
				close();									// Reset The Display
				MessageBox(NULL,"Window Creation Error.","ERROR",MB_OK|MB_ICONEXCLAMATION);
				return false;								// Return false
			}

			static	PIXELFORMATDESCRIPTOR pfd = {			// pfd Tells Windows How We Want Things To Be
				sizeof(PIXELFORMATDESCRIPTOR),				// Size Of This Pixel Format Descriptor
				1,											// Version Number
				PFD_DRAW_TO_WINDOW |						// Format Must Support Window
				PFD_SUPPORT_OPENGL |						// Format Must Support OpenGL
				PFD_DOUBLEBUFFER,							// Must Support Double Buffering
				PFD_TYPE_RGBA,								// Request An RGBA Format
				32,											// Select Our Color Depth
				0, 0, 0, 0, 0, 0,							// Color Bits Ignored
				0,											// No Alpha Buffer
				0,											// Shift Bit Ignored
				0,											// No Accumulation Buffer
				0, 0, 0, 0,									// Accumulation Bits Ignored
				16,											// 16Bit Z-Buffer (Depth Buffer)  
				0,											// No Stencil Buffer
				0,											// No Auxiliary Buffer
				PFD_MAIN_PLANE,								// Main Drawing Layer
				0,											// Reserved
				0, 0, 0										// Layer Masks Ignored
			};
			
			if (!(hDC=GetDC(hWnd)))	{						// Did We Get A Device Context?
				close();									// Reset The Display
				MessageBox(NULL,"Can't Create A GL Device Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
				return false;								// Return false
			}

			if (!(PixelFormat=ChoosePixelFormat(hDC,&pfd))){// Did Windows Find A Matching Pixel Format?
				close();									// Reset The Display
				MessageBox(NULL,"Can't Find A Suitable PixelFormat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
				return false;								// Return false
			}

			if(!SetPixelFormat(hDC,PixelFormat,&pfd)) {		// Are We Able To Set The Pixel Format?
				close();									// Reset The Display
				MessageBox(NULL,"Can't Set The PixelFormat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
				return false;								// Return false
			}

			if (!(hRC=dynwglCreateContext(hDC))) {			// Are We Able To Get A Rendering Context?
				close();									// Reset The Display
				MessageBox(NULL,"Can't Create A GL Rendering Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
				return false;								// Return false
			}

			if(!dynwglMakeCurrent(hDC,hRC)) {				// Try To Activate The Rendering Context
				close();									// Reset The Display
				MessageBox(NULL,"Can't Activate The GL Rendering Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
				return false;								// Return false
			}

			ShowWindow(hWnd,SW_SHOW);						// Show The Window
			SetForegroundWindow(hWnd);						// Slightly Higher Priority
			SetFocus(hWnd);									// Sets Keyboard Focus To The Window
			reSizeGLScene(width, height);					// Set Up Our Perspective GL Screen

			if (!initGL()) {								// Initialize Our Newly Created GL Window
				close ();									// Reset The Display
				MessageBox(NULL,"Initialization Failed.","ERROR",MB_OK|MB_ICONEXCLAMATION);
				return false;								// Return false
			}
			
			getInfo ();

//				SetPriorityClass (GetCurrentProcess (), HIGH_PRIORITY_CLASS);

			return true;									// Success
		} // tBool cOpenGLWindow::createGLWindow(tChar* title, tInt width, tInt height, tBool fullscreen) {

		/********************************************************************************************/
		tInt cOpenGLWindow::initGL(GLvoid) {					// All Setup For OpenGL Goes Here
			cState::init ();
			cState::enable(cState::oGL_TEXTURE_2D);							// Enable Texture Mapping
			glShadeModel(GL_SMOOTH);							// Enable Smooth Shading
			glClearColor(0.0f, 0.0f, 0.0f, 0.5f);				// Black Background
			glClearDepth(1.0f);									// Depth Buffer Setup
			cState::enable(cState::oGL_DEPTH_TEST);							// Enables Depth Testing
			glDepthFunc(GL_LEQUAL);								// The Type Of Depth Testing To Do
			glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	// Really Nice Perspective Calculations
			glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
			SwapBuffers (hDC);
			glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
			SwapBuffers (hDC);
			glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
			SwapBuffers (hDC);
			return TRUE;										// Initialization Went OK
		} // tInt cOpenGLWindow::initGL(GLvoid) {

		/********************************************************************************************/
		tVoid cOpenGLWindow::reSizeGLScene(GLsizei width, GLsizei height) {	// Resize And Initialize The GL Window
			if (height==0) {									// Prevent A Divide By Zero By
				height=1;										// Making Height Equal One
			}

			glViewport(0,0,width,height);						// Reset The Current Viewport

			glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
			glLoadIdentity();									// Reset The Projection Matrix

			// Calculate The Aspect Ratio Of The Window
			gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,0.1f,100.0f);

			glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix
			glLoadIdentity();									// Reset The Modelview Matrix
		} // tVoid cOpenGLWindow::reSizeGLScene(GLsizei width, GLsizei height) {

		/********************************************************************************************/
		void cOpenGLWindow::getInfo () {
			const tChar * vendor = (tChar*) glGetString(GL_VENDOR);
			const tChar * renderer = (tChar*) glGetString(GL_RENDERER);
			const tChar * version = (tChar*) glGetString(GL_VERSION);
			const tChar * extensions = (tChar*) glGetString(GL_EXTENSIONS);
			cat.info ("openGL Vendor: %s", vendor);
			cat.info ("openGL Renderer: %s", renderer);
			cat.info ("openGL Version: %s", version);
			tChar * sBuf = new tChar [strlen (extensions)+1]; tChar * t = sBuf;
			strcpy (sBuf, extensions);
			tChar * token = strtok (sBuf, " ");
			while (token) {
				cat.info ("openGL Extension: %s", token);
				token = strtok (cNULL, " ");
			}
		} // void cOpenGLWindow::getInfo () {
	} // namespace core
} // namespace caosGL

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof