/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes

// extern includes

#include <caosGL/core/cGLTextureSpace.h>

static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::core::cGLTextureSpace");

namespace caosGL {
	namespace core {
		/**
		 *<br> class:		cGLTextureSpace
		 *<br> namespace:	caosGL::core
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		encapsulates an openGL texture
		 *
		 */

		map <string, cGLTexture*> cGLTextureSpace::_textures;
		cGLTextureSpace * cGLTextureSpace::_instance = cNULL;
		/********************************************************************************************/
		cGLTextureSpace::cGLTextureSpace () {
		}

		/********************************************************************************************/
		cGLTextureSpace::~cGLTextureSpace () {
		}

		/********************************************************************************************/
		cGLTextureSpace * cGLTextureSpace::instance () {
			if (_instance == cNULL) {
				_instance = makeInstance ();
			}
			return _instance;
		}

		/********************************************************************************************/
		cGLTextureSpace * cGLTextureSpace::makeInstance () {
			return new cGLTextureSpace ();
		}
		
		/********************************************************************************************/
		cGLTexture * cGLTextureSpace::get (const string & name) {
			const map <string, cGLTexture*>::const_iterator it = _textures.find (name);
			if (it != _textures.end ()) {
				return it->second;
			}
			return cNULL;
		}

		/********************************************************************************************/
		tBool cGLTextureSpace::put (const string & name, cGLTexture * tex) {
			const map <string, cGLTexture*>::const_iterator it = _textures.find (name);
			if (it != _textures.end ()) {
				return false;
			}
			_textures.insert (make_pair (name, tex));
			return true;
		}
	}
}

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof