/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

#ifndef CAOSGL_GFX_C3DLOADER
#define CAOSGL_GFX_C3DLOADER

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/gfx/cGroup.h>
#include <caosGL/gfx/cReadKey.h>

// extern includes

using namespace caosGL::gfx;

namespace caosGL { 
	namespace gfx {
		/**
		 *<br> class:		c3DLoader
		 *<br> namespace:	caosGL::gfx
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		Loads a scene into a cGroup.
		 *
		 */

		class CAOSGL_API c3DLoader {
		// instance management and creation stuff...
		public:
			~c3DLoader ();
			static c3DLoader * instance ();

		private:
			c3DLoader ();
			static c3DLoader * _instance;
			static c3DLoader * makeInstance ();

		// normal stuff
		public:
			cGroup * loadCaos (const string & file, const string & prefix);

		private:
			tBool read ();
			tBool readHeader ();
			tBool readAttribS ();
			tBool readAttribD ();
			tBool readAttribI ();
			tBool readAttribB ();
			tBool readObjStart ();
			tBool readObjEnd ();
			tBool readCurveStart ();
			tBool readKey ();
			tBool readCurveEnd ();
			tBool readMeshVertexList ();
			tBool readMeshFaceList ();
			tBool readMeshUVList ();
			tBool readMeshNormalList ();
			tBool readMeshEdgeList ();
		
			tDWord bc;
			istream * s;
			cBaseNode * node;
			cGroup * rootNode;
			vector <cReadKey *> keys;

			// proxy data
			tChar strBuf [8196]; // i just hope that things don't get out of hand...
			// this *should* be big enough for any attribute...
			string name;
			string writer;
			string type;
			string obj;
			tBool gotAFather;
			tDWord attr;
			string fileName;
			string prefix;

			// let's be really lazy, and delegate things...
			tBool read (tDWord & v);
			tBool read (tInt & v);
			tBool read (tDouble & v);
			tBool read (tFloat & v);
			tBool read (tBool & v);
			tBool read (tVoid * b, tDWord l);
			tBool eof();
		};
	}
}

#endif // CAOSGL_GFX_C3DLOADER

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof