@rem first parameter is the config to load
@rem second parameter is which executable to run on the harddrive (or if it ends with .adf/.dms then the disk image to start with) when booting the machine
@rem third parameter is the path to a second floppy disk image if it exists
@set oldpath_startwinuae=%cd%
@cd /d "%~dp0.."
@set FellowOtherParms=

@set exeName=%2
@set ExeNameWithoutQuotes=%exeName:"=%

@set extension=%ExeNameWithoutQuotes:~-4%
@if not exist dh0\t md dh0\t
@if /i '%extension%' EQU '.dms' goto bootDisk
@if /i '%extension%' NEQ '.adf' goto bootHDWithFile
:bootDisk

@rem check if parameter is added as ""
@if x%2 == x goto bootHD
@if %2 == "" goto bootHD

@set Disk1Path=%cd%\%2
@if not exist %Disk1Path% set Disk1Path=%2

@if x%3 == x goto bootSingleDisk
@if %3 == "" goto bootSingleDisk

@set Disk2Path=%cd%\%3
@if not exist %Disk2Path% set Disk2Path=%3
:bootDualDisk
@echo Booting WinFellow Amiga in %1 mode, and starting disks %Disk1Path% and %Disk2Path%
@if not exist %Disk1Path% echo Disk %Disk1Path% not found
@if not exist %Disk1Path% goto Failed
@if not exist %Disk2Path% echo Disk %Disk2Path% not found
@if not exist %Disk2Path% goto Failed
@set FellowOtherParms=%FellowOtherParms% -s floppy0=%Disk1Path% -s floppy1=%Disk2Path% -s fellow.floppy1_enabled=1
@goto Boot

:bootSingleDisk
@echo Booting WinFellow Amiga in %1 mode, and starting disk %Disk1Path%
@if not exist %Disk1Path% echo Disk %Disk1Path% not found
@if not exist %Disk1Path% goto Failed
@set FellowOtherParms=%FellowOtherParms% -s floppy0=%Disk1Path%
@goto Boot

:bootHDWithFile
@set exeName=%2
:bootHD
@echo Booting WinFellow Amiga in %1 mode, and starting executable %exeName% on the HD
@if exist %2 (
	@set exeName=t\tempexe
	@copy %2 dh0\t\tempexe >nul
)

@set exeName=%exeName:\=/%
@echo /|set /p =%exeName%>dh0\t\startup-sequence
@copy dh0\t\startup-sequence dh0\s\startup-sequence >nul
@if errorlevel 1 (
	echo Couldn't write dh0:s/startup-sequence
	goto failed
)

@echo ERROR: HD NOT YET SUPPORTED WITH FELLOW 
@goto Failed

:Boot

@set FellowConfig="winfellow\%1AF.wfc"
@if exist .\winuae\rom.key goto AmigaForever
@set FellowConfig="winfellow\%1.wfc"
:AmigaForever

@start .\winfellow\winfellow.exe -f %FellowConfig% %FellowOtherParms%

@cd /d %oldpath_startwinuae%
@goto Success
:Failed
@cd /d %oldpath_startwinuae%
@exit /b 1
:Success
@exit /b 0
