.MODEL SMALL
.386
.STACK 100h

FREE_MEM        = 100000
FREE_XMS        = 1000000

CODE_SEG        SEGMENT USE16
                ASSUME  CS:CODE_SEG

BEGIN:          DB      0

NO_MEM_MSG      DB      'To run that demo you need at least '
                DB      '0'+FREE_MEM/100000
                DB      '0'+(FREE_MEM MOD 100000) / 10000
                DB      '0'+(FREE_MEM MOD 10000) / 1000
                DB      '0'+(FREE_MEM MOD 1000) / 100
                DB      '0'+(FREE_MEM MOD 100) / 10
                DB      '0'+(FREE_MEM MOD 10)
                DB      ' bytes of free conventional memory.',0Dh,0Ah,24h
NO_XMS_MSG      DB      'To run that demo you need at least '
                DB      '0'+FREE_XMS/1000000
                DB      '0'+(FREE_XMS MOD 1000000) / 100000
                DB      '0'+(FREE_XMS MOD 100000) / 10000
                DB      '0'+(FREE_XMS MOD 10000) / 1000
                DB      '0'+(FREE_XMS MOD 1000) / 100
                DB      '0'+(FREE_XMS MOD 100) / 10
                DB      '0'+(FREE_XMS MOD 10)
                DB      ' bytes of free, one-block XMS memory.',0Dh,0Ah,24h
NO_EMS_MSG      DB      'To run that demo you need at least '
                DB      '0'+FREE_XMS/1000000
                DB      '0'+(FREE_XMS MOD 1000000) / 100000
                DB      '0'+(FREE_XMS MOD 100000) / 10000
                DB      '0'+(FREE_XMS MOD 10000) / 1000
                DB      '0'+(FREE_XMS MOD 1000) / 100
                DB      '0'+(FREE_XMS MOD 100) / 10
                DB      '0'+(FREE_XMS MOD 10)
                DB      ' bytes of free EMS memory.',0Dh,0Ah,24h
ERR0MSG         DB      'File not found',0Dh,0Ah,24h
ERR1MSG         DB      'Read error',0Dh,0Ah,24h
ERR2MSG         DB      'File corrupted',0Dh,0Ah,24h
ERR3MSG         DB      'You need at least DOS 3.0 with an 80386 CPU',0Dh,0Ah,24h
ERR4MSG         DB      'Seek error',0Dh,0Ah,24h
ERR5MSG         DB      'Cannot allocate memory',0Dh,0Ah,24h
ERR6MSG         DB      'You need XMS or EMS 4.0 to run this demo',0Dh,0Ah,24h
ERR7MSG         DB      'Internal error #01',0Dh,0Ah,24h
ERR8MSG         DB      'This demo is not to be run under Windoze',0Dh,0Ah,24h

MEMKIND         DB      0       ; 1 = XMS, 2 = EMS
EMMSTRING       DB      'EMMXXXX0',0
XMM             DD      0
OLD_INT13       DD      0
FNAME_SEG       DW      0
FNAME_OFF       DW      0
ALLOC_PAGE      DW      0
CHANGE          DB      0
DRIVE           DB      0
XMS_STRUCT      LABEL
XMS_LEN         DD      0
XMS_H1          DW      0
XMS_A1          DD      0
XMS_H2          DW      0
XMS_A2          DD      0
EMS_STRUCT      LABEL
EMS_LEN         DD      0
EMS_K1          DB      0
EMS_H1          DW      0
EMS_A1O         DW      0
EMS_A1S         DW      0
EMS_K2          DB      0
EMS_H2          DW      0
EMS_A2O         DW      0
EMS_A2S         DW      0

TEMP1           DW      0
TEMP2           DW      0
DIR             DB      'A:\',0
EXE             DB      'A:\GO.EXE',0
ARGS            DB      0,0Dh,00h
LOADEXEC        DW      0
                DW      80h
ARGSEG          DW      00h
                DD      0
                DD      0

FILE            DW      0
FILELEN         LABEL
EXTRABYTES      DW      0
PAGES           DW      0

MAGIC           EQU     0ABCDh
TABLE_BEGIN     LABEL
T_MAGIC         DW      0
T_DISKS         DW      0
T_CRYPTO        DD      0
T_ARRAY         DW      4*10 DUP (0)
TABLE_END       LABEL

BUFFER          DB      4096 DUP (0)

START:          MOV     AX,CS
                MOV     DS,AX
                MOV     AX,ES
                MOV     ARGSEG,AX
                MOV     AX,3000h
                INT     21h
                CMP     AL,3
                JGE     DOSOK
PROCERR:        LEA     DX,ERR3MSG
                JMP     BYE
DOSOK:          CALL    IS_386
                JC      PROCERR
                CALL    CHECK_WINDOWS
                JNC     WINOK
                LEA     DX,ERR8MSG
                JMP     BYE
WINOK:          PUSH    ES
                MOV     ES,ES:[2Ch]
                XOR     DI,DI
                XOR     AL,AL
                MOV     CX,0FFFFh
                CLD
PROGNAME: REPNE SCASB
                SCASB
                JNZ     PROGNAME
                PUSH    DS
                INC     DI
                INC     DI
                MOV     AX,ES
                MOV     DS,AX
                MOV     DX,DI
                MOV     [FNAME_SEG],DS
                MOV     [FNAME_OFF],DX
                MOV     AX,3D00h
                INT     21h
                POP     DS
                POP     ES
                JNC     OPENERROR
                LEA     DX,ERR0MSG
                JMP     BYE
OPENERROR:      MOV     Word Ptr FILE,AX
                MOV     BX,CS
                MOV     AX,ES
                SUB     BX,AX
                ADD     BX,(FINISH-BEGIN+15)/16+272     ; 272 = stack :)
                MOV     AH,4Ah
                PUSH    BX
                INT     21h
                POP     AX
                CALL    INITMEM
                CALL    CHECK_MEM
                CALL    LOADTABLE
                OR      DX,DX
                JNZ     BYE
                MOV     BX,Word Ptr FILE
                MOV     AX,-1
                MOV     Word Ptr FILE,AX
                MOV     AH,3Eh
                INT     21h

                CALL    FLUSH_CACHE
                CALL    INITDISK

                MOV     AL,0
                CALL    LOADDISK
                JNC     MAIN_J0
                LEA     DX,ERR7MSG
                JMP     BYE2
MAIN_J0:
                MOV     AX,3513h
                INT     21h
                MOV     Word Ptr OLD_INT13,BX
                MOV     Word Ptr OLD_INT13[2],ES
                MOV     DX,OFFSET NEW_INT13
                MOV     AX,CS
                MOV     DS,AX
                MOV     AX,2513h
                INT     21h

                MOV     AH,19h
                INT     21h
                MOV     Byte Ptr [DRIVE],AL
                MOV     DL,0
                MOV     AH,0Eh
                INT     21h
                LEA     DX,DIR
                MOV     AH,3Bh
                INT     21h

                MOV     AX,CS
                MOV     DS,AX
                MOV     ES,AX
                MOV     DX,OFFSET EXE
                MOV     BX,OFFSET LOADEXEC
                MOV     AX,4B00h
                INT     21h
                
                MOV     AX,2513h
                MOV     DX,Word Ptr OLD_INT13
                MOV     DS,Word Ptr OLD_INT13[2]
                INT     21h
                
                MOV     DL,Byte Ptr [DRIVE]
                MOV     AH,0Eh
                INT     21h

                XOR     DX,DX
BYE2:           PUSH    DX
                MOV     AX,CS
                MOV     DS,AX
                CALL    DEINITDISK
                CALL    FLUSH_CACHE
                POP     DX
                
BYE:            MOV     AX,CS
                MOV     DS,AX
                OR      DX,DX
                JZ      BYE3
                MOV     AH,9
                INT     21h
BYE3:           MOV     BX,Word Ptr FILE
                CMP     BX,-1
                JZ      DONTCLOSE
                MOV     AH,3Eh
                INT     21h
DONTCLOSE:      MOV     AX,4C00h
                INT     21h

CHECK_WINDOWS:  MOV     AX,1600h
                INT     2Fh
                CMP     AL,80h
                JZ      WINCHECK_OKAY
                OR      AL,AL
                JNZ     WINCHECK_OUT
WINCHECK_OKAY:  CLC
                RET
WINCHECK_OUT:   STC
                RET

CHECK_MEM:      MOV     CX,AX
                MOV     BX,0FFFFh
                MOV     AH,48h
                INT     21h
                MOV     DX,OFFSET NO_MEM_MSG
                ADD     BX,CX
                ADD     BX,512/16
                SUB     BX,(FREE_MEM+15)/16
                JC      BYE
                MOV     AL,CS:MEMKIND
                CMP     AL,2
                JZ      CHECK_MEM_EMS
                MOV     AH,8
                CALL    [XMM]
                MOV     DX,OFFSET NO_XMS_MSG
                JZ      BYE
                CMP     AX,(FREE_XMS+1023)/1024  ; AX Contigui, DX Totali
                JC      BYE
                RET
CHECK_MEM_EMS:  MOV     AH,42h
                INT     67h
                MOV     DX,OFFSET NO_EMS_MSG
                OR      AH,AH
                JNZ     BYE
                CMP     BX,(FREE_XMS+16383)/16384
                JC      BYE
                RET

LOADDISK:       PUSH    DS
                PUSHAD
                XOR     AH,AH
                CMP     AX,Word Ptr T_DISKS
                JC      LOADDISK_J0
LOADDISK_ERR:   POPAD
                POP     DS
                STC
                RET
LOADDISK_J0:    PUSH    AX
                MOV     DS,[FNAME_SEG]
                MOV     DX,[FNAME_OFF]
                MOV     AX,3D00h
                INT     21h
                MOV     BX,AX
                POP     AX
                JC      LOADDISK_ERR
                MOV     Word Ptr [FILE],BX
                MOV     Byte Ptr CHANGE,1
                SHL     AX,3
                MOV     BX,OFFSET T_ARRAY
                ADD     BX,AX
                MOV     ECX,DWord Ptr CS:[BX]
                MOV     EDX,DWord Ptr CS:[BX+4]
                PUSH    EDX
                MOV     DX,CX
                SHR     ECX,16
                MOV     BX,Word Ptr FILE
                MOV     AX,4200h
                INT     21h
                POP     EDI
                JC      LOADDISK_ERR
                XOR     SI,SI
LOADDISK_L1:    MOV     AX,CS
                MOV     DS,AX
                MOV     ECX,4096
                CMP     EDI,ECX
                JNC     LOADDISK_J1
                MOV     ECX,EDI
LOADDISK_J1:    SUB     EDI,ECX
                LEA     DX,BUFFER
                MOV     BX,Word Ptr FILE
                MOV     AH,3Fh
                INT     21h
                JC      LOADDISK_ERR
                CMP     AX,CX
                JNZ     LOADDISK_ERR
                PUSHAD
                MOV     EAX,T_CRYPTO
                MOV     CX,1024
                LEA     BX,BUFFER
LOADDISK_L2:    MOV     EDX,CS:[BX]
                XOR     EDX,EAX
                MOV     CS:[BX],EDX
                ADD     BX,4
                LOOP    LOADDISK_L2
                POPAD
                
                SHR     CX,9
                MOV     BX,CX
                MOV     AX,SI
                PUSHAD
                CALL    WRITE_SECTORS
                POPAD
                ADD     SI,CX
                OR      EDI,EDI
                JNZ     LOADDISK_L1
                MOV     BX,Word Ptr FILE
                MOV     AX,-1
                MOV     Word Ptr FILE,AX
                MOV     AH,3Eh
                INT     21h
                POPAD
                POP     DS
                CLC
                RET

IS_386:         PUSHF
                XOR     AH,AH
                PUSH    AX
                POPF
                PUSHF
                POP     AX
                POPF
                AND     AH,0F0h
                CMP     AH,0F0h
                JZ      NO_386
                MOV     AH,0F0h
                PUSH    AX
                POPF
                PUSHF
                POP     AX
                AND     AH,0F0h
                JZ      NO_386
                CLC                
                RET
NO_386:         STC
                RET

LOADTABLE:      MOV     DI,Word Ptr FILE
                MOV     BX,DI
                XOR     CX,CX
                MOV     DX,2
                MOV     AX,4200h
                INT     21h
                JNC     TABL0ERRJ
                LEA     DX,ERR4MSG
                RET
TABL0ERRJ:      LEA     DX,Word Ptr FILELEN
                MOV     BX,DI
                MOV     CX,4
                MOV     AH,3Fh
                INT     21h
                JC      TABL1ERRJJ
                CMP     AX,4
                JZ      TABL1ERRJ
TABL1ERRJJ:     LEA     DX,ERR1MSG
                RET
TABL1ERRJ:      XOR     ECX,ECX
                MOV     CX,Word Ptr PAGES
                DEC     CX
                SHL     ECX,9
                XOR     EDX,EDX
                MOV     DX,Word Ptr EXTRABYTES
                ADD     ECX,EDX
                MOV     DX,CX
                SHR     ECX,16
                MOV     BX,DI
                MOV     AX,4200h
                INT     21h
                JNC     TABL2ERRJ
                LEA     DX,ERR4MSG
                RET
TABL2ERRJ:      LEA     DX,TABLE_BEGIN
                MOV     BX,DI
                MOV     CX,TABLE_END-TABLE_BEGIN
                MOV     AH,3Fh
                INT     21h
                JC      TABL3ERRJJ
                CMP     AX,CX
                JZ      TABL3ERRJ
TABL3ERRJJ:     LEA     DX,ERR1MSG
                RET
TABL3ERRJ:      MOV     AX,Word Ptr T_MAGIC
                CMP     AX,MAGIC
                JZ      TABL4ERRJ
                LEA     DX,ERR2MSG
                RET
TABL4ERRJ:      XOR     DX,DX
                RET

NEW_INT13:      CMP     AH,0F8h
                JZ      DO_INTF8
                OR      DL,DL
                JNZ     SKIP_INT
                CMP     AH,0
                JZ      DO_INT0
                CMP     AH,1
                JZ      DO_INT1
                CMP     AH,2
                JZ      DO_INT2
                CMP     AH,3
                JZ      DO_INT3
                CMP     AH,4
                JZ      DO_INT4
                CMP     AH,5
                JZ      DO_INT5
                CMP     AH,22
                JZ      DO_INT22
                JMP     DONT_INT
SKIP_INT:       CMP     DL,80h
                JNZ     DONT_INT
                OR      AH,AH
                JZ      DO_INT0
DONT_INT:       JMP     [OLD_INT13]

IRQ_RETC:       POP     CS:[TEMP1]
                POP     CS:[TEMP2]
                POPF
                STC
                PUSHF
                PUSH    CS:[TEMP2]
                PUSH    CS:[TEMP1]
                IRET

IRQ_RETNC:      POP     CS:[TEMP1]
                POP     CS:[TEMP2]
                POPF
                CLC
                PUSHF
                PUSH    CS:[TEMP2]
                PUSH    CS:[TEMP1]
                IRET

DO_INT2:        PUSHAD
                PUSH    DS
                PUSH    ES
                CALL    COMPUTE_CYL
                CALL    READ_SECTORS
                POP     ES
                POP     DS
                POPAD
                MOV     AH,0
                JMP     IRQ_RETNC

DO_INT3:        PUSHAD
                PUSH    DS
                PUSH    ES
                CALL    COMPUTE_CYL
                CALL    WRITE_SECTORS
                POP     ES
                POP     DS
                POPAD
                MOV     AH,0
                JMP     IRQ_RETNC

DO_INT0:
DO_INT1:
DO_INT4:
DO_INT5:        MOV     AH,0
                JMP     IRQ_RETNC

DO_INT22:       MOV     AH,CS:[CHANGE]
                OR      AH,AH
                JZ      IRQ_RETNC
                MOV     AH,6
                JMP     IRQ_RETC

DO_INTF8:       CALL    LOADDISK
                JC      IRQ_RETC
                JMP     IRQ_RETNC


COMPUTE_CYL:    PUSH    BX
                PUSH    AX
                DEC     CL
                MOV     AL,CH
                XOR     AH,AH
                ADD     AX,AX
                MOV     SI,AX
                SHL     AX,3
                ADD     AX,SI
                XOR     CH,CH
                ADD     AX,CX
                OR      DH,DH
                JZ      HEAD_0
                ADD     AX,9
HEAD_0:         POP     BX
                XOR     BH,BH
                PUSH    ES
                POP     DS
                POP     DX
                RET

; AX = Sector no, BX = # of sectors, DS:DX = Pointer

WRITE_SECTORS:  MOV     CL,CS:MEMKIND
                CMP     CL,2
                JZ      WRITE_EMS
                
                AND     EAX,0FFFFh
                SHL     EAX,9
                MOV     XMS_A2,EAX
                AND     EBX,0FFFFh
                SHL     EBX,9                
                MOV     XMS_LEN,EBX
                MOV     Word Ptr XMS_A1[0],DX
                MOV     Word Ptr XMS_A1[2],DS
                
                XOR     AX,AX
                MOV     XMS_H1,AX
                MOV     AX,ALLOC_PAGE
                MOV     XMS_H2,AX
                MOV     AX,CS
                MOV     DS,AX
                MOV     SI,OFFSET XMS_STRUCT
                MOV     AH,0Bh
                CALL    [XMM]
                CLC
                RET
WRITE_EMS:      AND     EBX,0FFFFh
                SHL     EBX,9                
                MOV     EMS_LEN,EBX
                MOV     EMS_A1O,DX
                MOV     EMS_A1S,DS
                MOV     DX,0
                MOV     EMS_K1,DL
                MOV     EMS_H1,DX

                AND     EAX,0FFFFh
                SHL     EAX,9
                MOV     EDX,EAX
                AND     DX,3FFFh
                MOV     EMS_A2O,DX
                SHR     EAX,14
                MOV     EMS_A2S,AX
                MOV     AX,ALLOC_PAGE
                MOV     EMS_H2,AX
                MOV     AL,1
                MOV     EMS_K2,AL
                MOV     AX,CS
                MOV     DS,AX
                MOV     SI,OFFSET EMS_STRUCT
                MOV     AX,5700h
                INT     67h
                CLC
                RET

; AX = Sector no, BX = # of sectors, DS:DX = Pointer

READ_SECTORS:   MOV     CL,CS:MEMKIND
                CMP     CL,2
                JZ      READ_EMS
                
                AND     EAX,0FFFFh
                SHL     EAX,9
                MOV     XMS_A1,EAX
                AND     EBX,0FFFFh
                SHL     EBX,9                
                MOV     XMS_LEN,EBX
                MOV     Word Ptr XMS_A2[0],DX
                MOV     Word Ptr XMS_A2[2],DS
                
                XOR     AX,AX
                MOV     XMS_H2,AX
                MOV     AX,ALLOC_PAGE
                MOV     XMS_H1,AX
                MOV     AX,CS
                MOV     DS,AX
                MOV     SI,OFFSET XMS_STRUCT
                MOV     AH,0Bh
                CALL    [XMM]
                CLC
                RET
READ_EMS:       AND     EBX,0FFFFh
                SHL     EBX,9                
                MOV     EMS_LEN,EBX
                MOV     EMS_A2O,DX
                MOV     EMS_A2S,DS
                MOV     DX,0
                MOV     EMS_K2,DL
                MOV     EMS_H2,DX

                AND     EAX,0FFFFh
                SHL     EAX,9
                MOV     EDX,EAX
                AND     DX,3FFFh
                MOV     EMS_A1O,DX
                SHR     EAX,14
                MOV     EMS_A1S,AX
                MOV     AX,ALLOC_PAGE
                MOV     EMS_H1,AX
                MOV     AL,1
                MOV     EMS_K1,AL
                MOV     AX,CS
                MOV     DS,AX
                MOV     SI,OFFSET EMS_STRUCT
                MOV     AX,5700h
                INT     67h
                CLC
                RET
                
INITDISK:       MOV     AL,CS:MEMKIND
                CMP     AL,2
                JZ      INITDISK_EMS
                MOV     DX,720
                MOV     AH,9
                CALL    [XMM]
                OR      AX,AX
                JNZ     INITDISK_OKX
INITDISK_ERROR: MOV     DX,OFFSET ERR5MSG
                JMP     BYE
INITDISK_OKX:   MOV     CS:[ALLOC_PAGE],DX
                RET
INITDISK_EMS:   MOV     AH,43h
                MOV     BX,45
                INT     67h
                OR      AH,AH
                JNZ     INITDISK_ERROR
                MOV     CS:[ALLOC_PAGE],DX
                RET


DEINITDISK:     MOV     BL,CS:MEMKIND
                CMP     BL,2
                JZ      DEINITDISK_EMS
                MOV     DX,CS:[ALLOC_PAGE]
                CMP     DX,-1
                JZ      DEINITDISK_OUT
                MOV     AH,0Ah
                CALL    [XMM]
                MOV     AX,-1
                MOV     CS:[ALLOC_PAGE],AX
DEINITDISK_OUT: RET
DEINITDISK_EMS: MOV     AH,45h
                MOV     DX,CS:[ALLOC_PAGE]
                INT     67h
                MOV     AX,-1
                MOV     CS:[ALLOC_PAGE],AX
                RET

INITMEM:        MOV     AX,4300h
                INT     2Fh
                CMP     AL,80h
                JNZ     NO_XMS
                MOV     AX,4310h
                INT     2Fh
                MOV     Word Ptr CS:XMM,BX
                MOV     Word Ptr CS:XMM[2],ES
                MOV     AL,1
                MOV     MEMKIND,AL
                RET
NO_XMS:         MOV     AX,3567h
                INT     21h
                MOV     DI,10
                MOV     SI,OFFSET EMMSTRING
                MOV     CX,8
           REPE CMPSB
                JNZ     NO_EMS
                MOV     AH,46h
                INT     67h
                CMP     AL,40h
                JL      NO_EMS
                MOV     AL,2
                MOV     MEMKIND,AL
                RET
NO_EMS:         MOV     DX,OFFSET ERR6MSG
                JMP     BYE

FLUSH_CACHE:    MOV     AX,4A10h
                XOR     BX,BX
                MOV     CX,0EBABh
                INT     2Fh
                CMP     AX,0BABEh
                JNZ     NO_CACHE
                MOV     AX,4A10h
                MOV     BX,1
                INT     2Fh
                MOV     AX,4A10h
                MOV     BX,2
                INT     2Fh
NO_CACHE:       RET

FINISH:

CODE_SEG        ENDS

                END START
