program hstrip;
uses dos, crt;

var
f1,f2 : file of byte;
b			: byte;
i			: longint;

procedure SetCursor(On: Boolean);
var
	reg : Registers;
begin
	if On then              { Turn cursor on }
		if Mem[$0040:$0049] = 7 then
    	reg.cx := $B0C  { If monochrome monitor }
    else
    	reg.cx := $607  { If color monitor }
    else                    { Turn cursor off }
    	reg.cx := $2020;
    reg.bx := 0;
    reg.ax := $0100;    { Set the interrupt function }
    Intr($10,reg);      { Call the interrupt }
end;  { procedure SetCursor }

function FileExists(FileName: String): Boolean;
var
 F: file;
begin
 {$I-}
 Assign(F, FileName);
 FileMode := 0;
 Reset(F);
 Close(F);
 {$I+}
 FileExists := (IOResult = 0) and (FileName <> '');
end;  { FileExists }




begin
  WriteLn ('');
	WriteLn ('512 byte HeaderStripper');
	WriteLn ('Written by HeroZero/DiESEL');
  WriteLn ('');
	WriteLn ('A small util. for stripping the 512 byte header on');
  WriteLn ('GameBoy SmartCard games to make them playable on');
  WriteLn ('the ProFigther GameBoy adapter and other things that');
  WriteLn ('only accepts headerless files like dmg-diz.exe.');
	WriteLn ('');

if paramcount<>2 then
	begin
  	WriteLn ('usage: game.gb game.boy');
    halt(3);
  end;

if (not FileExists (paramstr(1)) or (FileExists (paramstr(2)))) then
	begin
  	WriteLn ('File not found or Out file allready exists...');
    halt (4);
  end;

assign (f1,paramstr(1));
assign (f2,paramstr(2));
Reset  (f1);
Rewrite(f2);

for i := 1 to 512 do
	read (f1,b);

  i:=0;
  SetCursor (false);
repeat
	read(f1,b);
  Write(f2,b);
  GotoXY (1,WhereY);
  Write  ('Working on byte:',i);
  inc (i);
until eof(f1);
Write (' Done..');
SetCursor (true);
Close (f1);
Close (f2);
end.