/* Small AYS-Nobo Example. Have fun with it.
		http://www.aysec.com
Try to comment out the NoBoStart and NoBoStop.
You'll see the normal Window				*/


#include <windows.h>
#include "NoBoDat.h"

//Prototype
LRESULT CALLBACK WindowFunc(HWND, UINT, WPARAM, LPARAM);

char		lpszWinClass[] = "NOBO-Example";
HBITMAP	hBit1;		//Handle for the Bitmap


int WINAPI WinMain(HINSTANCE hThisInst, HINSTANCE hPrevInst,LPSTR lpszArgs, int nWinMode)
{
	MSG		msg;
	WNDCLASSEX	wcl;
	HWND 		hwnd;		

	//define the WindowClass
	wcl.hInstance	= hThisInst;
	wcl.lpszClassName	= lpszWinClass;
	wcl.lpfnWndProc	= WindowFunc;
	wcl.style		= 0;
	wcl.cbSize		= sizeof(WNDCLASSEX);
	wcl.hIcon		= LoadIcon( NULL, IDI_APPLICATION );
	wcl.hIconSm		= LoadIcon( NULL, IDI_APPLICATION );
	wcl.hCursor		= LoadCursor( NULL, IDC_ARROW );
	wcl.lpszMenuName	= NULL;
	wcl.cbClsExtra	= 0;
	wcl.cbWndExtra	= 0;
	wcl.hbrBackground	= GetStockObject( WHITE_BRUSH );

	//Fensterklasse registrieren
	if(!RegisterClassEx(&wcl)) return 0;

	//Fenster anlegen
	hwnd=CreateWindow(lpszWinClass, lpszWinClass, WS_POPUP | WS_VISIBLE ,
				100, 100, 352, 136, HWND_DESKTOP, NULL, hThisInst, NULL);

	hBit1 = LoadImage(hThisInst,"Ex1Bmp",IMAGE_BITMAP,0,0,0);

	NoBoStart(hwnd);			//could be placed in WM_CREATE if you want to.

	ShowWindow(hwnd, nWinMode);
	UpdateWindow(hwnd);

	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}


	return msg.wParam;
} //WinMain


LRESULT CALLBACK WindowFunc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
HDC		hDC,memDC;
PAINTSTRUCT paintstruct;

	switch(message)
	{
	  case WM_PAINT:
		hDC = BeginPaint(hwnd, &paintstruct);
		memDC = CreateCompatibleDC(hDC);
		SelectObject(memDC, hBit1);
		BitBlt(hDC,0,0,352, 136,memDC,0,0,SRCCOPY);
		DeleteDC(memDC);
		EndPaint(hwnd, &paintstruct);
		break;
	  case WM_LBUTTONDOWN:
		DestroyWindow(hwnd);
		break;
	  case WM_DESTROY:
		DeleteObject(hBit1);
		NoBoStop(hwnd);			// the third and last line neede to make the example nonrectangular.
		PostQuitMessage(0);
		break;
	  default:
		return DefWindowProc(hwnd, message, wParam, lParam);
	} //switch

	return 0;
} //WindowFunc
