Program Swirls;


Uses SPX_VGA, Crt, SPX_FNC;


Const
  NumStars = 250;
  MaxRadius = 189;


Type
  Star = Record
    Theta, Radius : Word;
  End;


Var
  Stars : Array[1..NumStars] of Star;
  OCos, OSin : Array[1..1440] of Integer;
  D : Word;
  Pal : RGBList;


Procedure InitStars;
Var
  S : Word;
Begin
  For S := 1 to 1440 do
    Begin
      OCos[S] := Round(Cos(S / 720 * Pi)*128);
      OSin[S] := Round(Sin(S / 720 * Pi)*128);
    End;
  For S := 1 to NumStars do
    Begin
{      Stars[S].Theta := S Mod 5 * (1440 div 5);
      Stars[S].Radius := MaxRadius * S div NumStars;}
      Stars[S].Theta := Random(1440);
      Stars[S].Radius := Random(MaxRadius);
    End;
End;


Function SAR(I : Integer; B : Byte) : Integer;
Var
  T : Integer;
Begin
  ASM
    MOV AX, I
    MOV CL, B
    SAR AX, CL
    MOV T, AX
  End;
  SAR := T;
End;


Function Dist(X, Y : Word; X2, Y2 : Word) : Word;
Var
  Min : Word;
Begin
  X2 := Abs(X2 - X);
  Y2 := Abs(Y2 - Y);
  If X2 > Y2 Then Min := Y2
    Else Min := X2;
  Dist := X2 + Y2 - (Min SHR 1);
End;


Procedure PlaceAndTurnStars(C : Byte);
Var
  S : Byte;
  X, Y : Integer;
Begin
  For S := 1 to NumStars do
    With Stars[S] do
      Begin
        X := SAR(Radius*OCos[Theta],7)+160;
        Y := SAR(Radius*OSin[Theta],7)+100;
        If Range(X, Y, 0, 0, 319, 199) Then
          PSet(X, Y, Radius SHR 4 + 128);
        Inc(Theta, (MaxRadius - Radius) SHR 3);
        If Theta > 1440 Then Dec(Theta,1440);
        Dec(Radius, 1);
        If Radius > 32767 Then Radius := MaxRadius Else
        If Radius > MaxRadius Then Radius := 0;
      End;
End;


Begin
  OpenMode(3);
  Randomize;
  InitStars;
  SetPageActive(2);
  LoadColors('GamePal.Pal', Pal, 256);
  FSetColors(Pal);
  D := 1;
  Repeat
    PlaceAndTurnStars(15);
    FPCopy(Pages[2]^, Pages[1]^);
    Bar(0, 0, 319, 199, 0);
  Until KeyPressed;
  ReadKey;
  CloseMode;
End.