unit mcga256e;
{                                                                           }
{ Unit    -  Tweaked mode 13h MCGA graphics engine                          }
{ Version -  1.0                                                            }
{ Date    -  1/11/93                                                        }
{                                                                           }
{     Copyright (c) 1993 by Chris Woodward.  All rights reserved.           }
{                                                                           }

{**} interface {**}

uses
  CRT;

const
  _CRTParams : Array[0..9] of Word =
    ( $00d06,         { Vertical total                                      }
      $03e07,         { Oferflow (bit 8 of vertical counts)                 }
      $04109,         { Cell height (2 to double-scan)                      }
      $0ea10,         { Vertical sync. start                                }
      $0ac11,         { Vertical syn. end and protect cr0-cr7               }
      $0df12,         { Vertical displayed                                  }
      $00014,         { Turn off dword mode                                 }
      $0e715,         { Vertical blank start                                }
      $00616,         { Vertical blank end                                  }
      $0e317 );       { Turn on byte mode                                   }
  _CRTSize : Word = SizeOf( _CRTParams ) DIV 2;

var
  _ActiveOfs : Word;
  _VisualOfs : Word;

procedure _InitGraph;
procedure _CloseGraph;
procedure _ClearScreen( c : Byte );
procedure _SetVisual( p : Byte );
procedure _SetActive( p : Byte );
procedure _SetAddress( a : Word );
procedure _SetPixel( x, y : Word; c : Byte );
function _ReadPixel( x, y : Word ) : Byte;
procedure _WaitVertical;
procedure _CopyBackground( Page : Byte );

{**} implementation {**}

procedure _InitGraph;
assembler;
asm
  mov ax, 13h
  int 10h
  mov dx, 03c4h
  mov ax, 0604h
  out dx, ax
  mov ax, 0100h
  out dx, ax
  mov dx, 03c2h
  mov al, 0e3h
  out dx, al
  mov dx, 03c4h
  mov ax, 0300h
  out dx, ax
  mov dx, 03d4h
  mov al, 11h
  out dx, al
  inc dx
  in  al, dx
  and al, 7fh
  out dx, al
  dec dx
  cld
  mov ax, seg _CRTParams
  mov ds, ax
  mov si, offset _CRTParams
  mov cx, 0ah
  @SetCRTParams:
    lodsw
    out dx, ax
  loop @SetCRTParams
  mov dx, 03c4h
  mov ax, 0f02h
  out dx, ax
  mov ax, 0a000h
  mov es, ax
  sub di, di
  mov ax, 0000h
  mov cx, 8000h
  rep stosw
end; { _InitGraph }

procedure _CloseGraph;
assembler;
asm
  mov ax, LastMode
  int 10h
end; { _CloseGraph }

procedure _SetVisual( p : Byte );
assembler;
asm
  mov ax, 50h
  mov bl, p
  mul bl
  mov bx, 0f0h
  mul bx
  inc bx
  mov _VisualOfs, ax
  push ax
  mov dx, 03d4h
  mov al, 0ch
  out dx, ax
  pop ax
  mov cl, 8h
  shl ax, cl
  mov al, 0dh
  out dx, ax
end; { _SetVisual }

procedure _SetActive( p : Byte );
assembler;
asm
  mov ax, 50h
  mul p
  mov bx, 0f0h
  mul bx
  inc bx
  mov _ActiveOfs, ax
end; { _SetActive }

procedure _SetAddress( a : Word );
assembler;
asm
  mov bx, a
  mov dx, 03d4h
  mov al, 0ch
  mov ah, bh
  out dx, ax
  mov al, 0dh
  mov ah, bl
  out dx, ax
end; { _SetAddress }

procedure _ClearScreen( c : Byte );
assembler;
asm
  mov dx, 03c4h
  mov ax, 0f02h
  out dx, ax
  mov ax, 0a000h
  mov es, ax
  mov di, _ActiveOfs
  mov al, c
  mov ah, al
  mov cx, 2580h
  rep stosw
end;

procedure _SetPixel( x, y : Word; c : Byte );
Assembler;
asm
  mov ax, 50h
  mul y
  mov bx, x
  shr bx, 1
  shr bx, 1
  add bx, ax
  add bx, _ActiveOfs
  mov ax, 0a000h
  mov es, ax
  mov cx, x
  and cl, 011b
  mov ax, 0102h
  shl ah, cl
  mov dx, 03c4h
  out dx, ax
  mov al, c
  mov es:[bx], al
end; { _SetPixel }

function _ReadPixel( x, y : Word ) : Byte;
assembler;
asm
  mov ax, 50h
  mul y
  mov bx, x
  mov cx, bx
  shr bx, 1
  shr bx, 1
  add bx, ax
  add bx, _ActiveOfs
  mov ax, 0a000h
  mov es, ax
  mov ah, cl
  and ah, 011b
  mov al, 4h
  mov dx, 03ceh
  out dx, ax
  mov al, es:[bx]
end; { _ReadPixel }

procedure _WaitVertical;
assembler;
asm
  mov dx, 03dah
  @Loop1:
    in  al, dx
    and al, 8h
    jnz @Loop1
  @Loop2:
    in  al, dx
    and al, 8h
    jz  @Loop2
end; { _WaitVertical }

procedure _CopyBackground( Page : Byte );
var
  X,
  Y : Word;
  C : Byte;
begin
  For X := 0 to 319 do
    For Y := 0 to 239 do
    begin
      _SetActive( 2 );
      c := _ReadPixel( x, y );
      If C <> 0 then
      begin
        _SetActive( page );
        _SetPixel( x, y, c );
      end;
    end;
end; { _CopyBackGround }
  
begin
  _ActiveOfs := $0000;
  _VisualOfs := $0000;
end.
