/*
	fastintro
	rules
		incl.
			- oldskool olympic fire
			- five olympic donuts 
			- olympic currywurst to the compo
			- professional commercial for MekkaSymposium


 	
	  ms2k+1 pc demo.
	coded by macaw/nan-v+bypass.
	mail: kaae@daimi.au.dk
	web: http://www.daimi.au.dk/~kaae

 	klam lort. tak til Gorm for hans computer, nu er den min. vi er sure paa organizerne nu.
*/


#pragma warning (disable : 4244)
#pragma warning (disable : 4305)
#pragma warning (disable : 4309)



// -- COMMENT THIS OUT TO DISABLE SOUND --
#define SOUND



#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include <math.h>

#include "imagewrapper.h"
#include "alphaimagewrapper.h"
#include "main.h"
#include "mp3player.h"


extern int WIDTH, HEIGHT;


// --- MACRO FOR TIMING (INPUT: MINUTES,SECONDS,HUNDRES) ---
#define __SECONDS(x) (x*1000)
#define __MINUTES(x) (__SECONDS(60*x))
#define TIMER(m,s,h) (__MINUTES(m)+__SECONDS(s)+h)



// --- STARTING POSITION ---
#define TIMEROFF	0


// --- MATH CRAP ---
#define PI		(3.1415926535897932384626433832795)
#define TWOPI	(2.0*PI)
#define M_PI2	TWOPI
#define PID2	(PI/2.0)



// --- STRUCTURES --- 
typedef struct { float x, y, z; } Vector;
typedef struct { float x, y, z, u, v; } Vertex;


// IMAGES
ImageWrapper *gasmasker[7], *hearing[2], *code[4], *gfx[4], *msx[4], *pause[2], *soya[7], *loading, *noise[2], *maskine[10], *kost[3], *slut[10], *ost[7], *bloboverlay, *sphereoverlay;


// TWIST
ImageWrapper *twist_storstamme_texture, *twist_tyndstamme_texture, *twist_kasse_texture, *twist_texture2;
GLuint	TwistBox, TwistBox2;

// TUNNEL
GLuint Tunnel;
ImageWrapper *tunnel_texture, *tunnel_kasse_texture;

// KASSE
ImageWrapper *kasse_trans_texture, *kasse_texture;

// SPHERES
ImageWrapper *spheres_texture1, *spheres_texture2, *spheres_texture3, *spheres_texture4, *sphere_flare;

float SphereTab[1276*6];
float SphereTabCopy[1276*6];

// SPIKE
ImageWrapper *spike_tunnel_texture, *spike_texture, *spike_flare_texture;
Vector *spike_flares;
Vertex *spike_data, *spike_backup_data;
Vertex *spike_tunnel_data;
GLuint	spike_tunnel_list;
int    *spike_indices;
#define spike_sections	200
#define spike_corners	15
#define spike_radius	350
#define spike_section_length	200
#define spike_uwrap		2
#define spike_vwrap		20
#define spike_tunnel_radius	800
#define spike_flare_radius	700.0f
#define spike_flare_rotation 100.0f


// BITMAP
ImageWrapper *bitmap_texture, *bitmap_env;
#define bitmap_subx	25
#define bitmap_suby 25
Vertex *bitmap_data;


// SOUND REPLAYER
MP3Player *soundplayer;


void inline UploadVertex(Vertex *v)
{
	glTexCoord2f(v->u, v->v);
	glVertex3f(v->x, v->y, v->z);
	
}

void inline UploadVertexN(Vertex *v)
{
#define sqr(x) (x*x)
	float	l=10.0f/(float)sqrt(sqr(v->x)+sqr(v->y)+sqr(v->z));
	glNormal3f(v->x*l, v->y*l, v->z*l);
	glTexCoord2f(v->u, v->v);
	glVertex3f(v->x, v->y, v->z);
#undef sqr
}

void inline UploadVertexARB(Vertex *v)
{
#define sqr(x) (x*x)
	float	l=10.0f/(float)sqrt(sqr(v->x)+sqr(v->y)+sqr(v->z));
	glNormal3f(v->x*l, v->y*l, v->z*l);
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB, v->u, v->v); 
	glVertex3f(v->x, v->y, v->z);
#undef sqr
}


void inline DisplayAlphaImage(ImageWrapper *image)
{
	glPushMatrix();
		glAlphaFunc(GL_GREATER, 0.5);

		glEnable(GL_ALPHA_TEST);
		
		glDisable(GL_DEPTH_TEST);
		glBindTexture(GL_TEXTURE_2D, image->texture_id);
		image->RawPaint();
		

		glDisable(GL_ALPHA_TEST);
		glEnable(GL_DEPTH_TEST);
//		glDepthMask(GL_ALWAYS);
	glPopMatrix();
}

// -- GENERATORS --


// build a cylinder
Vertex * GenerateCylinder(int sections, int corners, float radius, float section_length, float u_texture_wrap, float v_texture_wrap)
{
#define SETVERTEX(x,y,z,which) { data[which].x=x; data[which].y=y; data[which].z=z; }

	Vertex *data = new Vertex [corners*(sections+1)];

	int numfaces=0;
	int numverts=0;

	// vertices
	for (int j=0; j<sections+1; j++)
	{
		float z = (j*section_length);//-(sections*section_length/2.0f);

		float center_x=0;// float(sin(14*(M_PI2/sections)*j)*400);
		float center_y=0;// float(cos(14*(M_PI2/sections)*j)*400);

		for (int i=0; i<corners; i++)
		{
			double currentstep = (M_PI2/corners)*i;

			float x = float(radius*sin(currentstep)+center_x);
			float y = float(radius*cos(currentstep)+center_y);
		

			SETVERTEX(x, y, z, numverts);


			if (i%1) 
			{
				data[numverts].u=float(u_texture_wrap/corners*i);
				data[numverts].v=float(v_texture_wrap/(sections+1.0)*j);
			}
			else 
			{
				data[numverts].v=float(u_texture_wrap/corners*i);
				data[numverts].u=float(v_texture_wrap/(sections+1.0)*j);
			}

			numverts++;
		}
	}
#undef SETVERTEX
	return data;
}

void UploadCylinder(int sections, int corners, Vertex *data)
{
	glBegin(GL_TRIANGLES);
	int index=0;
	for (int i=0; i<sections; i++)
	{
		for (int j=0; j<corners-1; j++)
		{
			UploadVertexN(&data[index]);
			UploadVertexN(&data[index+1]);
			UploadVertexN(&data[index+corners]);

			UploadVertexN(&data[index+1]);
			UploadVertexN(&data[index+1+corners]);
			UploadVertexN(&data[index+corners]);
			
			index++;
		}
	}
	glEnd();
}


// build a plane with the given subdivision
Vertex * MakePlane(float width, float height, int subx, int suby, float z, float uwrap, float vwrap)
{
	int vertices = subx*suby;
	Vertex * data = new Vertex [subx*suby];

	float heightd2 = height/2.0f;
	float widthd2  = width/2.0f;
	
	float xstep = width/float(subx);
	float ystep = height/float(suby);

	float ustep = uwrap/float(subx);
	float vstep = vwrap/float(suby);

	for (int j=0; j<suby; j++)
	{
		for (int i=0; i<subx; i++)	
		{
			int index = j*subx+i;
			data[index].x = float(i*xstep)-widthd2;
			data[index].y = float(j*ystep)-heightd2;
			data[index].z = z;
			data[index].u = float(i*ustep);
			data[index].v = float(j*vstep);
		}
	}
	return data;
}

// upload a plane with the given subdivision
void UploadPlane(int subx, int suby, Vertex *data)
{
	glBegin(GL_TRIANGLES);
	int index0 = 0;
	for (int j=0; j<suby-1; j++, index0+=subx)
	{
		int index = index0;
		for (int i=0; i<subx-1; i++)
		{	
			
			UploadVertexARB(&data[index]);
			UploadVertexARB(&data[index+1]);
			UploadVertexARB(&data[index+subx]);

			UploadVertexARB(&data[index+1]);
			UploadVertexARB(&data[index+1+subx]);
			UploadVertexARB(&data[index+subx]);

			index++;
		}
	}
	glEnd();
}

void PutSphere(float cx, float cy, float cz,double r,int n, float uwrap, float vwrap)
{
	static unsigned char SphereTabOK=0;
	unsigned int counter=0;
	int i,j;
    double theta1,theta2,theta3;
	Vector e,p;


	if (r < 0) r = -r;
	if (n < 0) n = -n;
	if (n < 4 || r <= 0) return;


	if (SphereTabOK==1)
	{
		for (j=0;j<n/2;j++) {
			theta1 = j * TWOPI / n - PID2;
			theta2 = (j + 1) * TWOPI / n - PID2;

			glBegin(GL_QUAD_STRIP);
			for (i=0;i<=n;i++) {
				counter++;
				theta3 = i * TWOPI / n;

				int index = counter*6;

				e.x = SphereTab[index+0];
				e.y = SphereTab[index+1];
				e.z = SphereTab[index+2];
				p.x = float(cx + r * e.x);
				p.y = float(cy + r * e.y);
				p.z = float(cz + r * e.z);

				glNormal3f(e.x,e.y,e.z);
				glTexCoord2f(float(uwrap*i/(float)n),float(vwrap*2*(j+1)/(float)n));
				glVertex3f(p.x,p.y,p.z);

				e.x = SphereTab[index+3];
				e.y = SphereTab[index+4];
				e.z = SphereTab[index+5];
				p.x = float(cx + r * e.x);
				p.y = float(cy + r * e.y);
				p.z = float(cz + r * e.z);

				glNormal3f(e.x,e.y,e.z);
				glTexCoord2f(float(uwrap*i/(float)n),float(vwrap*2*j/(float)n));
				glVertex3f(p.x,p.y,p.z);
			}
			glEnd();
		}
	}
	else
	{
		for (j=0;j<n/2;j++) {
			theta1 = j * TWOPI / n - PID2;
			theta2 = (j + 1) * TWOPI / n - PID2;

			glBegin(GL_QUAD_STRIP);
			for (i=0;i<=n;i++) {
				counter++;
				int index=6*counter;
				theta3 = i * TWOPI / n;

				e.x = float(cos(theta2) * cos(theta3));
				e.y = float(sin(theta2));
				e.z = float(cos(theta2) * sin(theta3));
				p.x = float(cx + r * e.x);
				p.y = float(cy + r * e.y);
				p.z = float(cz + r * e.z);


				SphereTab[index+0]=e.x;
				SphereTab[index+1]=e.y;
				SphereTab[index+2]=e.z;

				glNormal3f(e.x,e.y,e.z);
				glTexCoord2f(float(uwrap*i/(float)n),float(vwrap*2*(j+1)/(float)n));
				glVertex3f(p.x,p.y,p.z);

				e.x = float(cos(theta1) * cos(theta3));
				e.y = float(sin(theta1));
				e.z = float(cos(theta1) * sin(theta3));
				p.x = float(cx + r * e.x);
				p.y = float(cy + r * e.y);
				p.z = float(cz + r * e.z);

				SphereTab[index+3]=e.x;
				SphereTab[index+4]=e.y;
				SphereTab[index+5]=e.z;

				glNormal3f(e.x,e.y,e.z);
				glTexCoord2f(float(uwrap*i/(float)n),float(vwrap*2*j/(float)n));
				glVertex3f(p.x,p.y,p.z);
			}
			glEnd();
		}
		memcpy(SphereTabCopy, SphereTab, sizeof(float)*6*1276);
	}
	SphereTabOK=1;
}

void PutSphereMulti(float cx, float cy, float cz,double r,int n, float uwrap, float vwrap)
{
	static unsigned char SphereTabOK=0;
	unsigned int counter=0;
	int i,j;
    double theta1,theta2,theta3;
	Vector e,p;


	if (r < 0) r = -r;
	if (n < 0) n = -n;
	if (n < 4 || r <= 0) return;


	if (SphereTabOK==1)
	{
		for (j=0;j<n/2;j++) {
			theta1 = j * TWOPI / n - PID2;
			theta2 = (j + 1) * TWOPI / n - PID2;

			glBegin(GL_QUAD_STRIP);
			for (i=0;i<=n;i++) {
				counter++;
				theta3 = i * TWOPI / n;

				int index = counter*6;

				e.x = SphereTab[index+0];
				e.y = SphereTab[index+1];
				e.z = SphereTab[index+2];
				p.x = float(cx + r * e.x);
				p.y = float(cy + r * e.y);
				p.z = float(cz + r * e.z);

				glNormal3f(e.x,e.y,e.z);
				glMultiTexCoord2fARB(GL_TEXTURE0_ARB, float(uwrap*i/(float)n),float(vwrap*2*(j+1)/(float)n));
				glVertex3f(p.x,p.y,p.z);

				e.x = SphereTab[index+3];
				e.y = SphereTab[index+4];
				e.z = SphereTab[index+5];
				p.x = float(cx + r * e.x);
				p.y = float(cy + r * e.y);
				p.z = float(cz + r * e.z);

				glNormal3f(e.x,e.y,e.z);
				glMultiTexCoord2fARB(GL_TEXTURE0_ARB, float(uwrap*i/(float)n),float(vwrap*2*j/(float)n));
				glVertex3f(p.x,p.y,p.z);
			}
			glEnd();
		}
	}
	else
	{
		for (j=0;j<n/2;j++) {
			theta1 = j * TWOPI / n - PID2;
			theta2 = (j + 1) * TWOPI / n - PID2;

			glBegin(GL_QUAD_STRIP);
			for (i=0;i<=n;i++) {
				counter++;
				int index=6*counter;
				theta3 = i * TWOPI / n;

				e.x = float(cos(theta2) * cos(theta3));
				e.y = float(sin(theta2));
				e.z = float(cos(theta2) * sin(theta3));
				p.x = float(cx + r * e.x);
				p.y = float(cy + r * e.y);
				p.z = float(cz + r * e.z);


				SphereTab[index+0]=e.x;
				SphereTab[index+1]=e.y;
				SphereTab[index+2]=e.z;

				glNormal3f(e.x,e.y,e.z);
				glTexCoord2f(float(uwrap*i/(float)n),float(vwrap*2*(j+1)/(float)n));
				glVertex3f(p.x,p.y,p.z);

				e.x = float(cos(theta1) * cos(theta3));
				e.y = float(sin(theta1));
				e.z = float(cos(theta1) * sin(theta3));
				p.x = float(cx + r * e.x);
				p.y = float(cy + r * e.y);
				p.z = float(cz + r * e.z);

				SphereTab[index+3]=e.x;
				SphereTab[index+4]=e.y;
				SphereTab[index+5]=e.z;

				glNormal3f(e.x,e.y,e.z);
				glTexCoord2f(float(uwrap*i/(float)n),float(vwrap*2*j/(float)n));
				glVertex3f(p.x,p.y,p.z);
			}
			glEnd();
		}
		memcpy(SphereTabCopy, SphereTab, sizeof(float)*6*1276);
	}
	SphereTabOK=1;
}


void DistortSphereDisable()
{
	memcpy(SphereTab, SphereTabCopy, sizeof(float)*6*1276);
}

void DistortSphere(float Blobxdiv, float Blobydiv, float Blobzdiv, float Blobscalefactor, float BlobCount)
{
	for (int i=0; i<1276; i++)
	{
		int index = i*6;
		float scale=(float)(1.0+
			sin(SphereTabCopy[index+0]/Blobxdiv+BlobCount*2.2)*Blobscalefactor+
			sin(SphereTabCopy[index+1]/Blobydiv+BlobCount*5)*Blobscalefactor+
			sin(SphereTabCopy[index+2]/Blobzdiv+BlobCount*4.9)*Blobscalefactor);
			SphereTab[index+0] = SphereTabCopy[index+0]*scale;
			SphereTab[index+1] = SphereTabCopy[index+1]*scale;
			SphereTab[index+2] = SphereTabCopy[index+2]*scale;

		scale=(float)(1.0+
			sin(SphereTabCopy[index+3]/Blobxdiv+BlobCount*2.2)*Blobscalefactor+
			sin(SphereTabCopy[index+4]/Blobydiv+BlobCount*5)*Blobscalefactor+
			sin(SphereTabCopy[index+5]/Blobzdiv+BlobCount*4.9)*Blobscalefactor);
			SphereTab[index+3] = SphereTabCopy[index+3]*scale;
			SphereTab[index+4] = SphereTabCopy[index+4]*scale;
			SphereTab[index+5] = SphereTabCopy[index+5]*scale;


			for (int j=0; j<6; j++) 
			{
#define R	1.0
				if (SphereTab[index+j]>R) SphereTab[index+j]=R;
				if (SphereTab[index+j]<-R) SphereTab[index+j]=-R;
#undef R
			}
	}
}

void DistortSphereKaren(float Blobxdiv, float Blobydiv, float Blobzdiv, float Blobscalefactor, float BlobCount)
{
	for (int i=0; i<1276; i++)
	{
		int index = i*6;
		float scale=(float)(1.0+
			sin(SphereTabCopy[index+0]/Blobxdiv+BlobCount*2.2)*Blobscalefactor+
			sin(SphereTabCopy[index+1]/Blobydiv+BlobCount*5)*Blobscalefactor+
			sin(SphereTabCopy[index+2]/Blobzdiv+BlobCount*4.9)*Blobscalefactor);
		SphereTab[index+0] = SphereTabCopy[index+0]*scale;
		SphereTab[index+1] = SphereTabCopy[index+1]*scale;
		SphereTab[index+2] = SphereTabCopy[index+2]*scale;
		
		scale=(float)(1.0+
			sin(SphereTabCopy[index+3]/Blobxdiv+BlobCount*2.2)*Blobscalefactor+
			sin(SphereTabCopy[index+4]/Blobydiv+BlobCount*5)*Blobscalefactor+
			sin(SphereTabCopy[index+5]/Blobzdiv+BlobCount*4.9)*Blobscalefactor);
		SphereTab[index+3] = SphereTabCopy[index+3]*scale;
		SphereTab[index+4] = SphereTabCopy[index+4]*scale;
		SphereTab[index+5] = SphereTabCopy[index+5]*scale;
	}
}


void inline PutBox(float centerx, float centery, float centerz, float scalex, float scaley, float scalez, float wrap_u, float wrap_v, int texture_id)
{
	glBindTexture(GL_TEXTURE_2D, texture_id);

	glBegin(GL_QUADS);
	
	glTexCoord2f(0,0);				glVertex3f ( scalex+centerx, scaley+centery,-scalez+centerz); 
	glTexCoord2f(wrap_u,0);			glVertex3f (-scalex+centerx, scaley+centery,-scalez+centerz); 
	glTexCoord2f(wrap_u,wrap_v);	glVertex3f (-scalex+centerx,-scaley+centery,-scalez+centerz);
	glTexCoord2f(0,wrap_v);			glVertex3f ( scalex+centerx,-scaley+centery,-scalez+centerz); 
		
	glTexCoord2f(0,0);				glVertex3f (-scalex+centerx, scaley+centery, scalez+centerz); 
	glTexCoord2f(wrap_u,0);			glVertex3f ( scalex+centerx, scaley+centery, scalez+centerz); 
	glTexCoord2f(wrap_u,wrap_v);	glVertex3f ( scalex+centerx,-scaley+centery, scalez+centerz); 
	glTexCoord2f(0,wrap_v);			glVertex3f (-scalex+centerx,-scaley+centery, scalez+centerz); 
	
	
	glTexCoord2f(0,0);				glVertex3f (-scalex+centerx, scaley+centery,-scalez+centerz); 
	glTexCoord2f(wrap_u,0);			glVertex3f (-scalex+centerx, scaley+centery, scalez+centerz); 
	glTexCoord2f(wrap_u,wrap_v);	glVertex3f (-scalex+centerx,-scaley+centery, scalez+centerz); 
	glTexCoord2f(0,wrap_v);			glVertex3f (-scalex+centerx,-scaley+centery,-scalez+centerz); 
	

	glTexCoord2f(0,0);				glVertex3f ( scalex+centerx, scaley+centery, scalez+centerz); 
	glTexCoord2f(wrap_u,0);			glVertex3f ( scalex+centerx, scaley+centery,-scalez+centerz); 
	glTexCoord2f(wrap_u,wrap_v);	glVertex3f ( scalex+centerx,-scaley+centery,-scalez+centerz); 
	glTexCoord2f(0,wrap_v);			glVertex3f ( scalex+centerx,-scaley+centery, scalez+centerz); 
	
	glTexCoord2f(0,0);				glVertex3f (-scalex+centerx,-scaley+centery,-scalez+centerz); 
	glTexCoord2f(wrap_u,0);			glVertex3f (-scalex+centerx,-scaley+centery, scalez+centerz); 
	glTexCoord2f(wrap_u,wrap_v);	glVertex3f ( scalex+centerx,-scaley+centery, scalez+centerz); 
	glTexCoord2f(0,wrap_v);			glVertex3f ( scalex+centerx,-scaley+centery,-scalez+centerz); 
	
	glTexCoord2f(0,0);				glVertex3f (-scalex+centerx, scaley+centery, scalez+centerz); 
	glTexCoord2f(wrap_u,0);			glVertex3f (-scalex+centerx, scaley+centery,-scalez+centerz); 
	glTexCoord2f(wrap_u,wrap_v);	glVertex3f ( scalex+centerx, scaley+centery,-scalez+centerz); 
	glTexCoord2f(0,wrap_v);			glVertex3f ( scalex+centerx, scaley+centery, scalez+centerz); 

/*
		// Front Face
		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);	// Bottom Left Of The Texture and Quad
		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  1.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  1.0f);	// Top Left Of The Texture and Quad
		// Back Face
		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f, -1.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);	// Top Left Of The Texture and Quad
		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f, -1.0f);	// Bottom Left Of The Texture and Quad
		// Top Face
		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);	// Top Left Of The Texture and Quad
		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f,  1.0f,  1.0f);	// Bottom Left Of The Texture and Quad
		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f,  1.0f,  1.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);	// Top Right Of The Texture and Quad
		// Bottom Face
		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f, -1.0f, -1.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f, -1.0f, -1.0f);	// Top Left Of The Texture and Quad
		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);	// Bottom Left Of The Texture and Quad
		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);	// Bottom Right Of The Texture and Quad
		// Right face
		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f, -1.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  1.0f);	// Top Left Of The Texture and Quad
		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);	// Bottom Left Of The Texture and Quad
		// Left Face
		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f, -1.0f);	// Bottom Left Of The Texture and Quad
		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  1.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);	// Top Left Of The Texture and Quad
*/

	glEnd();
	
	glBindTexture(GL_TEXTURE_2D, 0);
}


// --- INITIALIZERS ---

void inline SetupFog(float near_dist, float far_dist, float density)
{
	static float fogcolor[4] = {0.0f,0.0f,0.0f,0.0f};
	glFogi(GL_FOG_MODE, GL_EXP);
	glFogfv(GL_FOG_COLOR, fogcolor);
	glFogf(GL_FOG_DENSITY, density);
	glHint(GL_FOG_HINT, GL_DONT_CARE);
	glFogf(GL_FOG_START, near_dist);
	glFogf(GL_FOG_END, far_dist);
	glEnable(GL_FOG);
}


void InitSpheres()
{
	sphere_flare = new AlphaImageWrapper("data\\sphere_flare.jpg", "data\\sphere_flare.jpg");
	sphere_flare->SetDefaults();
	spheres_texture1 = new ImageWrapper("data\\spheres_texture1.jpg");
	spheres_texture2 = new ImageWrapper("data\\spheres_texture2.jpg");
	spheres_texture3 = new ImageWrapper("data\\spheres_texture3.jpg");
	spheres_texture4 = new ImageWrapper("data\\spheres_texture1.jpg");
}


void InitTwist()
{
	twist_texture2 = new ImageWrapper("data/twistbox2.jpg");
	twist_storstamme_texture=new ImageWrapper("data\\twist_1.jpg");
	twist_tyndstamme_texture=new ImageWrapper("data\\twist_2.jpg");
	twist_kasse_texture=new ImageWrapper("data\\twist_3.jpg");


	TwistBox = glGenLists(1);
	glNewList(TwistBox,GL_COMPILE);
//		glDisable(GL_CULL_FACE);
		PutBox(0,0,0, 2, 20, 2, 2, 1, twist_storstamme_texture->texture_id);
		
		PutBox(0,2.5,0, 20, 1, 1, 1, 1, twist_tyndstamme_texture->texture_id);
		PutBox(0,-2.5,0, 20, 1, 1, 1, 1, twist_tyndstamme_texture->texture_id);
	glEndList();
//PutBox(float centerx, float centery, float centerz, float scalex, float scaley, float scalez, float wrap_u, float wrap_v, int texture_id)

	TwistBox2 = glGenLists(1);
		glNewList(TwistBox2, GL_COMPILE);
		PutBox(0,  0,  0, 
			   2.5,  20,  2.5, 
			   1, 20, twist_texture2->texture_id);
	glEndList();
}


void InitKasse()
{
	kasse_texture = new ImageWrapper("data\\kasse_texture.jpg");
	kasse_trans_texture = new AlphaImageWrapper("data\\kasse_trans_texture.jpg", "data\\kasse_trans_texture.jpg");
}

void InitTunnel()
{
	tunnel_texture = new ImageWrapper("data\\tunnel_texture.jpg");
	tunnel_kasse_texture = new ImageWrapper("data\\tunnel_kasse_texture.jpg");
	Tunnel = glGenLists(1);
	glNewList(Tunnel, GL_COMPILE);
		PutBox( 0, 0, 0,
			    12, 12,1000,
				50, 1,
				tunnel_texture->texture_id);

		for (int i=0; i<20; i++)
		{
			PutBox( 0, 0, float(i*100.0f-1000.0f),
				    7, 7, 7,
					1, 1,
					tunnel_kasse_texture->texture_id);
		}

	glEndList();
}


void InitBitmap()
{
	bitmap_texture = new ImageWrapper("data\\bitmap_texture.jpg");
	bitmap_env = new ImageWrapper("data\\bitmap_env.jpg");
	
	bitmap_data = MakePlane(75, 75, bitmap_subx, bitmap_suby, -10, 2, 2);
}


void InitSpike()
{
	spike_data = GenerateCylinder(spike_sections, spike_corners, spike_radius, spike_section_length, spike_uwrap, spike_vwrap);
	spike_backup_data = GenerateCylinder(spike_sections, spike_corners, spike_radius, spike_section_length, spike_uwrap, spike_vwrap);
	spike_tunnel_data = GenerateCylinder(spike_sections, spike_corners, spike_tunnel_radius, spike_section_length, spike_uwrap, spike_vwrap);

	spike_texture = new ImageWrapper("data\\spike_texture.jpg");
	spike_tunnel_texture = new ImageWrapper("data\\spike_tunnel_texture.jpg");
	spike_flare_texture = new AlphaImageWrapper("data\\spike_flare_texture.jpg", "data\\spike_flare_texture.jpg");


	spike_indices = new int [200];
	for (int i=0; i<200; i++)
	{
		spike_indices[i]=(i+rand())%16;

		if (i>0)
		{
			while (spike_indices[i]==spike_indices[i-1])
			{
				spike_indices[i]=(i+rand())%16;
			}
		}
	}

	spike_flare_texture->SetScale(100);

	spike_flares = new Vector [spike_sections];

	for (i=0; i<spike_sections; i++)
	{
		float rot = float(spike_flare_rotation*TWOPI/spike_sections*i);
		spike_flares[i].x = spike_flare_radius*sin(rot);
		spike_flares[i].y = spike_flare_radius*cos(rot);
		spike_flares[i].z = spike_section_length*i;
	}


	spike_tunnel_list = glGenLists(1);
	glNewList(spike_tunnel_list,GL_COMPILE);
		glBindTexture(GL_TEXTURE_2D, spike_tunnel_texture->texture_id);
		UploadCylinder(spike_sections, spike_corners, spike_tunnel_data);
		glBindTexture(GL_TEXTURE_2D, 0);
	glEndList();
}

void InitImages()
{
	sphereoverlay=new AlphaImageWrapper("data/sphereoverlay_alfa.jpg", "data/sphereoverlay.jpg"); 
	sphereoverlay->SetDefaults();
	
	bloboverlay =new AlphaImageWrapper("data/bloboverlay_alfa.jpg", "data/bloboverlay.jpg");
	bloboverlay->SetDefaults();

	slut[0]=new AlphaImageWrapper("data/slut1_alfa.jpg","data/slut1.jpg");
	slut[0]->SetDefaults();
	slut[1]=new AlphaImageWrapper("data/slut2_alfa.jpg","data/slut2.jpg");
	slut[1]->SetDefaults();
	slut[2]=new AlphaImageWrapper("data/slut3_alfa.jpg","data/slut3.jpg");
	slut[2]->SetDefaults();
	slut[3]=new AlphaImageWrapper("data/slut4_alfa.jpg","data/slut4.jpg");
	slut[3]->SetDefaults();
	slut[4]=new AlphaImageWrapper("data/slut5_alfa.jpg","data/slut5.jpg");
	slut[4]->SetDefaults();
	slut[5]=new AlphaImageWrapper("data/slut6_alfa.jpg","data/slut6.jpg");
	slut[5]->SetDefaults();
	slut[6]=new AlphaImageWrapper("data/slut7_alfa.jpg","data/slut7.jpg");
	slut[6]->SetDefaults();
	slut[7]=new AlphaImageWrapper("data/slut8_alfa.jpg","data/slut8.jpg");
	slut[7]->SetDefaults();
	slut[8]=new AlphaImageWrapper("data/slut9_alfa.jpg","data/slut9.jpg");
	slut[8]->SetDefaults();
	slut[9]=new AlphaImageWrapper("data/slut10_alfa.jpg","data/slut10.jpg");
	slut[9]->SetDefaults();

	maskine[0]=new AlphaImageWrapper("data/maskine1_alfa.jpg","data/maskine1.jpg");
	maskine[0]->SetDefaults();
	maskine[1]=new AlphaImageWrapper("data/maskine2_alfa.jpg","data/maskine2.jpg");
	maskine[1]->SetDefaults();
	maskine[2]=new AlphaImageWrapper("data/maskine3_alfa.jpg","data/maskine3.jpg");
	maskine[2]->SetDefaults();
	maskine[3]=new AlphaImageWrapper("data/maskine4_alfa.jpg","data/maskine4.jpg");
	maskine[3]->SetDefaults();
	maskine[4]=new AlphaImageWrapper("data/maskine5_alfa.jpg","data/maskine5.jpg");
	maskine[4]->SetDefaults();
	maskine[5]=new AlphaImageWrapper("data/maskine6_alfa.jpg","data/maskine6.jpg");
	maskine[5]->SetDefaults();
	maskine[6]=new AlphaImageWrapper("data/maskine7_alfa.jpg","data/maskine7.jpg");
	maskine[6]->SetDefaults();
	maskine[7]=new AlphaImageWrapper("data/maskine8_alfa.jpg","data/maskine8.jpg");
	maskine[7]->SetDefaults();
	maskine[8]=new AlphaImageWrapper("data/maskine8_alfa.jpg","data/maskine9.jpg");
	maskine[8]->SetDefaults();
	maskine[9]=new AlphaImageWrapper("data/maskine8_alfa.jpg","data/maskine10.jpg");
	maskine[9]->SetDefaults();

	ost[0]=new AlphaImageWrapper("data/ost1_alfa.jpg", "data/ost1.jpg");
	ost[0]->SetDefaults();
	ost[1]=new AlphaImageWrapper("data/ost2_alfa.jpg", "data/ost2.jpg");
	ost[1]->SetDefaults();
	ost[2]=new AlphaImageWrapper("data/ost3_alfa.jpg", "data/ost3.jpg");
	ost[2]->SetDefaults();
	ost[3]=new AlphaImageWrapper("data/ost4_alfa.jpg", "data/ost4.jpg");
	ost[3]->SetDefaults();
	ost[4]=new AlphaImageWrapper("data/ost5_alfa.jpg", "data/ost5.jpg");
	ost[4]->SetDefaults();
	ost[5]=new AlphaImageWrapper("data/ost6_alfa.jpg", "data/ost6.jpg");
	ost[5]->SetDefaults();
	ost[6]=new AlphaImageWrapper("data/ost7_alfa.jpg", "data/ost7.jpg");
	ost[6]->SetDefaults();
	
	kost[0]=new AlphaImageWrapper("data/kost1_alfa.jpg","data/kost1.jpg");
	kost[0]->SetDefaults();
	kost[1]=new AlphaImageWrapper("data/kost2_alfa.jpg","data/kost2.jpg");
	kost[1]->SetDefaults();
	kost[2]=new AlphaImageWrapper("data/kost3_alfa.jpg","data/kost3.jpg");
	kost[2]->SetDefaults();

	noise[0] = new AlphaImageWrapper("data/nois1.jpg", "data/nois1.jpg");
	noise[0]->SetDefaults();
	noise[1] = new AlphaImageWrapper("data/nois2.jpg", "data/nois2.jpg");
	noise[1]->SetDefaults();


	soya[0] = new ImageWrapper("data/soya1.jpg");
	soya[0]->SetDefaults();
	soya[1] = new ImageWrapper("data/soya2.jpg");
	soya[1]->SetDefaults();
	soya[2] = new ImageWrapper("data/soya3.jpg");
	soya[2]->SetDefaults();
	soya[3] = new ImageWrapper("data/soya4.jpg");
	soya[3]->SetDefaults();
	soya[4] = new ImageWrapper("data/soya5.jpg");
	soya[4]->SetDefaults();
	soya[5] = new ImageWrapper("data/soya6.jpg");
	soya[5]->SetDefaults();
	soya[6] = new ImageWrapper("data/soya7.jpg");
	soya[6]->SetDefaults();


	gasmasker[0] = new AlphaImageWrapper("data/maskine8_alfa.jpg","data/maskine11.jpg");
	gasmasker[0]->SetDefaults();
	gasmasker[1] = new AlphaImageWrapper("data/maskine8_alfa.jpg","data/maskine12.jpg");
	gasmasker[1]->SetDefaults();
	gasmasker[2] = new AlphaImageWrapper("data/maskine8_alfa.jpg","data/maskine13.jpg");
	gasmasker[2]->SetDefaults();
	gasmasker[3] = new AlphaImageWrapper("data/maskine8_alfa.jpg","data/maskine14.jpg");
	gasmasker[3]->SetDefaults();
	gasmasker[4] = new AlphaImageWrapper("data/maskine8_alfa.jpg","data/maskine15.jpg");
	gasmasker[4]->SetDefaults();
	gasmasker[5] =new AlphaImageWrapper("data/maskine8_alfa.jpg","data/maskine16.jpg");
	gasmasker[5]->SetDefaults();
	gasmasker[6] =new AlphaImageWrapper("data/maskine8_alfa.jpg","data/maskine17.jpg");
	gasmasker[6]->SetDefaults();

	hearing[0] = new ImageWrapper("data/hearing1.jpg");
	hearing[0]->SetDefaults();
	hearing[1] = new ImageWrapper("data/hearing2.jpg");
	hearing[1]->SetDefaults();

	code[0]=new ImageWrapper("data/code1.jpg");
	code[0]->SetDefaults();
	code[1]=new ImageWrapper("data/code2.jpg");
	code[1]->SetDefaults();
	code[2]=new ImageWrapper("data/code3.jpg");
	code[2]->SetDefaults();
	code[3]=new ImageWrapper("data/code4.jpg");
	code[3]->SetDefaults();

	gfx[0]=new ImageWrapper("data/gfx1.jpg");
	gfx[0]->SetDefaults();
	gfx[1]=new ImageWrapper("data/gfx2.jpg");
	gfx[1]->SetDefaults();
	gfx[2]=new ImageWrapper("data/gfx3.jpg");
	gfx[2]->SetDefaults();
	gfx[3]=new ImageWrapper("data/gfx4.jpg");
	gfx[3]->SetDefaults();


	msx[0]=new ImageWrapper("data/msx1.jpg");
	msx[0]->SetDefaults();
	msx[1]=new ImageWrapper("data/msx2.jpg");
	msx[1]->SetDefaults();
	msx[2]=new ImageWrapper("data/msx3.jpg");
	msx[2]->SetDefaults();
	msx[3]=new ImageWrapper("data/msx4.jpg");
	msx[3]->SetDefaults();

	pause[0]=new ImageWrapper("data/pause1.jpg");
	pause[0]->SetDefaults();
	pause[1]=new ImageWrapper("data/pause2.jpg");
	pause[1]->SetDefaults();
}


extern void BlitGL();

char Init()
{
	glLoadIdentity();
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	loading = new ImageWrapper("data/loading.jpg");
	loading->SetDefaults();
	loading->Paint();
	BlitGL();

	soundplayer = new MP3Player("data/music.mp3");
	InitTwist();
	InitTunnel();
	InitKasse();
	InitSpheres();
	InitBitmap();
	InitSpike();
	InitImages();


#ifdef SOUND
	soundplayer->Play();
#endif
	return 1;
}

void Deinit()
{
	delete soundplayer;
}



// -- EFFECTS --


void ClearFrame(int start, int slut)
{
	glEnable(GL_SCISSOR_TEST);
		glScissor(start, 0, slut, 480);
		glClear(GL_COLOR_BUFFER_BIT);
	glDisable(GL_SCISSOR_TEST);
}

void DistortCylinder(float scale, int sections, int corners, Vertex *backup, Vertex *data)
{
	int numvertices=0;

	for (int j=1; j<sections; j++)
	{
		float cx = 0;
		float cy = 0;

		if (j%2==1)
		{
			int start = spike_indices[j];
			for (int i=start; i<corners; i+=4)
			{
				int numverts=j*corners+i;
				spike_data[numverts].x = spike_backup_data[numverts].x*scale+cx;
				spike_data[numverts].y = spike_backup_data[numverts].y*scale+cx;
				spike_data[numverts].z = spike_backup_data[numverts].z;
			}
		}
		else
		{
			int start = spike_indices[j];
			for (int i=start; i<corners; i+=4)
			{
				int numverts=j*corners+i;
				spike_data[numverts].x = spike_backup_data[numverts].x;
				spike_data[numverts].y = spike_backup_data[numverts].y;
				spike_data[numverts].z = spike_backup_data[numverts].z;
			}
		}
	}
}


void SpikeFrame(unsigned long TIME, float a)
{
	SetupFog(0, 1000, 0.0002);

	float c = a;
	float cplus = c+0.2;

	float color = 0.5*sin(c/2)+0.5;
	
	DistortCylinder(1+(0.5+sin(c)*0.5),spike_sections,spike_corners, spike_backup_data, spike_data);

	spike_flare_texture->SetScale(100+50*sin(c*2));


	float ad = 0;

	glPushMatrix();
		gluLookAt(500*sin(c)+ad, 500*cos(c)+ad, TIME, 
			      500*sin(cplus)+ad, 500*cos(cplus)+ad,TIME+1000, 
				  0, 1, 0);

		glBindTexture(GL_TEXTURE_2D, spike_texture->texture_id);
		UploadCylinder(spike_sections, spike_corners, spike_data);

		glCallList(spike_tunnel_list);

		glDepthMask(GL_FALSE);
		glEnable(GL_BLEND);
			glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
			glBindTexture(GL_TEXTURE_2D, spike_flare_texture->texture_id);

			for (int i=0; i<spike_sections; i++)
			{
				spike_flare_texture->SetPosition(spike_flares[i].x, spike_flares[i].y, spike_flares[i].z);
				spike_flare_texture->RawPaint();
			}
		glDisable(GL_BLEND);
		glDepthMask(GL_TRUE); 


		glBindTexture(GL_TEXTURE_2D, 0);


	glPopMatrix();

	

	glDisable(GL_FOG);
}


void BitmapFrame(float c)
{
	glPushMatrix();
	
	glClearColor(0,0,0,0);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();

	glRotatef(360*sin(c/8), 0, 0, 1);
	glTranslatef(10*sin(c/2), 10*cos(c/3), 10*sin(c/2));

	static float bitmap_xtab[bitmap_subx];
	for (int k=0; k<bitmap_subx; k++) {
		bitmap_xtab[k]=5*cos(c+k*(10.0/bitmap_subx));
		if (bitmap_xtab[k]<0) bitmap_xtab[k]*=2;
	}

	float z = sin(c/3)*10-35;

	for (int i=0; i<bitmap_suby; i++)
	{
		float addy = 5*sin(i*(13.0/bitmap_suby)+c);
		if (addy<0) addy*=2;
		for (int j=0; j<bitmap_subx; j++)
		{
			bitmap_data[i*bitmap_subx+j].z=z+addy+bitmap_xtab[j];
//			bitmap_data[i*bitmap_subx+j].u=sin(i*(4.0/bitmap_suby)+c)+1;
//			bitmap_data[i*bitmap_subx+j].v=cos(j*(3.14/bitmap_subx)+c)+1;
		}
	}

	// texture1
	glActiveTextureARB(GL_TEXTURE0_ARB);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, bitmap_texture->texture_id);
    glTexParameterf (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
    glTexParameterf (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);


	// texture2 -- envmap
	glActiveTextureARB(GL_TEXTURE1_ARB);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, bitmap_env->texture_id);
	glTexGeni(GL_S,GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
	glEnable(GL_TEXTURE_GEN_S);
	glTexGeni(GL_T,GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
	glEnable(GL_TEXTURE_GEN_T);
	
	UploadPlane(bitmap_subx, bitmap_suby, bitmap_data);
	glBindTexture(GL_TEXTURE_2D, 0);

	glDisable(GL_TEXTURE_GEN_T);
	glDisable(GL_TEXTURE_GEN_S);

	glActiveTextureARB(GL_TEXTURE1_ARB);
	glDisable(GL_TEXTURE_2D);

	glActiveTextureARB(GL_TEXTURE0_ARB);

	glPopMatrix();
}

void inline TwistListZ(GLuint list, float TwisterRotation)
{
	static int TwisterSteps = 240;
	glEnable(GL_SCISSOR_TEST);
	for (int i=1; i<TwisterSteps+1; i++) 
	{
		glPushMatrix();
		
		glScissor(0, int(ceil((float)HEIGHT/TwisterSteps*((TwisterSteps-i)))), WIDTH, int(floor(float(HEIGHT/TwisterSteps))));
		//			glScissor(0, int(ceil((float)480.0f/TwisterSteps*((TwisterSteps-i)))), 640, int(floor(480.0f/TwisterSteps)));
			float rotZ= float(sin(i*(0.8f/TwisterSteps)+TwisterRotation)*360.0f);
			
			glRotatef(rotZ, 0.0f, 1.0f, 0);
			glCallList(list);
		glPopMatrix();
	}
	glDisable(GL_SCISSOR_TEST);
}

void inline TwistListX(GLuint list, float TwisterRotation)
{
	static int TwisterSteps = 240;
	glEnable(GL_SCISSOR_TEST);
	for (int i=1; i<TwisterSteps+1; i++) 
	{
		glPushMatrix();
		glScissor(0, int(ceil((float)HEIGHT/TwisterSteps*((TwisterSteps-i)))), WIDTH, int(floor(float(HEIGHT/TwisterSteps))));
//			glScissor(0, int(ceil((float)480.0f/TwisterSteps*((TwisterSteps-i)))), 640, int(floor(480.0f/TwisterSteps)));
			float rotX= float(cos(i*(0.25f/TwisterSteps)+TwisterRotation)*360.0f);
			
			glRotatef(rotX, 1, 0.0f, 0.0f);
			glCallList(list);
		glPopMatrix();
	}
	glDisable(GL_SCISSOR_TEST);
}

void TwistFrame(float c, float rot)
{
	SetupFog(0.0f, 5.0f, 0.025f);
	
	glPushMatrix();
		gluLookAt(19*sin(c/2), 19*sin(c), 19*cos(c/2), 5*sin(c/4+0.2), 10*sin((c)+0.2), 5*cos(c/2+0.2), 0, 1, 0);
		PutBox(0,0,0, 20, 20, 20, 1, 1, twist_kasse_texture->texture_id);
		//glCallList(TwistBox);
		TwistListX(TwistBox, rot);
	glPopMatrix();

	glDisable(GL_FOG);
}


void TwistFrame2(float d, float c, float x, float z)
{
	glPushMatrix();
		gluLookAt(19*sin(d/2), 10*sin(d), z*cos(d/2), x, 0, 5*cos(d/2+0.2), 0, 1, 0);
		TwistListZ(TwistBox2, c);
	glPopMatrix();
	/*
	glLoadIdentity();
	//SetupFog(0.0f, 5.0f, 0.06f);
	
	glPushMatrix();
		//gluLookAt(0, 0, -10, 0, 0, 0, 0, 1, 0);
		glTranslatef(0,0,-10);
		TwistList(TwistBox, c, 0, 1/2, 0);
		//TwistList(TwistBox2, c/10.0f, 0,1,0);
		//glPushMatrix();
		//glRotatef(360.0f*sin(c), 0.0f, 1.0f, 0.0f);
		//PutBox(0,  0,  0, 
//			   2,  10,  2, 
//			   20, 1, twist_texture2->texture_id);
//		glPopMatrix();
	glPopMatrix();

	//glDisable(GL_FOG);
	*/
}


void TunnelFrame(float c)
{
	SetupFog(0.0f, 500.0f, 0.01f);


	float rad = float(75.0f*sin(c)+80.0f);

	glPushMatrix();
		gluLookAt(10*sin(c), 10*cos(c), 800*cos(c/2), 
			      10*sin(c+0.2), 10*cos(c+0.2), 800*cos((c/2)+0.2), 
				  0, 1, 0);
		glCallList(Tunnel);
	glPopMatrix();

	glDisable(GL_FOG);
}
	
void AlterFOV(float fov)
{
	glMatrixMode(GL_PROJECTION);							
	glLoadIdentity();										
	gluPerspective(fov,(float)(640/480),0.1f,10000.0f);
	
	glMatrixMode(GL_MODELVIEW);								
															
	
	glLoadIdentity();										
}

void SphereStorm(float c, float z)
{
	DistortSphereKaren(0.5f, 0.3f, 0.2f, 0.2f, c);
	
	glPushMatrix();
		AlterFOV(z*10);
		gluLookAt(10*sin(c), 10*cos(c), z, 
			      0,0,0, 
				  0, 1, 0);

		float rot = float(360.0f*sin(c/2));
		glPushMatrix();
			
			glRotatef(rot, 0, 0, 1);

			glBindTexture(GL_TEXTURE_2D, spheres_texture1->texture_id);
			PutSphere(0,7,0, 5, 50, 1, 1);
			
			glBindTexture(GL_TEXTURE_2D, spheres_texture2->texture_id);
			PutSphere(0,-7,0, 5, 50, 1, 1);
			
			glBindTexture(GL_TEXTURE_2D, spheres_texture3->texture_id);
			PutSphere(7,0,0, 5, 50, 1, 1);

			glBindTexture(GL_TEXTURE_2D, spheres_texture4->texture_id);
			PutSphere(-7,0,0, 5, 50, 1, 1);

			glBindTexture(GL_TEXTURE_2D, noise[0]->texture_id);
			DistortSphereDisable();
			PutSphere(0,0,0, 50, 50, 1, 1);

			glBindTexture(GL_TEXTURE_2D, 0);
				
			glPopMatrix();

	
	glPopMatrix();
	
	glPushMatrix();
		for (int i=0; i<6; i++)
		{
			float ok = (TWOPI/6.0*i);
			sphere_flare->SetPosition(sin(c*3+ok), cos(c*3+ok), -(20.0f-z)/3.0f);
			sphere_flare->PaintTransparent();
		}

	glPopMatrix();

	AlterFOV(45);

	glBindTexture(GL_TEXTURE_2D, 0);
}


void KasseFrame(float c, float d)
{
	glPushMatrix();
		gluLookAt(20*sin(d), 20*cos(d), 20, 
			      2,0,0, 
				  0, 1, 0);

		glBindTexture(GL_TEXTURE_2D, kasse_texture->texture_id);
		PutSphere(0,0,0, 5, 50, 2, 2);

		glDepthMask(GL_NEVER);
		glEnable(GL_BLEND);
			glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
			PutBox(0,0,0,
				   5.1f,5.1f,5.1f,
				   1.0f,1.0f,
				   kasse_trans_texture->texture_id);
		glDisable(GL_BLEND);
		glDepthMask(GL_TRUE); 

		DistortSphere(0.5f, 0.3f, 0.2f, 0.7f, c);

	
	glBindTexture(GL_TEXTURE_2D, 0);
	glPopMatrix();
}


void PartEt(unsigned long TIME)
{
	hearing[TIME&1]->Paint();			
}

void PartTo(unsigned long TIME)
{
	if (TIME>TIMER(0,3,650) && TIME<TIMER(0,5,448))
	{
		if (TIME<TIMER(0,3,900)) code[0]->Paint();
		if (TIME>TIMER(0,3,900) && TIME<TIMER(0,4,462)) code[1]->Paint();
		if (TIME>TIMER(0,4,462) && TIME<TIMER(0,4,795)) code[2]->Paint();
		if (TIME>TIMER(0,4,795) && TIME<TIMER(0,5,017)) code[3]->Paint();
		if (TIME>TIMER(0,5,017)) code[TIME&3]->Paint();
	}
	
	if (TIME>TIMER(0,5,448) && TIME<TIMER(0,7,237))
	{
		if (TIME<TIMER(0,5,685)) gfx[0]->Paint();
		if (TIME>TIMER(0,5,685) && TIME<TIMER(0,6,240)) gfx[1]->Paint();
		if (TIME>TIMER(0,6,240) && TIME<TIMER(0,6,573)) gfx[2]->Paint();
		if (TIME>TIMER(0,6,573) && TIME<TIMER(0,6,795)) gfx[3]->Paint();
		if (TIME>TIMER(0,6,795)) gfx[TIME&3]->Paint();
	}
	
	if (TIME>TIMER(0,7,237) && TIME<TIMER(0,8,996))
	{
		if (TIME<TIMER(0,7,461)) msx[0]->Paint();
		if (TIME>TIMER(0,7,461) && TIME<TIMER(0,8,017)) msx[1]->Paint();
		if (TIME>TIMER(0,8,017) && TIME<TIMER(0,8,348)) msx[2]->Paint();
		if (TIME>TIMER(0,8,348) && TIME<TIMER(0,8,571)) msx[3]->Paint();
		if (TIME>TIMER(0,8,571)) msx[TIME&3]->Paint();
	}
	
	if (TIME>TIMER(0,8,996) && TIME<TIMER(0,10,651))
	{
		if (TIME<TIMER(0,9,239)) pause[0]->Paint();
		else if (TIME<TIMER(0,10,125)) pause[1]->Paint();
		
		if (TIME>TIMER(0,9,791) && TIME<TIMER(0,10,125)) 
		{
			glEnable(GL_SCISSOR_TEST);
			glScissor(0, 0, 640, 240);
			glClear(GL_COLOR_BUFFER_BIT);
			glDisable(GL_SCISSOR_TEST);
		}
	}
	
}

void PartTre(unsigned long TIME)
{
	float c = float(TIME/1500.0f);
	
	static float zz = 19;
	if (TIME>TIMER(0,17,777) && TIME<TIMER(0,19,340)) TwistFrame2(c,c,(TIMER(0,19,340)-TIME)/500.0,19);
	if (TIME>TIMER(0,19,340) && TIME<TIMER(0,19,597)) TwistFrame2(c,c,0,10);
	if (TIME>TIMER(0,19,597) && TIME<TIMER(0,21,119)) TwistFrame2(c,c,0,39);
	if (TIME>TIMER(0,21,119) && TIME<TIMER(0,21,375)) TwistFrame2(c,c,0,25);
	if (TIME>TIMER(0,21,375) && TIME<TIMER(0,22,771)) TwistFrame2(c,c,0,69);
	if (TIME>TIMER(0,22,771) && TIME<TIMER(0,23,148)) TwistFrame2(c,c,0,10);
	if (TIME>TIMER(0,23,148)) TwistFrame2(c,c,0,19);
	
	
	if (TIME>TIMER(0,10,654))
	{
		static int img = 0;
		
		if (TIME>TIMER(0,11,126)) img=1;
		if (TIME>TIMER(0,12,013)) img=2;
		if (TIME>TIMER(0,12,900)) img=3;
		if (TIME>TIMER(0,13,788)) img=4;
		if (TIME>TIMER(0,14,214)) img=5;
		if (TIME>TIMER(0,14,678)) img=6;
		if (TIME>TIMER(0,15,343)) img=7;
		if (TIME>TIMER(0,16,452)) img=8;
		if (TIME>TIMER(0,17,341)) img=9;
		DisplayAlphaImage(maskine[img]);
	}
	
	
	
	
	if (TIME>TIMER(0,25,334) && TIME<TIMER(0,30,664))
	{
		int ok = 0;
		int lastok;
		float mmscale=0;
		
		//if (TIME>TIMER(0,25,334) && TIME<TIMER(0,25,997)) DisplayAlphaImage(gasmasker[0]);
		if (TIME>TIMER(0,25,997) && TIME<TIMER(0,27,111)) {ok=1;}
		if (TIME>TIMER(0,27,111) && TIME<TIMER(0,27,777)) {ok=2;}
		if (TIME>TIMER(0,27,777) && TIME<TIMER(0,28,440)) {ok=3;}
		if (TIME>TIMER(0,28,440) && TIME<TIMER(0,28,889)) {ok=4;}
		if (TIME>TIMER(0,28,889) && TIME<TIMER(0,29,549)) {ok=5;}
		if (TIME>TIMER(0,29,549) && TIME<TIMER(0,30,664)) {ok=6;}
		
		DisplayAlphaImage(gasmasker[ok]);
		
		lastok = ok;
	}	
}


void PartFire(unsigned long TIME)
{
	float c = float(TIME/1500.0f);
	static int add = 0;
	
	if (TIME>TIMER(0,32,331)) add=500;
	if (TIME>TIMER(0,32,542)) add=1000;
	if (TIME>TIMER(0,32,775)) add=1500;
	if (TIME>TIMER(0,33,210)) add=3000;
	if (TIME>TIMER(0,33,768)) add=1500;
	if (TIME>TIMER(0,34,106)) add=3500;
	if (TIME>TIMER(0,34,425)) add=2500; // mogens siger den er forkert
	if (TIME>TIMER(0,33,447)) add=1000;
	if (TIME>TIMER(0,34,599)) add=2500;
	if (TIME>TIMER(0,34,892)) add=1500;
	if (TIME>TIMER(0,34,994)) add=4000;
	if (TIME>TIMER(0,35,104)) add=4500;
	if (TIME>TIMER(0,35,544)) add=5000;
	if (TIME>TIMER(0,35,882)) add=3500;
	if (TIME>TIMER(0,36,95))  add=6000;
	if (TIME>TIMER(0,36,318)) add=5500;
	if (TIME>TIMER(0,36,763)) add=7000;
	if (TIME>TIMER(0,36,993)) add=6000;
	if (TIME>TIMER(0,37,320)) add=7500;
	if (TIME>TIMER(0,37,874)) add=8000;
	if (TIME>TIMER(0,38,103)) add=9500;
	if (TIME>TIMER(0,38,431)) add=8000;
	if (TIME>TIMER(0,38,532)) add=7000;
	if (TIME>TIMER(0,38,620)) add=4000;
	if (TIME>TIMER(0,39,104)) add=9000;
	if (TIME>TIMER(0,39,425)) add=8000;
	if (TIME>TIMER(0,39,674)) add=9500;
	if (TIME>TIMER(0,39,879)) add=6000;
	if (TIME>TIMER(0,40,325)) add=8000;
	if (TIME>TIMER(0,40,511)) add=9000;
	if (TIME>TIMER(0,41,193)) add=10000;
	if (TIME>TIMER(0,41,413)) add=10500;

	if (TIME>TIMER(0,41,561)) add=9000; // rasmus og mogens tror den er forkert

	if (TIME>TIMER(0,42,648)) add=11000;
	if (TIME>TIMER(0,42,979)) add=11500;
	if (TIME>TIMER(0,43,191)) add=11000;
	if (TIME>TIMER(0,43,421)) add=12500;
	if (TIME>TIMER(0,43,865)) add=11500;
	if (TIME>TIMER(0,44,80))  add=10500;
	if (TIME>TIMER(0,44,432)) add=13000;
	if (TIME>TIMER(0,44,740)) add=11000;
	if (TIME>TIMER(0,44,979)) add=12500;
	if (TIME>TIMER(0,45,198)) add=14000;
/*	

	// super rigtige timings af mogens 
	if (TIME>32012) add=500;
	if (TIME>32212) add=1500;
	if (TIME>32362) add=2500;
	if (TIME>32512) add=3500;
	if (TIME>32762) add=2500;
	if (TIME>33195) add=1500;

	if (TIME>33512) add=4500;
	if (TIME>33642) add=1500;
	if (TIME>33862) add=5500;
	if (TIME>35066) add=2500;
	if (TIME>34235) add=4500;
	if (TIME>34429) add=1500;
	if (TIME>34629) add=2500;
	if (TIME>34930) add=1500;
	if (TIME>36063) add=2500;
	if (TIME>35213) add=6500;
	if (TIME>35596) add=5500;
	if (TIME>35666) add=6000;
	if (TIME>35866) add=4500;
	if (TIME>36146) add=5500;
	if (TIME>36396) add=5000;
	if (TIME>36800) add=4500;
	if (TIME>36530) add=5000;
	if (TIME>37364) add=4000;
	if (TIME>37630) add=1000;
	if (TIME>37770) add=5000;
	if (TIME>37747) add=4700;
	if (TIME>38170) add=3000;
	if (TIME>38514) add=2000;
	if (TIME>38670) add=1600;
	if (TIME>38814) add=2000;
	if (TIME>39166) add=2000;
	if (TIME>39364) add=4000;
	if (TIME>39514) add=1000;
	if (TIME>39754) add=3000;
	if (TIME>39964) add=4000;
	if (TIME>40364) add=2000;
	if (TIME>40748) add=3000;
	if (TIME>40925) add=3000;
	if (TIME>41165) add=2000;
	if (TIME>41311) add=3000;
	if (TIME>41398) add=3500;
	if (TIME>41732) add=4000;
	if (TIME>42732) add=4500;
	if (TIME>42932) add=5000;
	if (TIME>43055) add=5500;
	if (TIME>43299) add=6000;
	if (TIME>43499) add=6500;
	if (TIME>43983) add=7000;
	if (TIME>44172) add=7500;
	if (TIME>44332) add=8000;
	if (TIME>44533) add=8500;
	if (TIME>44783) add=9000;
	if (TIME>44999) add=9500;
	if (TIME>46099) add=10000;
	if (TIME>45266) add=10500;
	if (TIME>45750) add=11000;
	if (TIME>45783) add=12000;
	if (TIME>45904) add=12500;
*/
	long akne = (TIME-32000+add)*2;
	
	while (akne<0) akne=32000-akne;
	
	while (akne>32000) akne-=32000;

	SpikeFrame(akne, float((TIME+add)/1500.0f));
}


void PartFem(unsigned long TIME)
{
	int ok = 0;
	if (TIME>TIMER(0,46,651) && TIME<TIMER(0,47,537)) ok=1;
	if (TIME>TIMER(0,47,537) && TIME<TIMER(0,48,426)) ok=2;
	if (TIME>TIMER(0,48,426) && TIME<TIMER(0,49,308)) ok=3;
	if (TIME>TIMER(0,49,308) && TIME<TIMER(0,50,198)) ok=4;	
	if (TIME>TIMER(0,50,198) && TIME<TIMER(0,51,87)) ok=5;
	if (TIME>TIMER(0,51,87)) ok=6;
	soya[ok]->Paint();
}

void PartSeks(unsigned long TIME)
{
	float c = float(TIME/1500.0f);
	static float d;
	if (TIME>TIMER(0,53,607) && TIME<TIMER(0,53,867)) d=2000;
	if (TIME>TIMER(0,53,867) && TIME<TIMER(0,54,87)) d=1000;
	if (TIME>TIMER(0,54,87) && TIME<TIMER(0,54,525)) d=2000;
	if (TIME>TIMER(0,54,525) && TIME<TIMER(0,54,737)) d=3000;
	if (TIME>TIMER(0,54,737) && TIME<TIMER(0,55,83)) d=4000;
	if (TIME>TIMER(0,55,83) && TIME<TIMER(0,55,308)) d=5000;
	if (TIME>TIMER(0,55,308) && TIME<TIMER(0,55,407)) d=1000;
	if (TIME>TIMER(0,55,407) && TIME<TIMER(0,55,648)) d=3000;
	if (TIME>TIMER(0,55,648) && TIME<TIMER(0,55,858)) d=4000;
	if (TIME>TIMER(0,55,858) && TIME<TIMER(0,56,178)) d=5000;
	if (TIME>TIMER(0,56,178) && TIME<TIMER(0,56,295)) d=6000;
	if (TIME>TIMER(0,56,295) && TIME<TIMER(0,56,397)) d=4000;
	if (TIME>TIMER(0,56,397) && TIME<TIMER(0,56,825)) d=6000;
	if (TIME>TIMER(0,56,825) && TIME<TIMER(0,57,164)) d=7000;
	if (TIME>TIMER(0,57,164) && TIME<TIMER(0,57,428)) d=8000;
	if (TIME>TIMER(0,57,428) && TIME<TIMER(0,57,576)) d=4000;
	if (TIME>TIMER(0,57,576) && TIME<TIMER(0,57,749)) d=9000;
	if (TIME>TIMER(0,57,749) && TIME<TIMER(0,57,912)) d=10000;
	if (TIME>TIMER(0,57,912) && TIME<TIMER(0,58,101)) d=7000;
	if (TIME>TIMER(0,58,101) && TIME<TIMER(0,58,206)) d=11000;

		
	if (TIME>TIMER(0,58,206) && TIME<TIMER(0,58,356)) d=10000;		
	if (TIME>TIMER(0,58,356) && TIME<TIMER(0,58,111)) d=12000;		
	if (TIME>TIMER(0,58,111) && TIME<TIMER(0,58,648)) d=9000;		
		;
	if (TIME>TIMER(0,58,648) && TIME<TIMER(0,58,862)) d=12000;
	if (TIME>TIMER(0,58,862) && TIME<TIMER(0,58,298)) d=13000;
	if (TIME>TIMER(0,58,298) && TIME<TIMER(0,58,818)) d=11000;

	if (TIME>TIMER(0,58,818) && TIME<TIMER(0,58,969)) d=12310; // den tror vi er naesten ok, men alligevel forkert og det er gorms skyld det hele

	if (TIME>TIMER(0,58,969) && TIME<TIMER(0,59,193)) d=14000;
	if (TIME>TIMER(0,59,193) && TIME<TIMER(0,59,208)) d=12000;
	if (TIME>TIMER(0,59,208) && TIME<TIMER(0,59,411)) d=11000;
	if (TIME>TIMER(0,59,411) && TIME<TIMER(1,0,82)) d=13000;
	if (TIME>TIMER(1,0,82) && TIME<TIMER(1,0,133)) d=10000;
	if (TIME>TIMER(1,0,133) && TIME<TIMER(1,0,193)) d=11000;
	if (TIME>TIMER(1,0,193) && TIME<TIMER(1,0,297)) d=6000;
	if (TIME>TIMER(1,0,297) && TIME<TIMER(1,0,410)) d=15000;
	if (TIME>TIMER(1,0,410) && TIME<TIMER(1,0,639)) d=16000;
	if (TIME>TIMER(1,0,639) && TIME<TIMER(1,1,197)) d=17000;
	if (TIME>TIMER(1,1,197) && TIME<TIMER(1,1,638)) d=18000;
	if (TIME>TIMER(1,1,638) && TIME<TIMER(1,2,188)) d=19000;
	if (TIME>TIMER(1,2,188) && TIME<TIMER(1,2,414)) d=18000;
	if (TIME>TIMER(1,2,414) && TIME<TIMER(1,2,965)) d=14000;
	if (TIME>TIMER(1,2,965) && TIME<TIMER(1,3,957)) d=10000;
	if (TIME>TIMER(1,3,957) && TIME<TIMER(1,4,529)) d=7000;
	if (TIME>TIMER(1,4,529) && TIME<TIMER(1,4,749)) d=3000;
	if (TIME>TIMER(1,4,749) && TIME<TIMER(1,5,728)) d=1000;
	if (TIME>TIMER(1,5,728)) d=500;
	
	TwistFrame(d+c,c);
	
	if (TIME>TIMER(0,53,743) && TIME<TIMER(0,54,637)) DisplayAlphaImage(ost[0]);
	if (TIME>TIMER(0,55,519) && TIME<TIMER(0,55,858)) DisplayAlphaImage(ost[1]);
	if (TIME>TIMER(0,57,304) && TIME<TIMER(0,58,192)) DisplayAlphaImage(ost[2]);
	if (TIME>TIMER(0,59,84) && TIME<TIMER(1,00,860)) DisplayAlphaImage(ost[3]);
	if (TIME>TIMER(1,01,748) && TIME<TIMER(1,02,637)) DisplayAlphaImage(ost[4]);
	if (TIME>TIMER(1,02,965) && TIME<TIMER(1,04,413)) DisplayAlphaImage(ost[5]);
	if (TIME>TIMER(1,05,300) && TIME<TIMER(1,06,191)) DisplayAlphaImage(ost[6]);
}

void PartSyv(unsigned long TIME)
{
	float c = float(TIME/1500.0f);
	static float d=1500;
	if (TIME>TIMER(1,11,80) && TIME<TIMER(1,11,300)) d=1000;

	if (TIME>TIMER(1,12,174) && TIME<TIMER(1,13,056)) d=1300;
	if (TIME>TIMER(1,14,611) && TIME<TIMER(1,14,841)) d=1300;
	if (TIME>TIMER(1,14,927) && TIME<TIMER(1,16,407)) d=1300;
	if (TIME>TIMER(1,17,512) && TIME<TIMER(1,18,175)) d=1300;
	if (TIME>TIMER(1,19,286) && TIME<TIMER(1,19,947)) d=1300;
	KasseFrame(c,float(TIME/d));
	DisplayAlphaImage(bloboverlay);
}

void PartOtte(unsigned long TIME)
{
	float c = float(TIME/1500.0f);
	float d=c;
	float z=5;
	char ok=0;
	
	
	
	if (TIME>TIMER(1,22,635) && TIME<TIMER(1,22,735)) z=2;
	if (TIME>TIMER(1,24,397) && TIME<TIMER(1,24,497)) z=2;
	if (TIME>TIMER(1,25,276) && TIME<TIMER(1,25,376)) z=2;
	if (TIME>TIMER(1,26,246) && TIME<TIMER(1,26,346)) z=2;
	if (TIME>TIMER(1,27,944) && TIME<TIMER(1,28,44)) z=2;
	

	if (z>5.0f) z-=0.5;
	if (z<5.0f) z+=0.5;
	
	SphereStorm(d,z);
	DisplayAlphaImage(sphereoverlay);
}

void PartNi(unsigned long TIME)
{
	float c = float(TIME/1500.0f);
	
	float d;
	
	
	if (TIME>TIMER(1,32,750)) d=500;
	if (TIME>TIMER(1,33,722)) d=1500;
	if (TIME>TIMER(1,34,558)) d=500;
	if (TIME>TIMER(1,37,273)) d=2000;
	if (TIME>TIMER(1,38,145)) d=3500;
	if (TIME>TIMER(1,39,919)) d=1500;
	if (TIME>TIMER(1,40,862)) d=3000;
	if (TIME>TIMER(1,41,677)) d=4500;
	if (TIME>TIMER(1,42,047)) d=3000;
	if (TIME>TIMER(1,43,007)) d=5000;
	if (TIME>TIMER(1,44,377)) d=3500;
	if (TIME>TIMER(1,45,228)) d=2500;
	if (TIME>TIMER(1,47,043)) d=6500;
	if (TIME>TIMER(1,48,821)) d=2000;
	if (TIME>TIMER(1,49,151)) d=5500;
	
	if (TIME>TIMER(1,47,710))
	{
		unsigned int long l = TIMER(1,47,710)-TIME;
		float fov = (1-float(l/1000.0))*45.0;
		AlterFOV(fov);
	}
	
	TunnelFrame(float((TIME+d)/1500.0f));	
	
	if (TIME>TIMER(1,47,710))
	{
		AlterFOV(45.0);
	}
}

void PartTi(unsigned long TIME)
{
	float c = float(TIME/1500.0f);
	static float d = 20;
	
	
	if (TIME>TIMER(1,57,236)  && TIME<TIMER(2,1,0)) 
	{
		d-=0.5;
	}
	if (d<1) d=1;
	
	
	BitmapFrame(c*d);
	
	if (TIME>TIMER(1,57,702))
	{
		static int p=0;
		
		if (TIME>TIMER(1,59,478)) p=1;
		if (TIME>TIMER(2,1,253)) p=2;
		if (TIME>TIMER(2,3,31)) p=3;
		if (TIME>TIMER(2,4,804)) p=4;
		if (TIME>TIMER(2,5,693)) p=5;
		if (TIME>TIMER(2,6,583)) p=6;
		if (TIME>TIMER(2,7,472)) p=7;
		if (TIME>TIMER(2,8,357)) p=8;
		if (TIME>TIMER(2,9,244)) p=9;
		DisplayAlphaImage(slut[p]);
	}
}

// -- MAIN --

void Frame(unsigned long TIME)
{
	TIME+=TIMEROFF;

	float c = float(TIME/1500.0f);

	glLoadIdentity();
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);

	if (TIME>0 && TIME<TIMER(0,3,560)) PartEt(TIME);
	if (TIME>TIMER(0,3,650) && TIME<TIMER(0,10,651)) PartTo(TIME);
	if (TIME>TIMER(0,10,125) && TIME<TIMER(0,32,0)) PartTre(TIME);
	if (TIME>32000 && TIME<46000) PartFire(TIME);
	if (TIME>TIMER(0,46,157) && TIME<TIMER(0,51,503)) PartFem(TIME);
	if (TIME>TIMER(0,53,312) && TIME<TIMER(1,06,518)) PartSeks(TIME);
	if (TIME>TIMER(1,07,522) && TIME<TIMER(1,21,511)) PartSyv(TIME);
	if (TIME>TIMER(1,21,679) && TIME<TIMER(1,28,393)) PartOtte(TIME);
	if (TIME>TIMER(1,28,840) && TIME<TIMER(1,49,587)) PartNi(TIME);
	if (TIME>TIMER(1,50,150) && TIME<TIMER(2,11,27)) PartTi(TIME);
	noise[TIME&1]->PaintTransparent();
}
