#include <stdio.h>
#include <fstream.h>
#include <stdlib.h>
#include <math.h>

int main(int argc, char *argv[])
{
  FILE *in;
  FILE *out;
  FILE *out2;

  int bitmap1boffset = 8000;
  int bitmap2boffset = 7808;

  int totalemptychars =0;
  int counter0  =0;
  int counter1a =0;
  int counter1b =0;
  int counter2a =0;
  int counter2b =0;
  int bitmap0 [8192];
  int bitmap1 [8192];
  int bitmap2 [8192];
  int emptystart [65536];
  int emptylength [65536];
  int emptybitmap [65536];

  int count;

  // -------------------------------------------
  // clear result dataset and fill bitmaps     -
  // with $ff value to avoid wrong detections! -
  // -------------------------------------------

  count=0;
  while(count<8192){
      bitmap0[count]=255;
      bitmap1[count]=255;
      bitmap2[count]=255;
      count++;
  }//while
  count=0;
  while(count<65536){
      emptystart[count]=0;
      emptylength[count]=0;
      emptybitmap[count]=0;
      count++;
  }//while
  // open raw data

  // ask if we want to enter single bitmaps, or a compiled bitmap file!

  bool goodanswer=false;
  int askuser;
  while (!goodanswer){
      cout << "Do you want to read seperate bitmap files (1) or a compiled bitmap (2)? : ";
      cin >> askuser;
      if ((askuser>=1) && (askuser<=2)){goodanswer=true;}
  }//while goodanswer

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

  if (askuser==1){
      in = fopen ("./BMP0.PRG","rb");    // open bitmap
      //throw first 2 bytes out of the window
      fgetc(in);
      fgetc(in);
      while(feof(in)==0) {
          bitmap0[counter0]=fgetc(in);
          counter0++;
      }
      counter0--;                          // don't count eof-char
      fclose(in);                          // close stream

      cout << counter0 << " bytes read in BMP0.PRG" << endl;

      // ---------------
      // open raw data -
      // ---------------

      in = fopen ("./BMP1A.PRG","rb");    // open bitmap
      //throw first 2 bytes out of the window
      fgetc(in);
      fgetc(in);
      while(feof(in)==0) {
          bitmap1[counter1a]=fgetc(in);
          counter1a++;
      }
      counter1a--;                  // don't count eof-char
      fclose(in);                   // close stream

      cout << counter1a << " bytes read in BMP1A.PRG" << endl;

      in = fopen ("./BMP1B.PRG","rb");    // open bitmap
      //throw first 2 bytes out of the window
      fgetc(in);
      fgetc(in);
      while(feof(in)==0) {
          bitmap1[counter1b+bitmap1boffset]=fgetc(in);
          counter1b++;
      }
      counter1b--;                           // don't count eof-char
      fclose(in);                          // close stream

      cout << counter1b << " bytes read in BMP1B.PRG" << endl;

      // ---------------
      // open raw data -
      // ---------------

      in = fopen ("./BMP2A.PRG","rb");    // open bitmap
      //throw first 2 bytes out of the window
      fgetc(in);
      fgetc(in);
      while(feof(in)==0) {
          bitmap2[counter2a]=fgetc(in);
          counter2a++;
      }
      counter2a--;                         // don't count eof-char
      fclose(in);                          // close stream

      cout << counter2a << " bytes read in BMP2A.PRG" << endl;

      // ---------------
      // open raw data -
      // ---------------

      in = fopen ("./BMP2B.PRG","rb");    // open bitmap
      //throw first 2 bytes out of the window
      fgetc(in);
      fgetc(in);
      while(feof(in)==0) {
          bitmap2[counter2b+bitmap2boffset]=fgetc(in);
          counter2b++;
      }
      counter2b--;                         // don't count eof-char
      fclose(in);                          // close stream

      cout << counter2b << " bytes read in BMP2B.PRG" << endl;
  }// if askuser, case single bitmaps!

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

  if (askuser==2){
      int bitmap0start;
      int bitmap1start;
      int bitmap2start;
      int totalmemory[65536];

      in = fopen ("./bitmap.prg","rb");    // open compiled bitmap
      //throw first 2 bytes out of the window
      fgetc(in);
      fgetc(in);
      while(feof(in)==0) {
          totalmemory[counter0]=fgetc(in);
          counter0++;
      }
      counter0--;                          // don't count eof-char
      fclose(in);                          // close stream

      cout << counter0 << " bytes read in bitmap.prg" << endl;

      bitmap0start=totalmemory[0]+totalmemory[1]*256;
      bitmap1start=totalmemory[2]+totalmemory[3]*256;
      bitmap2start=totalmemory[4]+totalmemory[5]*256;

      cout << "start of bitmap 0: " << bitmap0start << endl << "start of bitmap 1: " << bitmap1start << endl << "start of bitmap 2: " << bitmap2start << endl;

      if ( ((bitmap0start/8192)*8192) != bitmap0start ) {cout << "ERROR in bitmap 0!!" << endl;}
      if ( ((bitmap1start/8192)*8192) != bitmap1start ) {cout << "ERROR in bitmap 1!!" << endl;}
      if ( ((bitmap2start/8192)*8192) != bitmap2start ) {cout << "ERROR in bitmap 2!!" << endl;}

      // copy bitmaps

      for (count=0; count<8192; count++){
          bitmap0[count]=totalmemory[count+bitmap0start];
          bitmap1[count]=totalmemory[count+bitmap1start];
          bitmap2[count]=totalmemory[count+bitmap2start];
      }//for count

  }//if askuser

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

  // ------------------------------
  // find empty chars in bitmap 0 -
  // ------------------------------

  int counter=0;    // counter to run through the bitmap data
  int emptychars=0; // # of empty chars in this chain so far
  int emptycount=0; // # of empty chars found in total
  int startofchain; // note where the chain started
  bool empty;
  int countera=0;

  for (counter=0;counter<(8192/8);counter++){
    //check if current char is empty or not.
    empty=true;
    for (countera=0;countera<8;countera++){
      if(bitmap0[countera+counter*8]!=0){
        empty=false;
        countera=8;
      }//if
    }//for
    if (empty) {
      if (emptychars==0){startofchain=counter;} // note start of this chain if this is the first empty char
      emptychars++;
      totalemptychars++;
    }
    else {
      if (emptychars!=0){
        // we found the end of a chain, so we write it all down
        emptystart[emptycount]=startofchain;
        emptybitmap[emptycount]=1;
        emptylength[emptycount]=emptychars;
        emptychars=0;
        emptycount++;
      }//if
    }//else
  }//for
  if (emptychars!=0){
    // we found the end of a chain, so we write it all down
    emptystart[emptycount]=startofchain;
    emptybitmap[emptycount]=1;
    emptylength[emptycount]=emptychars;
    emptychars=0;
    emptycount++;
  }//if

  // find empty chars in bitmap 1

  emptychars=0;

  for (counter=0;counter<(8192/8);counter++){
    //check if current char is empty or not.
    empty=true;
    for (countera=0;countera<8;countera++){
      if(bitmap1[countera+counter*8]!=0){
        empty=false;
        countera=8;
      }//if
    }//for
    if (empty) {
      if (emptychars==0){startofchain=counter;} // note start of this chain if this is the first empty char
      emptychars++;
      totalemptychars++;
    }
    else {
      if (emptychars!=0){
        // we found the end of a chain, so we write it all down
        emptystart[emptycount]=startofchain;
        emptybitmap[emptycount]=2;
        emptylength[emptycount]=emptychars;
        emptychars=0;
        emptycount++;
      }//if
    }//else
  }//for
  if (emptychars!=0){
    // we found the end of a chain, so we write it all down
    emptystart[emptycount]=startofchain;
    emptybitmap[emptycount]=2;
    emptylength[emptycount]=emptychars;
    emptychars=0;
    emptycount++;
  }//if

  // ------------------------------
  // find empty chars in bitmap 2 -
  // ------------------------------

  emptychars=0;

  for (counter=0;counter<(8192/8);counter++){
    //check if current char is empty or not.
    empty=true;
    for (countera=0;countera<8;countera++){
      if(bitmap2[countera+counter*8]!=0){
        empty=false;
        countera=8;
      }//if
    }//for
    if (empty) {
      if (emptychars==0){startofchain=counter;} // note start of this chain if this is the first empty char
      emptychars++;
      totalemptychars++;
    }
    else {
      if (emptychars!=0){
        // we found the end of a chain, so we write it all down
        emptystart[emptycount]=startofchain;
        emptybitmap[emptycount]=3;
        emptylength[emptycount]=emptychars;
        emptychars=0;
        emptycount++;
      }//if
    }//else
  }//for
  if (emptychars!=0){
    // we found the end of a chain, so we write it all down
    emptystart[emptycount]=startofchain;
    emptybitmap[emptycount]=3;
    emptylength[emptycount]=emptychars;
    emptychars=0;
    emptycount++;
  }//if


  cout << endl << emptycount << " empty chains found in total.." << endl;
  cout << endl << totalemptychars << " empty chars found in total.." << endl;

  // ---------------------------------
  // sort empty chains for length..  -
  // ---------------------------------

  bool swapped=true;
  int temp1;
  int temp2;
  int temp3;

  cout << "sorting data..." << endl;
  while (swapped){
    swapped=false;
    for (counter=0;counter<(emptycount-1);counter++){
      if (emptylength[counter]<emptylength[counter+1]){
        temp1=emptylength[counter];
        temp2=emptystart[counter];
        temp3=emptybitmap[counter];
        emptylength[counter]=emptylength[counter+1];
        emptybitmap[counter]=emptybitmap[counter+1];
        emptystart[counter]=emptystart[counter+1];
        emptylength[counter+1]=temp1;
        emptystart[counter+1]=temp2;
        emptybitmap[counter+1]=temp3;
        swapped=true;
      }//if
    }//for
  }//while

  // save data
  // make output file
  out=fopen("./empty.txt","w");
  out2=fopen("./empty2.txt","w");

  fputs(";empty sites in bitmaps\n\n",out);
  int number=0;
  for (counter=0;counter<emptycount;counter++){
    fprintf(out,"empty%ibytes%i = bitmap%i+%i\n",emptylength[counter]*8,number,emptybitmap[counter]-1,emptystart[counter]*8);
    if(emptylength[counter]!=emptylength[counter+1]){
      fprintf(out2,"%i,%i\n",emptylength[counter],number+1);
      number=0;
    }//if
    else {number++;}
  }//for
  fclose(out);
  fclose(out2);

  return 0;
}
