

void
smoothMoreInner( char* src, int width )
{
	__asm {
		mov esi, src
		mov ebx, width
		push ebp
		mov ecx, ebx
		sub ecx, 2
		mov ebp, ebx
		neg ebp
		xor edx, edx
	L1:	xor eax, eax
		mov al, [esi]
		shl eax, 2
		mov dl, byte ptr [esi + 1]
		add eax, edx
		mov dl, byte ptr [esi - 1]
		add eax, edx
		mov dl, byte ptr [esi + ebx]
		add eax, edx
		mov dl, byte ptr [esi + ebp]
		add eax, edx
		shr eax, 3
		mov [esi], al
		inc esi
		dec ecx
		jnz L1
		pop ebp
	}
}


void
smoothMore( int width, int height, char* buffer )
{
  char*  bptr;
  
  bptr = buffer + width + 1;

  for ( int i = 1; i < (height - 1); i++ ) {
    smoothMoreInner( bptr, width );
    bptr += width;
  }
}


void
smoothInner( char* src, int width )
{
	__asm {
		mov esi, src
		mov ebx, width
		mov ecx, ebx
		sub ecx, 2
		xor edx, edx
	L1:	xor eax, eax
		mov al, [esi]
		shl eax, 1
		mov dl, byte ptr [esi + 1]
		add eax, edx
		mov dl, byte ptr [esi - 1]
		add eax, edx
		shr eax, 2
		mov [esi], al
		inc esi
		dec ecx
		jnz L1
	}
}


void
smooth( int width, int height, char* buffer )
{
  char*  bptr;
  
  bptr = buffer + width + 1;

  for ( int i = 1; i < (height - 1); i++ ) {
    smoothInner( bptr, width );
    bptr += width;
  }
}





void
edgeInner( char* src, char* dst, int width )
{
	__asm {
		mov esi, src
		mov edi, dst
		mov ebx, width

		push ebp
		mov ecx, ebx
		sub ecx, 2
		mov ebp, ebx
		neg ebp
	L1:	xor eax, eax
		xor edx, edx
		mov dl, [esi + 1]
		add eax, edx
		mov dl, [esi - 1]
		add eax, edx
		mov dl, [esi + ebx]
		add eax, edx
		mov dl, [esi + ebp]
		add eax, edx
		shr eax, 2
		mov dl, [esi]
		sub edx, eax
		and edx, 0feh
		shr edx, 2
		mov [edi], dl
		inc esi
		inc edi
		dec ecx
		jnz L1
		pop ebp
	}
}




void
edge( int width, int height, char* buffer, char* out )
{
  char*  bptr;
  char*  optr;
  
  bptr = buffer + width + 1;
  optr = out + width + 1;

  for ( int i = 1; i < (height - 1); i++ ) {
    edgeInner( bptr, optr, width );
    bptr += width;
    optr += width;
  }
}
