/***********************************************
 *   misc tables & useful FPU constants        *
 * Skal 98                                     *
 ***********************************************/

#include "main3d.h"

/******************************************************************/

EXTERN PIXEL AA_Table[256];

extern double pow( double, double );
EXTERN void Init_Anti_Alias_Table( INT C0, INT C1, FLT Gamma )
{
   INT i;
   AA_Table[0] = C0;
   if ( Gamma!=1.0f) for( i=1; i<256; ++i )
   {
      FLT x = 1.0f*i/256.0f;
      x = (FLT)pow( x, Gamma );
      AA_Table[i] = (PIXEL)floor( C0 + x*(FLT)(C1-C0) );
   }
   else for( i=1; i<256; ++i )
   {
      FLT x = 1.0f*i/256.0f;
      AA_Table[i] = (PIXEL)floor( C0 + x*(FLT)(C1-C0) );
   }
}

/******************************************************************/

EXTERN FLT _Div_Tab_64_[64] = 
{
   0.0/64.0,  1.0/64.0,  2.0/64.0,  3.0/64.0, 
   4.0/64.0,  5.0/64.0,  6.0/64.0,  7.0/64.0,
   8.0/64.0,  9.0/64.0,  10.0/64.0, 11.0/64.0,
   12.0/64.0, 13.0/64.0, 14.0/64.0, 15.0/64.0,

   16.0/64.0, 17.0/64.0, 18.0/64.0, 19.0/64.0,
   20.0/64.0, 21.0/64.0, 22.0/64.0, 23.0/64.0,
   24.0/64.0, 25.0/64.0, 26.0/64.0, 27.0/64.0,
   28.0/64.0, 29.0/64.0, 30.0/64.0, 31.0/64.0,

   32.0/64.0, 33.0/64.0, 34.0/64.0, 35.0/64.0,
   36.0/64.0, 37.0/64.0, 38.0/64.0, 39.0/64.0,
   40.0/64.0, 41.0/64.0, 42.0/64.0, 43.0/64.0,
   44.0/64.0, 45.0/64.0, 46.0/64.0, 47.0/64.0,

   48.0/64.0, 49.0/64.0, 50.0/64.0, 51.0/64.0,
   52.0/64.0, 53.0/64.0, 54.0/64.0, 55.0/64.0,
   56.0/64.0, 57.0/64.0, 58.0/64.0, 59.0/64.0,
   60.0/64.0, 61.0/64.0, 62.0/64.0, 63.0/64.0,
};

EXTERN FLT _Div_Tab_32_[32] = 
{
   0.0,       1.0/32.0, 2.0/32.0, 3.0/32.0, 
   4.0/32.0,  5.0/32.0, 6.0/32.0, 7.0/32.0,
   8.0/32.0,  9.0/32.0, 10.0/32.0, 11.0/32.0,
   12.0/32.0, 13.0/32.0, 14.0/32.0, 15.0/32.0,
   16.0/32.0, 17.0/32.0, 18.0/32.0, 19.0/32.0,
   20.0/32.0, 21.0/32.0, 22.0/32.0, 23.0/32.0,
   24.0/32.0, 25.0/32.0, 26.0/32.0, 27.0/32.0,
   28.0/32.0, 29.0/32.0, 30.0/32.0, 31.0/32.0
};

EXTERN FLT _Div_Tab_16_[16] = 
{
   0.0,       1.0/16.0, 2.0/16.0, 3.0/16.0, 
   4.0/16.0,  5.0/16.0, 6.0/16.0, 7.0/16.0,
   8.0/16.0,  9.0/16.0, 10.0/16.0, 11.0/16.0,
   12.0/16.0, 13.0/16.0, 14.0/16.0, 15.0/16.0
};

EXTERN FLT _Div_Tab_8_[8] = 
{
   0.0,     1.0/8.0, 2.0/8.0, 3.0/8.0,
   4.0/8.0, 5.0/8.0, 6.0/8.0, 7.0/8.0
};

EXTERN FLT _Div_Tab_4_[4] = 
{
   0.0, 1.0/4.0, 2.0/4.0, 3.0/4.0
};

EXTERN FLT _Div_Tab_2_[2] = 
{
   0.0, 1.0/2.0 
};

EXTERN FLT _Div_Tab_1_[64] = 
{
   0.0,      1.0/1.0,  1.0/2.0,  1.0/3.0, 
   1.0/4.0,  1.0/5.0,  1.0/6.0,  1.0/7.0,
   1.0/8.0,  1.0/9.0,  1.0/10.0, 1.0/11.0,
   1.0/12.0, 1.0/13.0, 1.0/14.0, 1.0/15.0,

   1.0/16.0, 1.0/17.0, 1.0/18.0, 1.0/19.0,
   1.0/20.0, 1.0/21.0, 1.0/22.0, 1.0/23.0,
   1.0/24.0, 1.0/25.0, 1.0/26.0, 1.0/27.0,
   1.0/28.0, 1.0/29.0, 1.0/30.0, 1.0/31.0,

   1.0/32.0, 1.0/33.0, 1.0/34.0, 1.0/35.0,
   1.0/36.0, 1.0/37.0, 1.0/38.0, 1.0/39.0,
   1.0/40.0, 1.0/41.0, 1.0/42.0, 1.0/43.0,
   1.0/44.0, 1.0/45.0, 1.0/46.0, 1.0/47.0,

   1.0/48.0, 1.0/49.0, 1.0/50.0, 1.0/51.0,
   1.0/52.0, 1.0/53.0, 1.0/54.0, 1.0/55.0,
   1.0/56.0, 1.0/57.0, 1.0/58.0, 1.0/59.0,
   1.0/60.0, 1.0/61.0, 1.0/62.0, 1.0/63.0
};

EXTERN FLT _CST_1_  = 1.0;
EXTERN FLT _CST_2_  = 2.0;
EXTERN FLT _CST_4_  = 4.0;
EXTERN FLT _CST_8_  = 8.0;
EXTERN FLT _CST_16_ = 16.0;
EXTERN FLT _CST_32_ = 32.0;
EXTERN FLT _CST_64_ = 64.0;
EXTERN FLT _CST_65536_ = 65536.0;

/******************************************************************/
