#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <malloc.h>
#include "M3D_math.h"
#include "M3D_geom.h"
#include "M3D_poly.h"
#include "M3D_cam.h"
#include "M3D_3DSl.h"
#include "M3D_lite.h"
#include "M3D_mat.h"


void	copy_screen (char *buffer, char *dest);
#pragma aux copy_screen =		\
	"mov	ecx,15360"			\
	"cld"						\
	"rep	movsd"				\
	parm [esi] [edi]			\
	modify exact [ecx esi edi];

void	clear_screen (char *buffer, long lenght);
#pragma aux clear_screen =	\
	"xor	eax, eax"			\
	"cld"						\
	"rep	stosd"				\
	parm [edi] [ecx]			\
	modify exact [eax ecx edi];
	
void	mode_13 (void);
#pragma aux mode_13 =			\
	"xor	eax, eax"			\
	"mov	al, 0x13"			\
	"int	0x10"				\
	modify [eax];

void	mode_3 (void);
#pragma aux mode_3 =			\
	"xor	eax, eax"			\
	"mov	al, 0x3"			\
	"int	0x10"				\
	modify [eax];


void	print_matrix (M3Dmatrix mat)
{

	printf("|%4.4f %4.4f %4.4f %4.4f|\n", mat[0][0], mat[0][1], mat[0][2], mat[0][3]);
	printf("|%4.4f %4.4f %4.4f %4.4f|\n", mat[1][0], mat[1][1], mat[1][2], mat[1][3]);
	printf("|%4.4f %4.4f %4.4f %4.4f|\n", mat[2][0], mat[2][1], mat[2][2], mat[2][3]);
	printf("|%4.4f %4.4f %4.4f %4.4f|\n", mat[3][0], mat[3][1], mat[3][2], mat[3][3]);

}


void set_palette(void)
{
	int		i;

	
	for (i = 0; i < 64; i ++) {

		outp (0x3C8, (char)(i));
		outp (0x3C9, (char)i);
		outp (0x3C9, 0);
		outp (0x3C9, 0);
		
		outp (0x3C8, (char)(i + 64));
		outp (0x3C9, 0);
		outp (0x3C9, (char)i);
		outp (0x3C9, 0);
		
		outp (0x3C8, (char)(i + 128));
		outp (0x3C9, 0);
		outp (0x3C9, 0);
		outp (0x3C9, (char)i);
		
	}
}


main (int argc, char *argv[])
{

	FILE	*fp;
	char		c;
	int			i;
	float		cx, cy, cz, cbank;
	M3Dmatrix	mat1, mat2, mat3;
	char		*screen_buffer;
	M3Dcamera	cam1;
	unsigned long	t_in, t_out, *timer, frame_count;
	

	printf("\n\n\n3DStudio kieputin, jonka ompi tehnyt memon/iNSiDE\n\n");

	if (argc < 7) {
		printf("How do we use this:\n");
		printf("  test <file name> camera_x camera_y camera_z camera_bank depth_cueuing_plane\n");
		printf("  example:\n");
		printf("    test koe01.3ds 0 0 -250 0 250\n\n");
		exit(1);
	}

	if (init_geom() == 0) {
		printf("Yes, error.\n");
		exit(1);
	}	
	
	if (init_lights() == 0) {
		printf("Yes, error.\n");
		exit(1);
	}	
	
	if (init_materials() == 0) {
		printf("Yes, error.\n");
		exit(1);
	}
	
	if (init_math() == 0) {
		printf("Yes, error.\n");
		exit(1);
	}
	
	
	if((screen_buffer = (char *)malloc(320 * 200 * 4)) == NULL) {
		printf("Out of memory! (screen_buffer)");
		exit(1);
	}

	cx = (float)atof(argv[2]);
	cy = (float)atof(argv[3]);
	cz = (float)atof(argv[4]);
	cbank = (float)atof(argv[5]);
	
	M3Ddepth_scale = (float)atof(argv[6]);

	/* test if this phucking camera works */
	cam1.position.x = cx;
	cam1.position.y = cy;
	cam1.position.z = cz;
		
	cam1.target.x = 0.0;
	cam1.target.y = 0.0;
	cam1.target.z = 0.0;
	
	cam1.bank = cbank;
	cam1.FOV = 60;
	cam1.eye_distance = 200;

	/* set viewing parameters */
	cam1.viewport.buffer = screen_buffer;
	cam1.viewport.buffer_width = 320;
	cam1.viewport.buffer_height = 200;
	cam1.viewport.view_center_x = 160;
	cam1.viewport.view_center_y = 100;

	cam1.viewport.clip_top = 20;
	cam1.viewport.clip_bot = 180;
	cam1.viewport.clip_left = 20;
	cam1.viewport.clip_right = 300;


	num_vertices = 0;
	num_polys = 0;
	num_objects = 0;
	visible_polys = 0;

	if (load_3ds(argv[1]) == -1) {
		printf("File not found \"%s\"\n",argv[1]);
		exit(1);
	}
	
	for (i = 0; i < num_objects; i ++) {
		calc_vertex_normals(&object_list[i]);
	}

	for (i = 0; i < num_polys; i ++)
		poly_list[i].type = GOURAUD;

	printf("num_vertices: %d\n", num_vertices);
	printf("   num_polys: %d\n", num_polys);
	printf(" num_objects: %d\n", num_objects);
	printf("  num_lights: %d\n", num_lights);

	for (i = 0; i < num_materials; i ++) {
		printf("'%s'\n",material_list[i].name);
		printf("ambient:  R:%03d G:%03d B:%03d\n", material_list[i].ambient.R, material_list[i].ambient.G, material_list[i].ambient.B);
		printf("diffuse:  R:%03d G:%03d B:%03d\n", material_list[i].diffuse.R, material_list[i].diffuse.G, material_list[i].diffuse.B);
		printf("specular:  R:%03d G:%03d B:%03d\n", material_list[i].specular.R, material_list[i].specular.G, material_list[i].specular.B);
		printf("\n");
	}
	
	printf("\n\n--press-any-key-->\n");
	fflush(stdout);
	getch();

	init_matrix(mat1);
	init_matrix(mat2);
	init_matrix(mat3);

	mode_13();
	set_palette();


	for (i = 0; i < num_objects; i ++) {
		rotate_object(&object_list[i], 900, 0, 0);
	}
	for (i = 0; i < num_lights; i ++) {
		rotate_light(&light_list[i], 900, 0, 0);
	}

	memset(screen_buffer, 0, (320 * 200 * 4));

	frame_count = 0;
	timer = (unsigned long *) 0x046c;
	t_in = *timer;

jatkuu:
	while(!kbhit()){

		clear_screen(screen_buffer, 64000);


		for (i = 0; i < num_objects; i ++) {
/*			pivot_rotate_object(&object_list[i], 0, 20, 0, 0, 0, 0);*/
			rotate_object(&object_list[i], 12, 14, 5);
		}

		for (i = 0; i < num_lights; i ++) {
			rotate_light(&light_list[i], 0, -10, 0);
		}

		setup_camera(&cam1);

		render(&cam1);

/*		outp (0x3C8, 0);
		outp (0x3C9, 32);
		outp (0x3C9, 0);
		outp (0x3C9, 0);*/

		showbuffer(screen_buffer);

		while ( (inp (0x3DA) & 8) == 8 );
		while ( (inp (0x3DA) & 8) == 0 );
		
		frame_count ++;
	}
	
	t_out = *timer;

	c = getch();	
	switch (c) {
		case ' ':
			getch();
			goto jatkuu;
			break;
		case 'c':
			if ((fp = fopen("cap.raw","wb")) == NULL) {
				printf("ei aukee captuuri file!\n");
				break;
			}
		
			for (i = 0; i < 64000; i ++) {
				fputc(screen_buffer[i*4], fp);
				fputc(screen_buffer[i*4 + 1], fp);
				fputc(screen_buffer[i*4 + 2], fp);
			}
		
			fclose(fp);	
			break;
	}
	
/*	getch();*/

	mode_3();
	
	printf("%ffps\n", ((float)(frame_count * 18.2) / (t_out - t_in)) );
	
	close_geom();
	close_lights();
	close_materials();
	free(screen_buffer);
}
