/*

	Polygon drawing library

	M3D_poly.c
*/

#include "M3D_poly.h"


char	*M3Dout_buffer;
int		M3Dbuffer_width, M3Dbuffer_height;
float	M3Dview_center_x, M3Dview_center_y;
int		M3Dclip_top, M3Dclip_bot;
int		M3Dclip_left, M3Dclip_right;

int		_clip_top = 1;
int		_clip_bot = 198;
int		_clip_left = 1;
int		_clip_right = 318;


/* Current viewport is set here. */

void	set_out_viewport (M3Dviewport *view)
{
	M3Dout_buffer = view->buffer;

	M3Dbuffer_width = view->buffer_width;
	M3Dbuffer_height = view->buffer_height;
	M3Dview_center_x = view->view_center_x;
	M3Dview_center_y = view->view_center_y;
	
	M3Dclip_top = view->clip_top;
	M3Dclip_bot = view->clip_bot;
	M3Dclip_left = view->clip_left;
	M3Dclip_right = view->clip_right;
}

/*
void	draw_gouraud_poly (M3Dpoly_point *points)
{
	M3Dpoly_point *p1 = points;
	M3Dpoly_point *p2 = points + 1;
	M3Dpoly_point *p3 = points + 2;


	drawrgbgouraudpoly(M3Dout_buffer, 320,
		p1->x, p1->y, p2->x, p2->y, p3->x, p3->y,
		p1->color.R, p1->color.G, p1->color.B,
		p2->color.R, p2->color.G, p2->color.B,
		p3->color.R, p3->color.G, p3->color.B);

}
*/

void	draw_gouraud_poly (M3Dpoly_point *points)
{
	draw_gouraud_polyR(points);
	draw_gouraud_polyG(points);
	draw_gouraud_polyB(points);
}


/* 64bit divide 32bit routines */

int		shl10idiv(int x, int y);
#pragma aux shl10idiv =		\
	"mov	edx, eax"		\
	"shl	eax, 10	"		\
	"sar	edx, 22	"		\
	"idiv	ebx		"		\
	parm [eax] [ebx]		\
	modify exact [eax ebx]	\
	value [eax];

int		shl16idiv(int x, int y);
#pragma aux shl16idiv =		\
	"mov	edx, eax"		\
	"shl	eax, 16	"		\
	"sar	edx, 16	"		\
	"idiv	ebx		"		\
	parm [eax] [ebx]		\
	modify exact [eax ebx]	\
	value [eax];


/* Some global variables */

static	M3Dpoly_point *left[3];
static	M3Dpoly_point *right[3];
static	int	left_section, right_section;
static	int	left_section_height, right_section_height;
static	int	left_c;
static	int	left_x, delta_left_x, right_x, delta_right_x, delta_left_c;
static	int	vertclip, horzclip;


/*

	draw solid color polygon.

*/

static	int		solid_right (void)
{
	M3Dpoly_point	*p1 = right[right_section];
	M3Dpoly_point	*p2 = right[right_section - 1];
	int		height, oheight;
	int		y1, y2;

	if (!vertclip) {
		height = p2->y - p1->y;
		if (height == 0)
			return 0;
		delta_right_x = ((p2->x - p1->x) << 16) / height;
		right_x = p1->x << 16;
	}
	else {
		y1 = p1->y;
		y2 = p2->y;
		oheight = height = y2 - y1;

		if ((y2 -= _clip_bot) > 0)
			height -= y2;				/* skip pixels at end. */
		y2 = 0;
		
		if (y1 < _clip_top)
			y2 = _clip_top - y1;
		
		if ((height -= y2) <= 0)		/* skip pixels at start. */
			return height;
		/* y2 = pixels skipped at start */
		
		delta_right_x = ((p2->x - p1->x) << 16) / oheight;
		right_x = (p1->x << 16) + delta_right_x * y2;
			
	}
	
	right_section_height = height;
	return height;
}

static	int		solid_left (void)
{
	M3Dpoly_point	*p1 = left[left_section];
	M3Dpoly_point	*p2 = left[left_section - 1];
	int		height, oheight;
	int		y1, y2;

	if (!vertclip) {
		height = p2->y - p1->y;
		if (height == 0)
			return 0;
		delta_left_x = ((p2->x - p1->x) << 16) / height;
		left_x = p1->x << 16;
	}
	else {
		y1 = p1->y;
		y2 = p2->y;
		oheight = height = y2 - y1;

		if ((y2 -= _clip_bot) > 0)
			height -= y2;				/* skip pixels at end. */
		y2 = 0;
		
		if (y1 < _clip_top)
			y2 = _clip_top - y1;
		
		if ((height -= y2) <= 0)		/* skip pixels at start. */
			return height;
		/* y2 = pixels skipped at start */
		
		delta_left_x = ((p2->x - p1->x) << 16) / oheight;
		left_x = (p1->x << 16) + delta_left_x * y2;
			
	}
	
	left_section_height = height;
	return height;
}

void	solid_inner (char *destptr, int width, char color);
#pragma aux solid_inner =	\
	"cld"					\
	"rep	stosb"			\
	parm [edi] [ecx] [eax]	\
	modify [edi ecx eax];

void	draw_solid_poly (M3Dpoly_point *points)
{
	M3Dpoly_point *p1 = points;
	M3Dpoly_point *p2 = points + 1;
	M3Dpoly_point *p3 = points + 2;
	M3Dpoly_point *tmp;
	
	int		top, owidth, width, height, temp, longest;
	int		x1, x2;
	char	*destptr, *dest, color;


	color = p1->color.R;
	
	/* sort vertices. p1 = top, p3 = bot */
	if (p1->y > p2->y) {
		tmp = p1;
		p1 = p2;
		p2 = tmp;
	}
	if (p1->y > p3->y) {
		tmp = p1;
		p1 = p3;
		p3 = tmp;
	}
	if (p2->y > p3->y) {
		tmp = p2;
		p2 = p3;
		p3 = tmp;
	}

	/* check if vertical clipping needed. */
	if ((top = p1->y) < _clip_top) {
		top = _clip_top;
		vertclip = 1;
	}
	else if (p3->y > _clip_bot)
		vertclip = 1;
	else
		vertclip = 0;
	
	/* calculate height of the poly and longest scan line. */
	height = p3->y - p1->y;
	
	if (height == 0)	/* nothing to draw? */
		return;

	temp = ((p2->y - p1->y) << 16) / height;
	longest = temp * (p3->x - p1->x) + ((p1->x - p2->x) << 16);
	
	if (longest == 0)	/* nothing to draw? */
		return;

	if (longest < 0) {
		right[0] = p3;
		right[1] = p2;
		right[2] = p1;
		right_section = 2;
		left[0] = p3;
		left[1] = p1;
		left_section = 1;

		if (solid_left() <= 0)
			return;

		if (solid_right() <= 0) {
			right_section --;
			if (solid_right() <= 0)
				return;
		}
		
		if (longest > -0x1000)
			longest = -0x1000;
	}
	else {
		left[0] = p3;
		left[1] = p2;
		left[2] = p1;
		left_section = 2;
		right[0] = p3;
		right[1] = p1;
		right_section = 1;
		
		if (solid_right() <= 0)
			return;


		if (solid_left() <= 0) {
			left_section --;
			if (solid_left() <= 0)
				return;
		}
		
		if (longest < 0x1000)
			longest = 0x1000;
	}

	/* check if horizontal clipping needed. */
	if (p1->x > _clip_right ||
		p1->x < _clip_left  ||
		p2->x > _clip_right ||
		p2->x < _clip_left  ||
		p3->x > _clip_right ||
		p3->x < _clip_left)
		horzclip = 1;
	else
		horzclip = 0;
	
	destptr = M3Dout_buffer + (top * M3Dbuffer_width);
	
	for (;;) {

		if (!horzclip) {	
			x1 = left_x >> 16;
			width = (right_x >> 16) - x1;
		}
		else {
			x1 = left_x >> 16;
			x2 = right_x >> 16;
			owidth = width = x2 - x1;
			
			if ((x2 -= _clip_right) > 0)
				width -= x2;				/* skip pixels at end. */
			x2 = 0;
			
			if (x1 < _clip_left) {
				x2 = _clip_left - x1;
				x1 = _clip_left;
			}
			
			if ((width -= x2) <= 0)			/* skip pixels at start. */
				goto linedone;
			/* x2 = pixels skipped at start */
		}

		if (width > 0)
		{
			dest = destptr + x1;
			solid_inner (dest, width, color);
		}
		
	linedone:
	
		destptr += M3Dbuffer_width;
		
		if ((-- left_section_height) <= 0) {
			if ((-- left_section) <= 0)
				return;
			if (solid_left() <= 0)
				return;
		}
		else {
			left_x += delta_left_x;
		}
		
		if ((-- right_section_height) <= 0) {
			if ((-- right_section) <= 0)	
				return;
			if (solid_right() <= 0)
				return;
		}
		else {
			right_x += delta_right_x;
		}
	
	}
	
}




/*

	draw Gouraud shaded color polygon.

*/

static	int		gouraud_rightR (void)
{
	M3Dpoly_point	*p1 = right[right_section];
	M3Dpoly_point	*p2 = right[right_section - 1];
	int		height;

	height = p2->y - p1->y;
	if (height == 0)
		return 0;
	delta_right_x = ((p2->x - p1->x) << 16) / height;
	right_x = p1->x << 16;
	
	right_section_height = height;
	return height;
}

static	int		gouraud_leftR (void)
{
	M3Dpoly_point	*p1 = left[left_section];
	M3Dpoly_point	*p2 = left[left_section - 1];
	int		height;

	height = p2->y - p1->y;
	if (height == 0)
		return 0;
	delta_left_x = ((p2->x - p1->x) << 16) / height;
	left_x = p1->x << 16;

	delta_left_c = ((p2->color.R - p1->color.R) << 16) / height;
	left_c = p1->color.R << 16;
	
	left_section_height = height;
	return height;
}

/* Old gouraud inner loop (16:16 fixed point is converted to 16:8 fixed point)
void	gouraud_inner (char *destptr, int width, int color, int dcdx);
pragma aux gouraud_inner =			\
	"shr	ebx, 8"					\
	"shr	eax, 8"					\
"l:	 mov	[edi], ah"				\
	"add	eax, ebx"				\
	"inc	edi"					\
	"dec	ecx"					\
	"jnz	l"						\
	parm [edi] [ecx] [eax] [ebx]	\
	modify [edi ecx eax edx ebx];
*/

void	gouraud_inner (char *destptr, int width, int color, int dcdx);
#pragma aux gouraud_inner =			\
	"shr	ebx, 8"					\
	"shr	eax, 8"					\
"l:	 mov	[edi], ah"				\
	"add	eax, ebx"				\
	"add	edi, 4"					\
	"dec	ecx"					\
	"jnz	l"						\
	parm [edi] [ecx] [eax] [ebx]	\
	modify [edi ecx eax edx ebx];


/*
void	gouraud_inner (char *destptr, int width, int color, int dcdx);
pragma aux gouraud_inner =			\
"l:	 mov	edx, eax"				\
	"shr	edx, 16"				\
	"mov	[edi], dl"				\
	"add	eax, ebx"				\
	"inc	edi"					\
	"dec	ecx"					\
	"jnz	l"						\
	parm [edi] [ecx] [eax] [ebx]	\
	modify [edi ecx eax edx ebx];
*/


void	draw_gouraud_polyR (M3Dpoly_point *points)
{
	M3Dpoly_point *p1 = points;
	M3Dpoly_point *p2 = points + 1;
	M3Dpoly_point *p3 = points + 2;
	M3Dpoly_point *tmp;
	
	int		width, height, temp, longest;
	int		dcdx;
	int		x1, c;
	char	*destptr, *dest;


	/* sort vertices. p1 = top, p3 = bot */
	if (p1->y > p2->y) {
		tmp = p1;
		p1 = p2;
		p2 = tmp;
	}
	if (p1->y > p3->y) {
		tmp = p1;
		p1 = p3;
		p3 = tmp;
	}
	if (p2->y > p3->y) {
		tmp = p2;
		p2 = p3;
		p3 = tmp;
	}

	/* calculate height of the poly and longest scan line. */
	height = p3->y - p1->y;
	
	if (height == 0)	/* nothing to draw? */
		return;

	temp = ((p2->y - p1->y) << 16) / height;
	longest = temp * (p3->x - p1->x) + ((p1->x - p2->x) << 16);
	
	if (longest == 0)	/* nothing to draw? */
		return;

	if (longest < 0) {
		right[0] = p3;
		right[1] = p2;
		right[2] = p1;
		right_section = 2;
		left[0] = p3;
		left[1] = p1;
		left_section = 1;

		if (gouraud_leftR() <= 0)
			return;

		if (gouraud_rightR() <= 0) {
			right_section --;
			if (gouraud_rightR() <= 0)
				return;
		}
		
		if (longest > -0x1000)
			longest = -0x1000;
	}
	else {
		left[0] = p3;
		left[1] = p2;
		left[2] = p1;
		left_section = 2;
		right[0] = p3;
		right[1] = p1;
		right_section = 1;
		
		if (gouraud_rightR() <= 0)
			return;


		if (gouraud_leftR() <= 0) {
			left_section --;
			if (gouraud_leftR() <= 0)
				return;
		}
		
		if (longest < 0x1000)
			longest = 0x1000;
	}

	dcdx = shl16idiv((temp * (p3->color.R - p1->color.R) + ((p1->color.R - p2->color.R) << 16)), longest);
	
	destptr = M3Dout_buffer + ((p1->y * M3Dbuffer_width) * 4);
	
	for (;;) {

		x1 = left_x >> 16;
		width = (right_x >> 16) - x1;
		c = left_c;

		if (width > 0)
		{
			dest = destptr + (x1 * 4);
			gouraud_inner (dest, width, c, dcdx);
		}
	
		destptr += M3Dbuffer_width * 4;
		
		if ((-- left_section_height) <= 0) {
			if ((-- left_section) <= 0)
				return;
			if (gouraud_leftR() <= 0)
				return;
		}
		else {
			left_x += delta_left_x;
			left_c += delta_left_c;
		}
		
		if ((-- right_section_height) <= 0) {
			if ((-- right_section) <= 0)	
				return;
			if (gouraud_rightR() <= 0)
				return;
		}
		else {
			right_x += delta_right_x;
		}
	
	}
	
}

static	int		gouraud_rightG (void)
{
	M3Dpoly_point	*p1 = right[right_section];
	M3Dpoly_point	*p2 = right[right_section - 1];
	int		height;

	height = p2->y - p1->y;
	if (height == 0)
		return 0;
	delta_right_x = ((p2->x - p1->x) << 16) / height;
	right_x = p1->x << 16;
	
	right_section_height = height;
	return height;
}

static	int		gouraud_leftG (void)
{
	M3Dpoly_point	*p1 = left[left_section];
	M3Dpoly_point	*p2 = left[left_section - 1];
	int		height;

	height = p2->y - p1->y;
	if (height == 0)
		return 0;
	delta_left_x = ((p2->x - p1->x) << 16) / height;
	left_x = p1->x << 16;

	delta_left_c = ((p2->color.G - p1->color.G) << 16) / height;
	left_c = p1->color.G << 16;
	
	left_section_height = height;
	return height;
}


void	draw_gouraud_polyG (M3Dpoly_point *points)
{
	M3Dpoly_point *p1 = points;
	M3Dpoly_point *p2 = points + 1;
	M3Dpoly_point *p3 = points + 2;
	M3Dpoly_point *tmp;
	
	int		width, height, temp, longest;
	int		dcdx;
	int		x1, c;
	char	*destptr, *dest;


	/* sort vertices. p1 = top, p3 = bot */
	if (p1->y > p2->y) {
		tmp = p1;
		p1 = p2;
		p2 = tmp;
	}
	if (p1->y > p3->y) {
		tmp = p1;
		p1 = p3;
		p3 = tmp;
	}
	if (p2->y > p3->y) {
		tmp = p2;
		p2 = p3;
		p3 = tmp;
	}

	/* calculate height of the poly and longest scan line. */
	height = p3->y - p1->y;
	
	if (height == 0)	/* nothing to draw? */
		return;

	temp = ((p2->y - p1->y) << 16) / height;
	longest = temp * (p3->x - p1->x) + ((p1->x - p2->x) << 16);
	
	if (longest == 0)	/* nothing to draw? */
		return;

	if (longest < 0) {
		right[0] = p3;
		right[1] = p2;
		right[2] = p1;
		right_section = 2;
		left[0] = p3;
		left[1] = p1;
		left_section = 1;

		if (gouraud_leftG() <= 0)
			return;

		if (gouraud_rightG() <= 0) {
			right_section --;
			if (gouraud_rightG() <= 0)
				return;
		}
		
		if (longest > -0x1000)
			longest = -0x1000;
	}
	else {
		left[0] = p3;
		left[1] = p2;
		left[2] = p1;
		left_section = 2;
		right[0] = p3;
		right[1] = p1;
		right_section = 1;
		
		if (gouraud_rightG() <= 0)
			return;


		if (gouraud_leftG() <= 0) {
			left_section --;
			if (gouraud_leftG() <= 0)
				return;
		}
		
		if (longest < 0x1000)
			longest = 0x1000;
	}

	dcdx = shl16idiv((temp * (p3->color.G - p1->color.G) + ((p1->color.G - p2->color.G) << 16)), longest);
	
	destptr = M3Dout_buffer + ((p1->y * M3Dbuffer_width) * 4) + 1;
	
	for (;;) {

		x1 = left_x >> 16;
		width = (right_x >> 16) - x1;
		c = left_c;

		if (width > 0)
		{
			dest = destptr + (x1 * 4);
			gouraud_inner (dest, width, c, dcdx);
		}
	
		destptr += M3Dbuffer_width * 4;
		
		if ((-- left_section_height) <= 0) {
			if ((-- left_section) <= 0)
				return;
			if (gouraud_leftG() <= 0)
				return;
		}
		else {
			left_x += delta_left_x;
			left_c += delta_left_c;
		}
		
		if ((-- right_section_height) <= 0) {
			if ((-- right_section) <= 0)	
				return;
			if (gouraud_rightG() <= 0)
				return;
		}
		else {
			right_x += delta_right_x;
		}
	
	}
	
}


static	int		gouraud_rightB (void)
{
	M3Dpoly_point	*p1 = right[right_section];
	M3Dpoly_point	*p2 = right[right_section - 1];
	int		height;

	height = p2->y - p1->y;
	if (height == 0)
		return 0;
	delta_right_x = ((p2->x - p1->x) << 16) / height;
	right_x = p1->x << 16;
	
	right_section_height = height;
	return height;
}

static	int		gouraud_leftB (void)
{
	M3Dpoly_point	*p1 = left[left_section];
	M3Dpoly_point	*p2 = left[left_section - 1];
	int		height;

	height = p2->y - p1->y;
	if (height == 0)
		return 0;
	delta_left_x = ((p2->x - p1->x) << 16) / height;
	left_x = p1->x << 16;

	delta_left_c = ((p2->color.B - p1->color.B) << 16) / height;
	left_c = p1->color.B << 16;
	
	left_section_height = height;
	return height;
}


void	draw_gouraud_polyB (M3Dpoly_point *points)
{
	M3Dpoly_point *p1 = points;
	M3Dpoly_point *p2 = points + 1;
	M3Dpoly_point *p3 = points + 2;
	M3Dpoly_point *tmp;
	
	int		width, height, temp, longest;
	int		dcdx;
	int		x1, c;
	char	*destptr, *dest;


	/* sort vertices. p1 = top, p3 = bot */
	if (p1->y > p2->y) {
		tmp = p1;
		p1 = p2;
		p2 = tmp;
	}
	if (p1->y > p3->y) {
		tmp = p1;
		p1 = p3;
		p3 = tmp;
	}
	if (p2->y > p3->y) {
		tmp = p2;
		p2 = p3;
		p3 = tmp;
	}

	/* calculate height of the poly and longest scan line. */
	height = p3->y - p1->y;
	
	if (height == 0)	/* nothing to draw? */
		return;

	temp = ((p2->y - p1->y) << 16) / height;
	longest = temp * (p3->x - p1->x) + ((p1->x - p2->x) << 16);
	
	if (longest == 0)	/* nothing to draw? */
		return;

	if (longest < 0) {
		right[0] = p3;
		right[1] = p2;
		right[2] = p1;
		right_section = 2;
		left[0] = p3;
		left[1] = p1;
		left_section = 1;

		if (gouraud_leftB() <= 0)
			return;

		if (gouraud_rightB() <= 0) {
			right_section --;
			if (gouraud_rightB() <= 0)
				return;
		}
		
		if (longest > -0x1000)
			longest = -0x1000;
	}
	else {
		left[0] = p3;
		left[1] = p2;
		left[2] = p1;
		left_section = 2;
		right[0] = p3;
		right[1] = p1;
		right_section = 1;
		
		if (gouraud_rightB() <= 0)
			return;


		if (gouraud_leftB() <= 0) {
			left_section --;
			if (gouraud_leftB() <= 0)
				return;
		}
		
		if (longest < 0x1000)
			longest = 0x1000;
	}

	dcdx = shl16idiv((temp * (p3->color.B - p1->color.B) + ((p1->color.B - p2->color.B) << 16)), longest);
	
	destptr = M3Dout_buffer + ((p1->y * M3Dbuffer_width) * 4) + 2;
	
	for (;;) {

		x1 = left_x >> 16;
		width = (right_x >> 16) - x1;
		c = left_c;

		if (width > 0)
		{
			dest = destptr + (x1 * 4);
			gouraud_inner (dest, width, c, dcdx);
		}
	
		destptr += M3Dbuffer_width * 4;
		
		if ((-- left_section_height) <= 0) {
			if ((-- left_section) <= 0)
				return;
			if (gouraud_leftB() <= 0)
				return;
		}
		else {
			left_x += delta_left_x;
			left_c += delta_left_c;
		}
		
		if ((-- right_section_height) <= 0) {
			if ((-- right_section) <= 0)	
				return;
			if (gouraud_rightB() <= 0)
				return;
		}
		else {
			right_x += delta_right_x;
		}
	
	}
	
}
