/*

	Material library
	
	M3D_mat.c

*/

#include "M3D_mat.h"

int				num_materials;
M3Dmaterial		*material_list;

int		init_materials (void)
{
	if ((material_list = (M3Dmaterial *)malloc(MATERIAL_BUF * sizeof(M3Dmaterial))) == NULL) {
		printf("Out of Memory! (materials)\n");
		return (0);
	}
	
	num_materials = 0;

	/* make default material. */
	add_material();

	material_list[num_materials - 1].ambient.R = 10;
	material_list[num_materials - 1].ambient.G = 10;
	material_list[num_materials - 1].ambient.B = 10;
	
	material_list[num_materials - 1].diffuse.R = 140;
	material_list[num_materials - 1].diffuse.G = 140;
	material_list[num_materials - 1].diffuse.B = 140;
	
	material_list[num_materials - 1].specular.R = 250;
	material_list[num_materials - 1].specular.G = 250;
	material_list[num_materials - 1].specular.B = 250;
	
	strcpy(material_list[num_materials - 1].name, "M3D Default");
	
	return (1);
}


void	close_materials (void)
{
	free(material_list);
}


void	add_material (void)
{
	num_materials ++;
}