/*

	Light library
	
	M3D_lite.h

*/

#ifndef _M3D_LITE_H
#define _M3D_LITE_H

#include <conio.h>
#include <graph.h>
#include <malloc.h>
#include "m3d_geom.h"
#include "m3d_math.h"
#include "m3d_colr.h"
#include "m3d_mat.h"

#ifndef	TRUE
	#define	TRUE	0
#endif
#ifndef	FALSE
	#define	FALSE	-1
#endif

#define		OMNILIGHT	0
#define		SPOTLIGHT	1

#define		LIGHT_BUF	100

typedef struct {
	M3Dvector	position;
	M3Dvector	target;
	M3Dvector	cam_position;
	M3Dvector	cam_target;
	float		falloff;
	
	M3Dcolor	color;
	
	char		type;
} M3Dlight;

extern	int			num_lights;
extern	M3Dlight	*light_list;

/* depth-cueing */
extern	float		M3Ddepth_scale;


extern	int		init_lights (void);
extern	void	close_lights (void);
extern	void	add_light (float x, float y, float z);
extern	void	rotate_light (M3Dlight *light, float x, float y, float z);
extern	void	translate_light (M3Dlight *light, float x, float y, float z);
extern	void	process_lights (void);
extern	void	draw_light (int num);
extern	void	calc_dot_n_spec (float *dot, int *idot, int *ispec);

#endif