/*

	Geometry library
	
	M3D_geom.h

*/

#ifndef _M3D_GEOM_H
#define _M3D_GEOM_H

#include <stdio.h>
#include <conio.h>
#include <malloc.h>
#include "m3d_math.h"
#include "m3d_colr.h"
#include "m3d_lite.h"
#include "m3d_poly.h"
#include "m3d_cam.h"

#ifndef	TRUE
	#define	TRUE	0
#endif
#ifndef	FALSE
	#define	FALSE	-1
#endif

#define		VERTEX_BUF	30000
#define		POLY_BUF	50000
#define		OBJECT_BUF	100

/* minimum z distance */
#define		Z_MIN		1.0

/* polygon types */
/* if you want gouraud shaded texturemapping, */
/* your poly type is GOURAUD + TEXTURE */
#define		FLAT				0
#define		GOURAUD				1
#define		PHONG				2
#define		TEXTURE				4


#define		NONE		0
#define		HIDDEN		0
#define		PROJECT		1
#define		Z_CLIP		2
#define		LIGHT		4
#define		VISIBLE		8


typedef struct {
	M3Dvector	local;
	M3Dvector	world;

	M3Dvector	lnormal;
	M3Dvector	wnormal;
	int			ncount;

	int			screen_x, screen_y;

	M3Dcolor	color;	
	
	char		status;
} M3Dvertex;


typedef struct {
	int			v1;
	int			v2;
	int			v3;
	
	M3Dvector	lnormal;
	M3Dvector	wnormal;
	
	M3Dcolor	color;
	
	char		*texture;
	
	char		type;
	char		status;
	short		material;
} M3Dtriangle;


typedef struct {
	float		depth;
	int			p_num;
} M3Dsort;


typedef struct {
	int			u[3];
	int			v[3];
} M3Dtexpoint;


typedef	struct {
	float		x, y, z;
	M3Dcolor	color;
/*	int			u, v;*/
	float		intensity;		/* this should be obsolete */
} M3Dclip_point;

#define		CHILD_BUF	100

typedef struct {
	int			vertex_base;
	int			num_vertices;
	
	int			poly_base;
	int			num_polys;
	
	M3Dvector	pivot;
	int			rotate_x;
	int			rotate_y;
	int			rotate_z;

	signed char	visible;
	
	/* objects hierarchy */
	int			num_child;
	int			child_list[CHILD_BUF];
	
	char		name[16];
} M3Dobject;


extern	M3Dvertex	*vertex_list;
extern	M3Dtriangle	*poly_list;
extern	M3Dsort		*sort_list;
extern	M3Dobject	*object_list;

extern	int		num_vertices;
extern	int		num_polys;
extern	int		num_objects;
extern	int		visible_polys;

extern	float	M3Ddistance;


extern	int		init_geom (void);
extern	void	close_geom (void);

extern	void	add_vertex (float x, float y, float z);
extern	void	add_polygon (int a, int b, int c);
extern	void	add_object (int v_base, int num_v, int p_base, int num_p);
extern	void	calc_vertex_normals (M3Dobject *obj);

extern	void	pivot_rotate_object (M3Dobject *obj, int x, int y, int z, float pivot_x, float pivot_y, float pivot_z);
extern	void	rotate_object (M3Dobject *obj, int x, int y, int z);
extern	void	translate_object (M3Dobject *obj, float x, float y, float z);
extern	void	set_pivot (M3Dobject *obj, float x, float y, float z);
extern	void	set_rotate (M3Dobject *obj, float x, float y, float z);

extern	void	transform_world (M3Dmatrix mat);
extern	void	check_object_mesh_visibility (M3Dobject *obj, M3Dvector *position, M3Dvector *target);
extern	void	check_mesh_visibility (void);
extern	void	project (float distance);
	extern	void	project_vertex (M3Dvertex *vert);

extern	int		z_clip (M3Dclip_point *source, M3Dclip_point *clipped, char type);
extern	void	draw_polys (void);

extern	void	clip_and_draw_poly (M3Dpoly_point *points, char type, int num_points);

extern	void	y_intersect_top (M3Dpoly_point *in, M3Dpoly_point *out, M3Dpoly_point *intersect, char type);
extern	void	y_intersect_bot (M3Dpoly_point *in, M3Dpoly_point *out, M3Dpoly_point *intersect, char type);
extern	void	x_intersect_left (M3Dpoly_point *in, M3Dpoly_point *out, M3Dpoly_point *intersect, char type);
extern	void	x_intersect_right (M3Dpoly_point *in, M3Dpoly_point *out, M3Dpoly_point *intersect, char type);
extern	void	clip_and_add_poly_in_pipe (M3Dpoly_point *points, char type, int num_points);

extern	int		poly_compare (M3Dsort *a, M3Dsort *b);
extern	void	mqsort (void  *base, size_t nel, size_t width);
extern	void	sort_polys (void);

#endif