; The double waiting (first for the vertical retrace, then for the end of the
; vertical retrace) is done to generate only one iteration per frame if the
; iteration is faster than the vertical retrace (which will always be the case
; on "modern" machines).

;------------------------------------------------------------------------------
;macro to wait for the next vertical retrace
;al, dx destroyed
;no result
;------------------------------------------------------------------------------
WaitRetrace MACRO
LOCAL InRetrace, NotInRetrace
     mov  dx, 03DAh       ;03dAh is the video status register
InRetrace:
     in   al, dx          ;busy wait until vertical retrace ends
     test al, 08h         ;check if in vertical retrace
     jnz  InRetrace       ;repeat if so

NotInRetrace:
     in   al, dx          ;busy wait until vertical retrace begins
     test al, 08h         ;check if in vertical retrace
     jz   NotInRetrace    ;repeat if not
ENDM
