; These are two macros to set the entire VGA palette to black. In the original
; version by Resident, the code in the macro ClearPalPorts was used, which is
; significantly faster than the BIOS call but results in larger code.
; http://muruganad.com/8086/8086-Interrupt-List.html

;------------------------------------------------------------------------------
;macro to set the entire VGA palette to black (via ports); assumes that the 
;next palette index to be set is zero
;ax, dx, cx destroyed (ax, cx set to 00h)
;------------------------------------------------------------------------------
ClearPalPortsSmall MACRO
LOCAL ClearPaletteLoop
     xor  ax, ax
     mov  dx, 03C9h
     mov  cx, 0100h * 03h ;256 entries in total, 3 channels per palette index
ClearPaletteLoop:
     out  dx, al
     loop ClearPaletteLoop
     xor  dx, dx
ENDM

;------------------------------------------------------------------------------
;macro to set the entire VGA palette to black (via BIOS calls)
;ax, bx, cx, dx destroyed (bx, cx, dx set to 00h)
;no result
;------------------------------------------------------------------------------
ClearPalBios MACRO
LOCAL ClearPaletteLoop
     mov ax, 1010h        ;set the entire vga palette to black
     xor bx, bx           ;dh=red, ch=green, cl=blue, bx=register number
     xor cx, cx
     xor dx, dx
ClearPaletteLoop:
     int 10h              ;use bios interrupt to set palette,
     dec bl               ;note register 00h is set first, FFh, 01h last
     jnz ClearPaletteLoop
ENDM

;------------------------------------------------------------------------------
;macro to set the entire VGA palette to black (via ports)
;ax, dx, ds destroyed (ax set to 00h)
;no result
;------------------------------------------------------------------------------
ClearPalPorts MACRO
LOCAL ClearPaletteLoop
     mov  dx, 03C8h
     mov  ds, dx          ;this was in the implementation by Resident
     xor  ax, ax
ClearPaletteLoop:
     out  dx, al
     inc  dx              ;switch to port 03C9h (to set rgb components)
     xchg ah, al
     out  dx, al          ;red
     out  dx, al          ;green
     out  dx, al          ;blue
     xchg ah, al
     dec  dx              ;switch to port 03C8h again (to set next index)
     inc  al
     jnz  ClearPaletteLoop
ENDM
