; Mini Game Of Life   (C) Kim Enkovaara 1994
;
; Dataformat :
;   * Data is directly from videomemory and consists of two identical pages.
;     And 480 bytes of any kind of data, whick ensures, that loding is
;     succesfull.The colour has to be green (I think so ;)). The character 
;     has to be 03h, that will say that it must be a heart. Otherwise the 
;     coding will not work. The first and last row of each page has to be 
;     empty, colorinformation doesn't matter. The first column has to be 
;     empty too. This has eased up the optimation.
; Other : 
;   * There are not any error checks, so the there has to be file 'l' and
;     it's size ought to be right. If the file doesn't exist, is wrong sized
;     or is in wrong format it's loaded anyhow and that process might stone 
;     the computer.
;   * I don't take any responsibilty about the program. Everyone uses it on
;     his own risk

.286
CODE    SEGMENT PUBLIC  'CODE'
        ORG     100H
        ASSUME  CS:CODE,DS:CODE,SS:CODE,ES:CODE

Start:

IFDEF Maxopt
        mov     ah,3dh                  ; Assume AX=0000h on start
ELSE
        mov     ax,3d00h
ENDIF

        mov     dx,OFFSET filename      ; Get address of filename
        int     21h                     ; Open file with handle
        xchg    bx,ax                   ; BX=Handle

        mov     ax,0b800h               ; Address of videomemory
        mov     ds,ax                   ; to DS
        mov     al,0FAh                 ; AX=adress of videopage 2
        mov     es,ax                   ; ES=B8FA
                        
        mov     ah,3fh                  ; AH=3fh, AL=no matter
        mov     ch,20h                  ; Read 8192-8477 bytes (>80*25*2)
        xor     dx,dx                   ; Start from DS:0 (DS:DX)
        int     21h                     ; Read from file with handle

IFNDEF Maxopt        
        mov     ah,3eh                  ; AH=32h , AL=no matter
        int     21h                     ; Close File 
ENDIF
        mov     bl,0A0h                 ; For modulo
        jmp SHORT vali                  ; Init some values and copy scr1->2

alku:
;Pelaa peli
        mov     cx,2000d-161d           ; Code 1839 blocks in Videomemory

koodausluuppi:
  ;Don't decode empty block = (col 1), Si Mod 160
        mov     ax,si                   ; AX=place in Videobuffer
        div     bl                      ; AX/BL
        or      ah,ah                   ; ZF if 00000000 or 00000000
        je      loppu                   ; IF rem=0, then don't decode
       
       ;Add the blocks to bh
       ; optimize the coding... addressing DS:[] smaller than ES:[]
        
        push    ds                      ; DS to stack
        push    es                      ; ES to stack
        pop     ds                      ; DS=ES
        
        mov     bh,ds:[si-1*2]          ; Left
        add     bh,ds:[si+1*2]          ; Right
        add     bh,ds:[si-81*2]         ; Upper-Right
        add     bh,ds:[si-80*2]         ; Upper
        add     bh,ds:[si-79*2]         ; Upper-Left
        add     bh,ds:[si+79*2]         ; Lower-Left
        add     bh,ds:[si+80*2]         ; Lower
        add     bh,ds:[si+81*2]         ; Lower-Right
        
        mov     ax,0003h
        cmp     ds:[si],al              ; Check if in current place is block
        jne     eipalikka
        ;Block Already
        cmp     bh,6d                   ; If 2 blocks surrounding
        je      elaa

eipalikka:
        cmp     bh,9d                   ; If 3 blocks surrounging
        je      elaa
        xchg    ah,al
        
elaa:
        xchg    ah,al                   ; Set right block for setting
        
        pop     ds                      ; DS=DS old
        mov     ds:[si],ah              ; Set block to videopage 2

loppu:
        sub     si,2                    ; Set the index
        loop    koodausluuppi           ; Loop until done

vali:
;coding ready copy screen 1->2
        mov     di,162d                 ; Startadresses to si/di
        mov     si,162d
        mov     cx,2000d-81d-81d        ; Copy 1838 words
        rep     movsw                   ; Perform the copy

;Check the keyboard
        mov     ah,01
        int     16h                     ; Check keyboard buffer
        jz      alku                    ; If empty go to beginning
        
        ret                             ; Get rid of the program

filename        db      'l',0           ; Filename to load. If you have
                                        ; problems, change it to 'l.',0

CODE    ENDS
        END     Start
        