.286
.MODEL TINY
.CODE
      org 100h

start:					;surprisely it starts here
      cli                               ;disable maskable interrupts
      push      0                       ;\ es points to 0
      pop       es                      ;/
      mov       di,0417h                ;di: 0417h (coz 0:0417=leds' status)
      xor       ax,ax                   ;\
      mov       al,es:[di]              ; save original value
      push      ax                      ;/
      mov       al,10h                  ;startvalue

@@mainloop:
      mov       es:[di],al              ;keyledz (it could also be stosb)
      shl       al,1                    ;who turnz?
      cmp       al,40h                  ;\ are there more ledz?
      jbe       @@nenullaz              ;/

      mov       al,10h                  ;no! - reset startvalue
@@nenullaz:                             ;yes!
      push      ax                      ;save ax: contains the led value

      mov       dx,03F2h                ;and now the disk ledz!
      mov       al,11110000b            ;tricky, eh?
      add       al,[drive]              ;onto which drive
      out       dx,al                   ;go!
      mov       al,1                    ;\
      sub       al,[drive]              ; switch drives
      mov       [drive],al              ;/

      mov       ah,1                    ;has a key been pressed?
      int       16h                     ;(i know in al,60h... is more
      jnz       @@vege                  ;elegant, but not this time!)

      pop       ax                      ;restore led value
      mov       cx,10                   ;wait how much
@@delay:
      call      retrace                 ;wait...
      loop      @@delay                 ;more...

      jmp       @@mainloop              ;do the whole stuff again!

@@vege:
      add       sp,2			;skip a pop
      pop       ax                      ;restore original value into ax
      stosb                             ;and into [0:0417]
      xor       ax,ax			;zero ax
      out       dx,ax			;turn off drive ledz
      mov       ah,0                    ;\ wait for a keypress (illusion)
      int       16h                     ;/
      sti                               ;enable maskable interrupts
      mov       ah,4Ch                  ;\ terminate program
      int       21h                     ;/

retrace         PROC                    ;okay, this is the retrace part
      pusha                             ;don't ask me to explain this...
      mov       dx, 03DAh		;(it only checks some ports)
@@1:
      in        al,dx
      test      al,08h
      jnz       @@1
@@2:
      in        al,dx
      test      al,08h
      jz        @@2
      popa
      ret
retrace         ENDP                    ;but i can tell you: it ends here!

drive           db 0                    ;where we gonna store the drivepos

      END       start