#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <stdlib.h>
#include <process.h>
#include "h\dsmi.h"

#include "h\inside.h"

int soundsready = 0;

//-----------------------------------------------------------------------------

#define TOTAL_SAMPLES 30

//-----------------------------------------------------------------------------

MODULE          *mod = NULL;
long			driverTag;
SDIQUERYDEVICE	SDIQueryDevice;
SDIFUNC 		SDIQueryDeviceCount,SDIDetectDevices, SDIStartOutput, SDIStopOutput = NULL;
SDIINITDEVICE	SDIInitDevice;
SOUNDDEVINFO    sndDev;

//-----------------------------------------------------------------------------

ulong pascal temp1(long a,long b)
{
	a = b;
	return 0;
}

//-----------------------------------------------------------------------------

void pascal temp2(void)
{
}

//-----------------------------------------------------------------------------

char * _ddsexport GetEnvString(char *envName) { return getenv( envName ); }

void (interrupt far * _ddsexport SetVector( long intVector, void (interrupt far *handler)()))()
{
	void far * oldvector;

	oldvector = _dos_getvect(intVector);
	_dos_setvect(intVector,handler);

	return oldvector;
}

//-----------------------------------------------------------------------------

int InitSoundDevice(void)
{
	GFILE			f;
    char            fname[33];
	int 			i;
    char            extended_fname[80];

	// read the config file
    f = OpenFile("SOUND.CFG",GF_READ | GF_BINARY);
	if( f == -1 ) return -1;
	ReadFile(f,fname,13);
	ReadFile(f,&sndDev,sizeof(SOUNDDEVINFO));
	CloseFile(f);

	// Some sound devices require access to DOS environment strings
	DDSRegisterFunction("GetEnvString",GetEnvString);

	// Most sound devices need a way to set interrupt vectors
	DDSRegisterFunction("SetVector",SetVector);

    sprintf (extended_fname,"%s",fname);

    i = DDSLoadDriver(extended_fname,&driverTag);
	if( i == DDS_LOAD_OK )
	{
		DDSAccessFunction("SDIInitDevice",(void**)&SDIInitDevice);
		DDSAccessFunction("SDIStartOutput",(void**)&SDIStartOutput);
		DDSAccessFunction("SDIStopOutput",(void**)&SDIStopOutput);
		SDIInitDevice(&sndDev);
		return 0;
	}

    return -1;
}

//-----------------------------------------------------------------------------

void SND_irq_play()
{
    static int snd_re_entrance = 0;

    if (!soundsready)
        return;

    UpdateDSMITime();


    if (!snd_re_entrance && !SILENT)
    {
        snd_re_entrance++;
        cdiPoll(0);
        ampPoll();
        snd_re_entrance--;
    };

}

//-----------------------------------------------------------------------------

void SND_set_sync (int newsync)
{
    if (!soundsready) return;
    ResetDSMITime((2500.0*newsync)/287280.0);    // unbelievable hattuvakio
}

//-----------------------------------------------------------------------------

void SND_kill_background_music()
{
    int i;

    if (!soundsready) return;

    if (SILENT) return;

    if (mod)
    {
          ampStopModule();
          ampFreeModule(mod);
    }

    cdiClose();

    if( SDIStopOutput != NULL )
        SDIStopOutput();

    DDSUnloadDriver(driverTag);

    soundsready = 0;

}

//-----------------------------------------------------------------------------

void screw_extender();
#pragma aux screw_extender = \
"push ds" \
"pop es" \
parm [];

void SND_init()
{
    if (SILENT) return;

    screw_extender();

    file_io++;

	InitGeneralFileSys(40);

	DDSInit();

    InitDSMITime (36);

    SND_set_sync (4104);        // let's try this for starters

	DDSRegisterFunction("MCPSampleRealAddress",temp1);
	DDSRegisterFunction("MCPEnableVirtualSamples",temp2);
	DDSRegisterFunction("MCPDisableVirtualSamples",temp2);

	cdiInit();

    if(InitSoundDevice())
    {
        SILENT = 1;
        FAIL("Error loading sound driver. Please run 'setup.exe' first\n"\
             "to configure your hardware. If you don't have a soundcard,\n"\
             "select the 'no sound driver' option from the menu.\n");
        exit(1);
    }

	SDIStartOutput();
	ampInit(0);

    cdiSetupChannels( 0, 24);

    if (ampLoadAMF("eye.amf",0,&mod) == MERR_NONE )
            ampPlayModule(mod,PM_LOOP); else
        FAIL ("Error in loading module 'eye.amf'. Please configure\n"\
              "your sound hardware by running setup.exe and esure\n"\
              "that the file 'eye.amf' is in the current directory.\n");

    soundsready = 1;
    file_io--;

}

//-----------------------------------------------------------------------------
