// calculate shading table

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <i86.h>


#pragma aux set_vga_palette "*_" \
 parm caller [esi] \
 modify [];

unsigned char lut [64][64][64];
unsigned char shadetab[256][256];
unsigned char pal [256][3];

unsigned char *screen = 0xA0000;

FILE *infile;

void main (int argc, char *argv[])
{  union REGS regs;
   int r,g,b;
   int i,j,intte;

   if (argc<2) {printf ("Syntax : %s <.ccb> [<.shd>] \n",argv[0]); exit(1);}

   infile=fopen (argv[1],"rb");

   fread (lut,1,64*64*64,infile);
   fread (pal,1,768,infile);
   fclose (infile);

   regs.x.eax = 0x13;                      // gfx mode on
   int386(0x10,&regs,&regs);

    regs.x.eax = 0x1012;
    regs.x.ebx = 0;
    regs.x.ecx = 256;
    regs.x.edx = (int)pal;
    int386(0x10, &regs, &regs);


  for (i=0; i<64; i++)
   for (j=0; j<256; j++)     // 256
    {

    /*
      if (i<40)
      {
            r = ((pal[j][0]*i)/40.0);
            g = ((pal[j][1]*i)/40.0);
            b = ((pal[j][2]*i)/40.0);
      } else
      {
        r = pal[j][0]+i-40;
        g = pal[j][1]+i-40;
        b = pal[j][2]+i-40;
     }
     */

      r = (pal[j][0]*i)/63;
      g = (pal[j][1]*i)/63;
      b = (pal[j][2]*i)/63;

      if (r>63) r=63; if (r<0) r = 0;
      if (g>63) g=63; if (g<0) g = 0;
      if (b>63) b=63; if (b<0) b = 0;

      shadetab[i][j]=lut[r][g][b];
      if (i<200) screen[i*320+j]=shadetab[i][j];
   }

   getch();

   regs.x.eax = 0x3;                      // gfx mode on
   int386(0x10,&regs,&regs);

   if (argc==3)
   {

    infile=fopen (argv[2],"wb");
    fwrite (shadetab,1,64*256,infile);
    fclose (infile);
    printf ("Wrote shading table file %s\n",argv[2]);
   }

}

