//-----------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "\sr\h\sr.h"
#include "\lib\h\control.h"
#include "\lib\h\memory.h"
#include "\lib\h\bitmap.h"
#include "h\inside.h"
#include "\lib\h\vga.h"

//-----------------------------------------------------------------------------

#define GW 8
#define GS 350

static int room_tag;
static int roommode = 0;
static int flyer = 0;

static SR_SCENE    *scene;
static SR_CAMERA   *camera;
static SR_MAT	   *texture;
static SR_MAT	   *texture2;
static SR_MAT	   *shadowmap;
static SR_FILE	   *sro;
static SR_MESH	   *obj;
static MATRIX3	   rota;
static SR_FILE	   *kuubio;
static SR_MESH	   *obj2;
static SR_LIGHT    *lite;
static SR_MESH	   *varjo;
static SR_FILE	   *square;

#define TOTAL 5

static char *room[TOTAL];
static char *shade[TOTAL];
static char *sprite[TOTAL];
static char *palette[TOTAL];
static BITMAP *bitmap[TOTAL];
static char   *shadow[TOTAL];
static char   *shader[TOTAL];

float ra=-0.37;
float rb= 0.51;
float rc= 0.16;

static float p1 = 0.0;
static float a1 = 0.07;
static float r1 = 425.0;
static float sx1 = 0.3;
static float sy1 = 0.2;

static float p2 = 0.0;
static float a2 = 0.05;
static float r2 = 130.0;
static float sx2 = 0.4;
static float sy2 = 0.6;

static float p3 = 0.0;
static float a3 = -0.06;
static float r3 = 250.0;
static float sx3 = 0.7;
static float sy3 = 0.5;

//-----------------------------------------------------------------------------

void room_change()
{
    p1 = -0.0;
    a1 = -0.07;
    r1 = -435.0;
    sx1 = -0.3;
    sy1 = -0.2;

    p2 = 0.0;
    a2 = -0.08;
    r2 = -150.0;
    sx2 = -0.4;
    sy2 = -0.6;

    p3 = 0.0;
    a3 = -0.06;
    r3 = -250.0;
    sx3 =-0.7;
    sy3 =-0.5;
}

//-----------------------------------------------------------------------------

void room_suspend()
{
    set_demo_irq  (NULL);
    set_demo_loop (NULL);
}

//-----------------------------------------------------------------------------

void room_irq()
{
	p1+=a1; p2+=a2; p3+=a3;
	SR_mmul(obj->matrix, rota);
	SR_mmul(obj2->matrix, rota);
}

//-----------------------------------------------------------------------------

void room_main_loop()
{
	int x,y;
	SR_VERT *v;

	scene->buffer = buffer1;

    texture->bitmap1 = room[roommode];
    texture->bitmap2 = room[roommode];
    texture->shade1  = shade[roommode];

    texture2->bitmap1 = room[roommode];
    texture2->bitmap2 = room[roommode];
    texture2->shade1  = shade[roommode];

    shadowmap->bitmap1    = shadow[roommode];
    shadowmap->shade1     = shader[roommode];


/*
    if(KBD_buffer[KEY_Q])
	{
		ra+=0.01;
		SR_set_rotation((SR_OBJ *)camera, ra,rb,rc);
	}
	if(KBD_buffer[KEY_W])
	{
		ra-=0.01;
		SR_set_rotation((SR_OBJ *)camera, ra,rb,rc);
	}

	if(KBD_buffer[KEY_A])
	{
		rb+=0.01;
		SR_set_rotation((SR_OBJ *)camera, ra,rb,rc);
	}
	if(KBD_buffer[KEY_S])
	{
		rb-=0.01;
		SR_set_rotation((SR_OBJ *)camera, ra,rb,rc);
	}

	if(KBD_buffer[KEY_Z])
	{
		rc+=0.01;
		SR_set_rotation((SR_OBJ *)camera, ra,rb,rc);
	}
	if(KBD_buffer[KEY_X])
	{
		rc-=0.01;
		SR_set_rotation((SR_OBJ *)camera, ra,rb,rc);
	}

	if(KBD_buffer[KEY_E])
	{
		camera->x+=140.0;
	}
	if(KBD_buffer[KEY_R])
	{
		camera->x-=140.0;
	}

	if(KBD_buffer[KEY_D])
	{
		camera->y+=140.0;
	}
	if(KBD_buffer[KEY_F])
	{
		camera->y-=140.0;
	}

	if(KBD_buffer[KEY_C])
	{
		camera->z+=140.0;
	}
	if(KBD_buffer[KEY_V])
	{
		camera->z-=140.0;
    }
*/

	camera->y-=flyer;
    if(roommode!=3) camera->x-=flyer/2;


    if(roommode<3)
	{
		obj->flags &= (~SR_DISABLE);
		obj2->flags |= SR_DISABLE;

		for(y=0;y<GW;y++)
			for(x=0;x<GW;x++)
			{
				v = &(obj->vertex[x+y*GW]);

				v->u = (x*256*16)/GW + sin(p1+sx1*x+sy1*y)*r1+sin(p2+sx2*x+sy2*y)*r2+sin(p3+sx3*x+sy3*y)*r3;
				v->v = (y*256*16)/GW + cos(p1+sx1*x+sy1*y)*r1+cos(p2+sx2*x+sy2*y)*r2+cos(p3+sx3*x+sy3*y)*r3;
				v->w = (x*256*16)/GW + cos(p1+sx1*x+sy1*y)*r3+cos(p2+sx2*x+sy2*y)*r2+sin(p3+sx3*x+sy3*y)*r1;
				v->q = (y*256*16)/GW + sin(p1+sx1*x+sy1*y)*r3+cos(p2+sx2*x+sy2*y)*r2+sin(p3+sx3*x+sy3*y)*r1;

				v->x = x*GS-(GW*GS/2); // + sin(p1+sx1*x+sy1*y)*r1+sin(p2+sx2*x+sy2*y)*r2+sin(p3+sx3*x+sy3*y)*r3;
				v->z = y*GS-(GW*GS/2); // + cos(p1+sx1*x+sy1*y)*r1+cos(p2+sx2*x+sy2*y)*r2+cos(p3+sx3*x+sy3*y)*r3;

				v->y = 0; //cos(p1+sx1*x+sy1*y)*cos(p2+sx2*x+sy2*y)*cos(p3+sx3*x+sy3*y)*r3;

			}

		SR_render_view(scene);
        BITMAP_draw(bitmap[roommode], 0, 200-bitmap[roommode]->ysiz);
	}
	else
	{
		obj2->flags &= (~SR_DISABLE);
		obj->flags |= SR_DISABLE;

        if(roommode==3)
		{
			varjo->vertex[1].x = 2048-512*cos(timer/180.6)*sin(timer/208.1);
			varjo->vertex[1].y = 1024*cos(timer/176.6)*sin(timer/163.3);

			lite->luminance = 75*16 + 25*16*sin(timer/300.7);

			lite->x = 1750*cos(timer/180.6)*sin(timer/208.1);
			lite->y = 1750*cos(timer/176.6)*sin(timer/163.3);
			lite->z = 1750*cos(timer/196.6)*sin(timer/150.4);
		}
		else
		{
			varjo->vertex[1].x = -750+200*cos(timer/130.6)*sin(timer/208.1);
			varjo->vertex[1].y = +500+500*cos(timer/176.6)*sin(timer/113.3);

			lite->luminance = 75*16 + 25*16*sin(timer/300.7);

			lite->x = 1750*cos(timer/130.6)*sin(timer/208.1);
			lite->y = 1750*cos(timer/176.6)*sin(timer/113.3);
			lite->z = 1750*cos(timer/196.6)*sin(timer/150.4);

//			  varjo->vertex[0].x += 10;
		}


		for(y=0;y<GW;y++)
			for(x=0;x<GW;x++)
			{
				v = &(obj->vertex[x+y*GW]);

				v->u = (x*256*16)/GW;
				v->v = (y*256*16)/GW;
				v->x = x*GS*2-(GW*GS);
				v->z = y*GS*2-(GW*GS);
			}

		// SR_clear_view(scene,0x00);
		SR_render_view(scene);

//		  if(rand()&1)
        if(roommode==3)
            BITMAP_draw(bitmap[roommode], 320-bitmap[roommode]->xsiz, 200-bitmap[roommode]->ysiz);
		else
            BITMAP_draw(bitmap[roommode], 94, 28);


	}

	show_info();
	flip_page();
	while(draw_status != FRAME_WAITING) {}
}

//-----------------------------------------------------------------------------

void room_fetch_1()
{
	file_io++;
    MEM_set_tag (room_tag);

    palette[1] = load_file ("room/room1.pal");
    room[1]   = load_file ("room/room1.raw");
    shade[1]   = load_file ("room/room1.shd");
    sprite[1]  = load_file ("room/sprite1.raw");

    bitmap[1] = BITMAP_make_sprite8(sprite[1], 164, 164,156, "room sprite1");
	bitmap[1]->type = BITMAP8_M;

	file_io--;
}

//-----------------------------------------------------------------------------

void room_fetch_2()
{
	file_io++;
    MEM_set_tag (room_tag);

    palette[2] = load_file ("room/room2.pal");
    room[2]   = load_file ("room/room2.raw");
    shade[2]   = load_file ("room/room2.shd");
    sprite[2]  = load_file ("room/sprite2.raw");

    palette[2][0] = 0;
    palette[2][1] = 0;
    palette[2][2] = 0;

    bitmap[2] = BITMAP_make_sprite8(sprite[2], 172, 172,200, "room sprite2");
	bitmap[2]->type = BITMAP8_M;

	file_io--;
}

//-----------------------------------------------------------------------------

void room_fetch_3()
{
	file_io++;
    MEM_set_tag (room_tag);

    palette[3] = load_file ("room/room9.pal");
    room[3]   = load_file ("room/room9.raw");
    shade[3]   = load_file ("room/room9.qnt");
    sprite[3]  = load_file ("room/sprite9.raw");
    shadow[3]  = load_file ("room/shadow9.raw");
    shader[3]  = load_file ("room/shadow9.sdw");

	palette[3][0] = 0;
	palette[3][1] = 0;
	palette[3][2] = 0;

    bitmap[3] = BITMAP_make_sprite8(sprite[3], 274, 274,147, "room sprite3");
	bitmap[3]->type = BITMAP8_M;

	file_io--;
}

//-----------------------------------------------------------------------------


void room_fetch_4()
{
	file_io++;
    MEM_set_tag (room_tag);

    palette[4] = load_file ("room/room4.pal");
    room[4]   = load_file ("room/room4.raw");
    shade[4]   = load_file ("room/room4.qnt");
    sprite[4]  = load_file ("room/sprite4.raw");
    shadow[4]  = load_file ("room/shadow4.raw");
    shader[4]  = load_file ("room/shadow4.sdw");

	palette[4][0] = 0;
	palette[4][1] = 0;
	palette[4][2] = 0;

    bitmap[4] = BITMAP_make_sprite8(sprite[4], 170, 170,168, "room sprite4");
	bitmap[4]->type = BITMAP8_M;

	file_io--;
}

//-----------------------------------------------------------------------------

void room_load()
{
	int i;

    room_tag = MEM_get_unused_tag();
    MEM_set_tag (room_tag);

    SR_init();

    scene   = MEM_allocate_named(sizeof(SR_SCENE) ,"room scene");
    camera  = MEM_allocate_named(sizeof(SR_CAMERA),"room camera");
    texture = MEM_allocate_named(sizeof(SR_MAT)   ,"room material");
    texture2= MEM_allocate_named(sizeof(SR_MAT)   ,"room material2");
    shadowmap = MEM_allocate_named(sizeof(SR_MAT) ,"room shadowmap");
    lite    = MEM_allocate_named(sizeof(SR_LIGHT) ,"room light");
    sro     = MEM_allocate_named(65536            ,"room grid-sro");
    square  = MEM_allocate_named(8192             ,"room shadowsquare");

	SR_create_grid(sro, GW-1,GW-1,200,200);
	SR_create_grid(square, 1,1, 1400,800);

    obj     = MEM_allocate_named(SR_SIZE(sro)     ,"room warpgrid");
    varjo   = MEM_allocate_named(SR_SIZE(square)  ,"room shadepoly");

	SR_camera_init (camera);
	SR_init_scene  (scene);

	SR_set_viewport(scene,320,200,0,0,320,200);
	scene->camera	   = camera;
	scene->front_clip_depth = 32*256;

	SR_set_location((SR_OBJ *)camera, 0,0,-1300);
	SR_set_rotation((SR_OBJ *)camera, 0,0,0);
	SR_add_object(scene, camera);

	SR_init_object ((SR_OBJ *)obj);
	SR_load_object (obj,sro,65536,texture);
	SR_set_object_render(obj, SR_TEX_P);
	SR_add_object (scene, (SR_OBJ *)obj);
	SR_set_rotation((SR_OBJ *)obj, 1.5,3.0,0);

	SR_init_object ((SR_OBJ *)varjo);
	SR_load_object (varjo,square,65536,shadowmap);
	SR_set_object_render(varjo, SR_TEX_I);
	SR_add_object (scene, (SR_OBJ *)varjo);
	SR_set_rotation((SR_OBJ *)varjo, 0,0,0);
	SR_set_location((SR_OBJ *)varjo, 300,3000,600);
	varjo->flags = SR_NOCULL;
	varjo->sortbias = 666666;


    kuubio = load_file ("room/poksi.sro");
    obj2   = MEM_allocate_named(SR_SIZE(kuubio),"room kuubio");
	SR_load_object (obj2,kuubio,65536*8,texture);
	SR_add_object (scene, (SR_OBJ *)obj2);
	SR_set_object_render(obj2, SR_TEX);

	obj2->flags |= SR_DO_LIGHT;

	for(i=0;i<obj2->pnum;i+=2)
	{
		obj2->poly[i].mat = texture2;
    }

	SR_init_object((SR_OBJ *)lite);
	lite->falloff	= 5000;
	lite->luminance = 100*16;
	lite->flags |= SR_ILLUMINATE;
	SR_add_object(scene, (SR_OBJ *)lite);

	shadowmap->shade2	  = NULL;
	shadowmap->flags	  = 0;

	texture->shade2 	= NULL;
	texture->flags		= 0;
	texture->widthmask	= 0xFF;
	texture->heightmask = 0xFF;
	texture->widthbits	= 8;
	texture->heightbits = 8;

	texture2->shade2  = NULL;
	texture2->flags   = 0;
	texture2->widthmask  = 0xFF;
	texture2->heightmask = 0xFF;
	texture2->widthbits  = 8;
	texture2->heightbits = 8;

	SR_mrotxyz(rota, 0.0, 0.01, 0.0);
}

//-----------------------------------------------------------------------------

void room_init_1()
{
    MEM_set_tag (room_tag);
    roommode = 1;
	flyer = 0;

    texture->flags = 0;
    texture2->flags = 0;
	SR_set_location((SR_OBJ *)camera, 0,0,-1300);
	SR_set_rotation((SR_OBJ *)camera, 0,0,0);
	scene->perspective = 256;
	SR_set_location((SR_OBJ *)camera, 0,0,-1300);
    set_demo_irq  (&room_irq);
    set_demo_loop (&room_main_loop);
    set_base_palette(palette[roommode]);
}

//-----------------------------------------------------------------------------

void room_init_2()
{
    MEM_set_tag (room_tag);
    roommode = 2;
	flyer = 0;

    texture->flags = 0;
    texture2->flags = 0;
	SR_set_location((SR_OBJ *)camera, 0,0,-1300);
	SR_set_rotation((SR_OBJ *)camera, 0,0,0);
	scene->perspective = 256;
	SR_set_location((SR_OBJ *)camera, 0,0,-1300);

    set_demo_irq  (&room_irq);
    set_demo_loop (&room_main_loop);
    set_base_palette(palette[roommode]);
}

//-----------------------------------------------------------------------------

void room_init_3()
{
    MEM_set_tag (room_tag);
    roommode = 3;
	flyer = 0;

    ra=-0.37;
    rb= 0.51;
    rc= 0.16;

	varjo->vertex[0].u = 16*255;
	varjo->vertex[0].v = 0;

	varjo->vertex[0].x = 0;
	varjo->vertex[0].y = 0;
	varjo->vertex[0].z = 0;

	varjo->vertex[1].u = 0;
	varjo->vertex[1].v = 0;

	varjo->vertex[1].x = 2048;
	varjo->vertex[1].y = -0;
	varjo->vertex[1].z = 0;

	varjo->vertex[2].u = 16*255;
	varjo->vertex[2].v = 16*255;
	varjo->vertex[2].x = 400;
	varjo->vertex[2].y = -2400;
	varjo->vertex[2].z = 0;

	varjo->vertex[3].u = 0;
	varjo->vertex[3].v = 16*255;
	varjo->vertex[3].x = 2048-100;
	varjo->vertex[3].y = -1600;
	varjo->vertex[3].z = 0;

	shadowmap->widthmask  = 0x7F;
	shadowmap->heightmask = 0x7F;
	shadowmap->widthbits  = 7;
	shadowmap->heightbits = 7;

	texture->flags = MAT_UV_OVERRIDE;

	texture->u1 = 0;
	texture->v1 = 0;

	texture->u3 = 255*16;
	texture->v3 = 0;

	texture->u2 = 0;
	texture->v2 = 255*16;

	texture2->flags = MAT_UV_OVERRIDE;

	texture2->v3 = 0;
	texture2->u3 = 255*16;

	texture2->v1 = 255*16;
	texture2->u1 = 0;

	texture2->u2 = 255*16;
	texture2->v2 = 255*16;

	SR_set_rotation((SR_OBJ *)varjo, 1.5,3.0,0);
	scene->ambient_luminance = 7*16;
	scene->front_clip_depth = 22*256;
	SR_set_location((SR_OBJ *)camera, -1600,2000,-2200);
	SR_set_rotation((SR_OBJ *)camera, ra,rb,rc);
    set_demo_irq  (&room_irq);
    set_demo_loop (&room_main_loop);
    set_base_palette(palette[roommode]);

	SR_set_rotation((SR_OBJ *)obj2, 0.0,0.0,0.0);
	SR_set_object_render(obj2, SR_TEX_G);
	SR_mrotxyz(rota, 0.0, 0.01, 0.0);

}

//-----------------------------------------------------------------------------

void room_init_4()
{
    MEM_set_tag (room_tag);
    roommode = 4;
	flyer=0;

	varjo->vertex[0].u = 16*255;
	varjo->vertex[0].v = 0;
	varjo->vertex[1].u = 0;
	varjo->vertex[1].v = 0;
	varjo->vertex[2].u = 16*255;
	varjo->vertex[2].v = 16*255;
	varjo->vertex[3].u = 0;
	varjo->vertex[3].v = 16*255;
	varjo->vertex[0].y = 700;
	varjo->vertex[1].y = 700;
	varjo->vertex[2].y = 700;
	varjo->vertex[3].y = 700;


	varjo->vertex[0].x = +900;
	varjo->vertex[0].z = +500;

	varjo->vertex[1].x = -750;
	varjo->vertex[1].z = +500;

	varjo->vertex[2].x = +900;
	varjo->vertex[2].z = -700;

	varjo->vertex[3].x = -750;
	varjo->vertex[3].z = -700;


	shadowmap->widthmask  = 0xFF;
	shadowmap->heightmask = 0xFF;
	shadowmap->widthbits  = 8;
	shadowmap->heightbits = 8;

	texture->flags = MAT_UV_OVERRIDE;
    texture2->flags = MAT_UV_OVERRIDE;

	texture->v1 = 0;
	texture->u1 = 0;

	texture->v3 = 255*16;
	texture->u3 = 0;

	texture->v2 = 0;
	texture->u2 = 255*16;

	texture2->v3 = 0;
	texture2->u3 = 255*16;

	texture2->v1 = 255*16;
	texture2->u1 = 0;

	texture2->v2 = 255*16;
	texture2->u2 = 255*16;

	ra=-0.89;
	rb= 0.61;
	rc= 1.08;


	scene->ambient_luminance = 7*16;
	scene->front_clip_depth = 22*256;
	SR_set_location((SR_OBJ *)camera, -550,2000,-500);
    set_demo_irq  (&room_irq);
    set_demo_loop (&room_main_loop);
    set_base_palette(palette[roommode]);

	SR_set_rotation((SR_OBJ *)varjo, 0.0,1.0,0);

	SR_set_rotation((SR_OBJ *)obj2, 0,0,0);
	SR_set_rotation((SR_OBJ *)camera, ra,rb,rc);
	SR_set_object_render(obj2, SR_TEX_G);
	SR_mrotxyz(rota, 0.0, -0.01, 0.0);

}

//-----------------------------------------------------------------------------

void room_levitate()
{
    flyer = 30;
}

//-----------------------------------------------------------------------------

void room_exit()
{
	set_demo_irq  (NULL);
	set_demo_loop (NULL);
    //MEM_free_tagged (room_tag);
}

//-----------------------------------------------------------------------------
