#ifndef _INSIDE_H
#define _INSIDE_H

#ifdef __cplusplus
extern "C" {
#endif

//-----------------------------------------------------------------------------
// the demo events are listed in file 'script'
//-----------------------------------------------------------------------------

typedef struct
{
    int pattern;                         // music pattern
    int position;                        // music position
    void (*func)(void);                  // event function
} eventstruct;

//-----------------------------------------------------------------------------

#define FRAME_WAITING  0
#define FRAME_READY    1
#define FRAME_BLITTING 2

//-----------------------------------------------------------------------------

extern  eventstruct     eventlist[];
extern  volatile int    draw_status;
extern  volatile int    cli;             // set this to disable IRQ momentarily
extern  volatile int    force_exit;      // if true, exit program
extern  volatile int    timer;           // total timer
extern  volatile int    demotimer;       // timer for each specific part
extern  volatile int    file_io;          // if set, do only sound IRQs
extern           char  *buffer1;         // current draw buffer
extern           char  *buffer2;

extern           int    DEBUG;           // set to TRUE to get debug info
extern           int    ZIPLOAD;         // load from zipped file
extern           int    SILENT;

//-----------------------------------------------------------------------------

void        FAIL             (char *format, ...);
void        initialize       ();
void        shutdown         ();
void        set_demo_irq     (void *func());        // demo irq function
void        set_demo_loop    (void *func());        // demo main loop function
void        flip_page        ();
void        set_base_palette (char *pal);
void        flash            (int addition, int ticks);
void        set_fade         (float level, int ticks);
void       *load_file        (char *name);
void        set_viewport     (int xw, int yh, int xs, int ys, int xe, int ye);
void        run_demo         ();
void        show_info        ();
void        write_text       (int x, int y, char *format, ... );
void        start_timer      ();
void        dummyfunc        ();

//-----------------------------------------------------------------------------
// generic event commands
//-----------------------------------------------------------------------------

void        strobo           ();                    // show strobo flash
void        negative         ();                    // nega palette flash
void        fade_out         ();                    // fade to black
void        fade_white       ();                    // fade and stay white

//-----------------------------------------------------------------------------
// intro section
//-----------------------------------------------------------------------------

void        intro_load       ();                    // load intro part
void        intro_init       ();                    // initialize intro part
void        intro_exit       ();                    // end intro part
void        intro_burst      ();                    // burst the lightmap

//-----------------------------------------------------------------------------
// flight section
//-----------------------------------------------------------------------------

void        flight_load      ();                    // load flight part
void        flight_init      ();                    // initialize flight section
void        flight_exit      ();                    // end flight section

//-----------------------------------------------------------------------------
// logo section
//-----------------------------------------------------------------------------

void        logo_load        ();                    // load logo data
void        logo_init        ();                    // initialize logo part
void        logo_turn_picture_on ();                // turn logo pic on
void        logo_exit        ();                    // end logo part


//-----------------------------------------------------------------------------
// temple section
//-----------------------------------------------------------------------------

void        temple_load        ();                    // load temple data
void        temple_init        ();                    // initialize temple part
void        temple_exit        ();                    // end temple part

//-----------------------------------------------------------------------------
// credit section
//-----------------------------------------------------------------------------

void        credit_load        ();                    // load credit data
void        credit_init        ();                    // initialize credit part
void        credit_next        ();                    // next credit text
void        credit_exit        ();                    // end temple part
void        credit_ball_on     ();                    // spikeball!!

//-----------------------------------------------------------------------------
// water section
//-----------------------------------------------------------------------------

void        water_load        ();                    // load water data
void        water_init        ();                    // initialize water part
void        water_next        ();                    // next water text
void        water_exit        ();                    // end water part

//-----------------------------------------------------------------------------
// room section
//-----------------------------------------------------------------------------

void        room_load        ();                   // load files for room
void        room_init_1      ();                   // start room 1
void        room_init_2      ();                   // start room 2
void        room_init_3      ();                   // start room 3
void        room_init_4      ();                   // start room 4
void        room_exit        ();                   // end room part
void        room_levitate    ();                   // da flyin roomh
void        room_suspend     ();

void        room_fetch_1     ();                   // get room 1 graphics
void        room_fetch_2     ();                   // get room 2 graphics
void        room_fetch_3     ();                   // get room 3 graphics
void        room_fetch_4     ();                   // get room 4 graphics

void        room_change      ();

//-----------------------------------------------------------------------------
// flower tunnel
//-----------------------------------------------------------------------------

void        flower_load       ();
void        flower_init       ();
void        flower_exit       ();
void        flower_next       ();
void        flower_disable    ();

//-----------------------------------------------------------------------------

void		twirl_load		  ();
void		twirl_init		  ();
void		twirl_exit		  ();
void		twirl_next		  ();
void		twirl_suspend	  ();

//-----------------------------------------------------------------------------
// some internal stuff
//-----------------------------------------------------------------------------

int         check_events     ();                    // don't call this..

//-----------------------------------------------------------------------------

#ifdef __cplusplus
}
#endif

#endif
