#include "vu.h"
#include "hwreg.h"

void vu1_uploadcode(void *begin, void *end)
{
	int *begin_=begin,*end_=end;
	volatile int *dest=(void*)vu1_micromem;
	
	while(begin_<end_)
	{
		*dest=*begin_;
		dest++;
		begin_++;
	}
}

void vu1_uploaddata(void *begin, void *end)
{
	int *begin_=begin,*end_=end;
	volatile int *dest=(void*)vu1_mem;
	
	while(begin_<end_)
	{
		*dest=*begin_;
		dest++;
		begin_++;
	}
}

void vu1_uploaddata2(void *datastart, void *begin, void *end)
{
	int *begin_=begin,*end_=end,*datastart_=datastart;
	volatile int *dest=(void*)vu1_mem;

	dest+=begin_-datastart_;
	
	while(begin_<end_)
	{
		*dest=*begin_;
		dest++;
		begin_++;
	}
}

void vu1_cleardata()
{
	int t;
	volatile fvec *dest=(fvec*)vu1_mem;
	for(t=0;t<1024;t++)
	{
		dest[t].x=0;
		dest[t].y=0;
		dest[t].z=0;
		dest[t].w=0;
		}
}

void vu1_wait()
{
	//2 nops before coprocessor 2 wait?
	asm __volatile__(
	"nop
	nop
	0:
	bc2t 0b
	nop
	nop");	
}


void vu1_start()
{
	asm __volatile__(
	"ctc2.i $0,$31");	
}
