/* Background effect for textwriting */
/* SoopaDoopa 2001 */

#include "eks2.h"
#include "gif.h"
#include "dma.h"
#include "texture.h"
#include "math.h"
#include "matrix.h"

extern char binary_dot_start[];
extern char binary_dot2_start[];

static int128	list[40];

static texture tex2;
static texture tex3;


static  void setscissor(int y1, int y2)
{
	gif_env;

	return;
	
	dma_begingp();

	gif_tag(0xe,1,0,0,0);

	gSCISSOR_1(wwd(hhw(0,639),hhw(y1,y2)));	// x1,y1,x2,y2 - scissor window
	
	gif_endfinal();

	dma_endgp();
}

static void puttexture2(texture *tex, float posx, float posy, float width, float height, int color)
{
	int x1=32000+(posx-width*0.5)*16;
	int y1=32000+(posy-height*0.5)*16;
	int x2=32000+(posx+width*0.5)*16;
	int y2=32000+(posy+height*0.5)*16;
	
	gif_env;
	
	dma_begingp();

	gif_tag(0xe,1,0,0,0);

//	gSCISSOR_1(wwd(hhw(0,639),hhw(60,240)));	// x1,y1,x2,y2 - scissor window
	gPRMODECONT(1);					// refer to prim attributes
	gCOLCLAMP(1);
	gCLAMP_1(0);
	gALPHA_1(0x4000000048);
	gDTHE(0);					// Dither off

	gTEX0_1(texture_TEX0(tex));
	gTEX1_1(1<<5);					//bilinear

	gTEST_1(0x30000);
	gPRIM(0x116+0x40);
	gPABE(0);
	gRGBAQ(0x3F80000080808080);			// Background RGBA
	gUV(hhw(0,0));
	gXYZ2(hhw(x1,y1));
	gUV(hhw((tex->width)*16,(tex->height)*16));
	gRGBAQ(0x3F80000080000000+color);		// Background RGBA
	gXYZ2(hhw(x2,y2));
	gif_endfinal();

	dma_endgp();
}

void eks2_init()
{
	texture_init(&tex2);
	texture_load(&tex2,binary_dot_start);
	texture_init(&tex3);
	texture_load(&tex3,binary_dot2_start);
}

void eks2_init2()
{
	texture_allocupload(&tex2);
	texture_allocupload(&tex3);
}

extern int PAL;

void eks2_frame(float frames, int maxpart)
{
	fmatrix m;
	int max2;

	if(PAL)
		max2=948;
	else
//		max2=900;		//Nagra tells me that this is too many
		max2=670;		//Nagra tells me that this is too many
	
	setscissor(60,240);

	resetmatrixf(&m);
	rotatematrixxf(&m,frames*.008);
	rotatematrixyf(&m,frames*.004);
	rotatematrixzf(&m,frames*.003);
	scalematrixf(&m,2,1,1);
	movematrixf(&m,320,138,0);
	
	{
		float thorsten=0.007*2;

		int t;
		float sc;
		float sc2;
		for(t=0;t<min(max2,maxpart);t++)
		{
			fvec v,w;
			float scalet=1.2+cos2(frames*0.004)*1+sin2(t*0.002)*0.5;
			sc = 0.8*(60*sin2(frames*0.008+t*scalet*0.017)+80*sin2(frames*0.013+t*scalet*0.02));
			sc2 = 0.3*(60*sin2(frames*0.014+t*scalet*0.012)+80*sin2(frames*0.012+t*scalet*0.013));
			
			
			v.x=sc*sin2(t*scalet*0.015*sc2*0.004);	
			v.y=sc*cos2(t*scalet*0.014*sc2*0.003);
			v.z=sc*sin2(t*scalet*0.012*sc2*0.005);

			transformf2(&m,&v,&w,1);		
			

			puttexture2(&tex2,w.x,
				  w.y,
				  36*sin2(t*scalet*0.04)+50*(v.z*0.065),
				  18*sin2(t*scalet*0.04)+30*(v.z*0.065),
				  rgb(8+3*cos2(t*scalet*0.004),5-1*cos2(t*scalet*0.003),6+1.5*cos2(t*scalet*0.003)));				  

		}
	}

	setscissor(0,255);
}

void eks2_frame2(float frames, int maxpart)
{
	/* thorstens seje effekt*/
	
	int t;
	float sc;
	float sc2;
	int max2;

	if(PAL)
		max2=2*1048;
	else
		max2=1600;


	setscissor(60,240);

	for(t=0;t<min(max2,maxpart);t++)
	{
		float scalet=0.7;
		sc = 0.8*(60*sin2(frames*0.008+t*scalet*0.017)+80*sin2(frames*0.013+t*scalet*0.02));
		sc2 = 0.3*(60*sin2(frames*0.014+t*scalet*0.012)+80*sin2(frames*0.012+t*scalet*0.013));

		puttexture2(&tex3,320+sc*2*sin2(t*scalet*0.015*sc2*0.014),
			  138+sc*cos2(t*scalet*0.014*sc2*0.013),
			  36*sin2(t*scalet*0.04)+40,
			  18*sin2(t*scalet*0.04)+20,
			  rgb(10+4*cos2(t*scalet*0.004),9,6));				  
	}

	setscissor(0,255);
}

void eks2_deinit()
{
}
