// ----------------------- PLAYVTAL.H --------------------------
// VTAL Interface for players.
// (C) Copyright 1994-95 by JCAB of Iguana-VangeliSTeam.

#ifndef _PLAYVTAL_H_
#define _PLAYVTAL_H_

#include <vtal.h>




// ********************************************************
// --------------------------------------------------------
// Data structures.

typedef struct PLYV_SRec   PLYV_TRec,   LP PLYV_PRec;
typedef struct PLYV_SSetup PLYV_TSetup, LP PLYV_PSetup;

typedef void (PUBLICFUNC LP PLYV_PWatchProc)    (PLYV_PRec rec,         GSND_PData rawdata);
typedef void (PUBLICFUNC LP PLYV_PChanWatchProc)(PLYV_PRec rec, uint i, GSND_PData rawdata);

typedef struct PLYV_SSetup {

    char          MusicDevice[80];
    SDEV_TConfig  MusicConfig;
    GSND_TGenData MusicParams;
    
};

typedef struct PLYV_SRec {

    PLYV_TSetup     Setup;

    SDEV_handle     MusicDev;
    uint            MusicVolume;
    sint            MusChannels;
    SDEV_PInfo      MusInfo;
    GSND_TGenData   MusParams;
    GSND_TGenChg    MusParamsChg;
    volatile uint32 MusTickCount;
    sint            MusFade;

    PLYV_PWatchProc     WatchProc;
    PLYV_PChanWatchProc ChanWatchPreProc;
    PLYV_PChanWatchProc ChanWatchPostProc;

    uint            SoundTypes;

    bool            PollMode;
    bool            SongPlaying;

    SONG_handle     Song;
    SONG_PInfo      SongInfo;
    PLAY_TInitData  PlayerID;
    PLAY_handle     Player;
    PLAY_PInfo      PlayInfo;

    bool         LP ChannelMute;
};

enum {

    PLYV_FADEOUT = 0,   // Fade to silence.
    PLYV_FADEIN  = 1,   // Slide up the volume.

    PLYV_POLL    = 0,   // Manual polling mode.
    PLYV_TIMER   = 1    // Automatic timer mode.

};




// ********************************************************
// --------------------------------------------------------
// Function prototypes.

PUBLIC PLYV_PRec PUBLICFUNC PLYV_Init      (PLYV_PSetup setup);
PUBLIC void      PUBLICFUNC PLYV_Done      (PLYV_PRec rec);
PUBLIC uint      PUBLICFUNC PLYV_SetMode   (PLYV_PRec rec, uint mode);
PUBLIC uint      PUBLICFUNC PLYV_Poll      (PLYV_PRec rec, int TimeOut);
PUBLIC void      PUBLICFUNC PLYV_FillDevice(PLYV_PRec rec);

PUBLIC bool      PUBLICFUNC PLYV_MUS_Load        (PLYV_PRec rec, LPconststr fname);
PUBLIC void      PUBLICFUNC PLYV_MUS_Unload      (PLYV_PRec rec);
PUBLIC void      PUBLICFUNC PLYV_MUS_Start       (PLYV_PRec rec, PLAY_PInitData id);
PUBLIC void      PUBLICFUNC PLYV_MUS_Stop        (PLYV_PRec rec);
PUBLIC void      PUBLICFUNC PLYV_MUS_ChangeVolume(PLYV_PRec rec, uint vol);
PUBLIC void      PUBLICFUNC PLYV_MUS_SetFading   (PLYV_PRec rec, uint in, uint time);

PUBLIC void      PUBLICFUNC PLYV_MUS_JumpSeqRel  (PLYV_PRec rec, sint offs);




#endif

