
#include "despair.h"

#include <timer.h>
#include <llscreen.h>
#include <llkey.h>
#include <sincos.h>
#include <pix.h>


extern byte *FB_Texture = NULL;
static byte *FB_Texture2 = NULL;
extern void FB_Draw320x200(byte *dest, int n, sint32 x, sint32 y, sint32 dx, sint32 dy);
#pragma aux FB_Draw320x200 parm [EDI] [ESI] [EAX] [EBX] [ECX] [EDX]

static byte *tex;
static int i;
static dword oldclock;

static bool DoFeedback(dword time) {
    int j;

    i -= (time - oldclock);
    oldclock = time;
    {
        sint32 x, y, dx, dy;

            // OJO! 30 y 20 diferentes al final de las lineas.
        dx = FPMult(0x1400000 + FPMult(0x200000, Sin(80*i)), Cos(32768+FPMult(8024, Sin(40*i))));
        dy = FPMult(0x1400000 + FPMult(0x200000, Sin(80*i)), Sin(32768+FPMult(8024, Sin(60*i))));

        x = 0x7FFFFFFF -dy*128 + dx*128;
        y = 0x7FFFFFFF -dx*128 - dy*128;
        x += FPMult(0x7F000000UL, Cos(127*i)) - 0x7F000000;
        y += FPMult(0x1F000000UL, Sin(127*i));
        for (j = 0; j < 200; j++) {
            FB_Draw320x200(FB_Texture2 + 256*j, 256, x, y, dx, dy);
            if (j < 200) {
                memcpy(LLS_Screen[0] + LLS_SizeX*j + 32, FB_Texture2 + 256*j, 256);
            }
            x -= dy;
            y += dx;
        }
    }
    LLS_Update();
    {
        byte *t;
        t = FB_Texture; FB_Texture = FB_Texture2; FB_Texture2 = t;
    }
    return TRUE;
}


extern bool InitFeedback(dword time) {
    byte *texp;

    texp = NEW(256*256);
    REQUIRE(texp != NULL);
    tex = texp;
    texp = NEW(256*256);
    REQUIRE(texp != NULL);
    FB_Texture = texp;
    texp = NEW(256*256);
    REQUIRE(texp != NULL);
    FB_Texture2 = texp;

    REQUIRE(LLS_Init(LLSM_DIRECT, LLSVM_MODE13));
    memset(LLS_Screen[0], 0, 64000);
    PIX_Load("GFX\\feedback.gif", tex, DestPal, NULL, NULL);

    MustFade = 1;
    FadeSpeed = 2;

    memcpy(FB_Texture, tex, 256*256);
    memcpy(FB_Texture2, tex, 256*256);

    oldclock = TIMER_Clock;
    CurFunction = DoFeedback;
    return TRUE;
}


extern bool EndFeedback(dword time) {
    DISPOSE(tex);
    DISPOSE(FB_Texture);
    DISPOSE(FB_Texture2);
    CurFunction = NULL;
    return TRUE;
}


