

#include "despair.h"

#include <sincos.h>
#include <llscreen.h>
#include <llkey.h>
#include <jclib.h>
#include <timer.h>
#include <llvesa.h>
#include <pix.h>
#include <text.h>

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

static dword LastTime = 0;

bool MustFade = FALSE;
int  FadeSpeed = 1;

byte ScrapPal[768], WorkPal[768], DestPal[768];

#define PI 3.14159264

extern void DoFade(dword time) {
    static dword LastTime = 0;

    if (!MustFade) {
        LastTime = time;
        return;
    }
    if (time > LastTime) {
        while (time > LastTime) {
            int i;
            for (i = 0; i < FadeSpeed; i++)
                VGA_FadePalette(WorkPal, WorkPal, 256, DestPal);
            LastTime++;
        }
        VGA_DumpPalette(WorkPal, 0, 256);
        if (memcmp(WorkPal, DestPal, 768) == 0)
            MustFade = FALSE;
    }
}

extern bool Wait(dword time) {
    return TRUE;
}

extern bool SetWait(dword time) {
    CurFunction = Wait;
    return TRUE;
}

extern bool InitFlash(dword time) {
    memset(WorkPal, 63, 768);
    FadeSpeed = 1;
    MustFade = TRUE;
    return TRUE;
}

extern bool ByeBye(dword time) {
    CurFunction = NULL;
    return TRUE;
}

extern bool InitFadeOut(dword time) {
    memcpy(WorkPal, DestPal, 768);
    memset(DestPal, 0, 768);
    FadeSpeed = 1;
    MustFade = TRUE;
    return TRUE;
}

extern bool InitStrobo(dword time) {
    int i;

    for (i = 0; i < 768; i++)
        WorkPal[i] = 63 - DestPal[i];
    FadeSpeed = 1;
    MustFade = TRUE;
    return TRUE;
}

extern bool FlipPal1(dword time) {
    int i;

    for (i = 0; i < 768; i+= 3) {
        WorkPal[i+0] = DestPal[i+2];
        WorkPal[i+1] = DestPal[i+0];
        WorkPal[i+2] = DestPal[i+1];
    }
    memcpy(DestPal, WorkPal, 768);
    InitStrobo(time);
//    memcpy(DestPal, WorkPal, 768);
    FadeSpeed = 4;
    VGA_DumpPalette(WorkPal, 0, 256);
    return TRUE;
}

extern bool FlipPal2(dword time) {
    int i;

    for (i = 0; i < 768; i+= 3) {
        WorkPal[i+0] = DestPal[i+1];
        WorkPal[i+1] = DestPal[i+2];
        WorkPal[i+2] = DestPal[i+0];
    }
    memcpy(DestPal, WorkPal, 768);
    InitStrobo(time);
//    memcpy(DestPal, WorkPal, 768);
    FadeSpeed = 4;
    VGA_DumpPalette(WorkPal, 0, 256);
    return TRUE;
}

extern bool InvertPal1(dword time) {
    int i;
    for (i = 0; i < 768; i++)
        DestPal[i] = 63-DestPal[i];
    MustFade = TRUE;
    FadeSpeed = 4;
    return TRUE;
}

extern void EnhancePal(void) {
    int i;
    for (i = 0; i < 768; i++)
        DestPal[i] = (int)(63.0*sin(DestPal[i]*PI/128) + 0.5);
}

extern bool DrawDragon(dword time) {
    byte *buf;
    int i;

    LLS_Init(LLSM_VIRTUAL, LLSVM_640x480x256);
    memset(LLS_Screen[0], 0, LLS_Size);
    LLS_Update();

    PIX_Load("GFX\\FREESTYL.GIF", LLS_Screen[0], DestPal, NULL, NULL);

    memset(WorkPal, 0, 768);
    VGA_DumpPalette(WorkPal, 0, 256);
    LLS_Update();
    FadeSpeed = 1;
    MustFade = TRUE;
    return TRUE;
}

extern bool DrawFinalPic(dword time) {
    byte *buf;
    int i;

    LLS_Init(LLSM_VIRTUAL, LLSVM_640x480x256);
    memset(LLS_Screen[0], 0, LLS_Size);
    LLS_Update();

    REQUIRE( (buf = NEW(640*480)) != NULL);
    PIX_Load("GFX\\TYRAN640.GIF", buf, DestPal, NULL, NULL);
    for (i = 0; i < 480; i++)
        memcpy(LLS_Screen[0] + LLS_SizeX*i + (640-360)/2, buf + i*360, 360);
    DISPOSE(buf);

    //PIX_Load("GFX\\SHIRT3.GIF", LLS_Screen[0], DestPal, NULL, NULL);

    memset(WorkPal, 0, 768);
    VGA_DumpPalette(WorkPal, 0, 256);
    LLS_Update();
    FadeSpeed = 1;
    MustFade = TRUE;
    return TRUE;
}


#define g_img LLS_Screen[0];
static word angle1 = 0, angle2 = 0;
static sdword amp = 0;

bool InitSplit(dword time)
{
    angle1 = 0, angle2 = 0;
    amp = 0xC80000;
    // CurFunction = DoSplit;
    return TRUE;
}

void SplitDump(void)
{
    int i, j;
    word a1 = angle1, a2 = angle2;
    sdword ca;
    byte *src = g_img;
    byte *dest = (byte *)0xA0000;

    if (amp < 0x10000)
    {
        memcpy(dest, src, 64000);
        return;
    }

    for (i = 0; i < 200; i++)
    {
        //if (!(i%8))
        {
            dword r = RND_GetNum();

            a1 += r;
            a2 -= r >> 16;
        }

        ca = FPMult(amp, Cos(a1+0x2378));
        ca += FPMult(amp/2, Sin(a2+0x1550));

        ca -= amp/2;
/*
        if (ca < 0)
        {
            if (ca < -320)
                ca = -320;
        }
*/
//        if (ca < 0)
//            ca = -ca;

        ca >>= 16;

        if (ca < 0)
        {
            src += -ca;

            for (j = 0; j < (320+ca); j++)
                *dest++ = *src++;
            for (; j < 320; j++)
                *dest++ = 0;
        }
        else
        {

            for (j = 0; j < ca; j++)
            {
                *dest++ = 0;
            }
            for (; j < 320; j++)
            {
                *dest++ = *src++;
            }
            src += ca;
        }

        a1 += 0xAC50;
        a1 += 0x3BF0;
    }
    angle1 += 0x300;
    angle2 += 0x400;
    amp = 0.89 * amp;
}

