;
;                  N64: YOSHI US CRACK-INTRO , MARCH 1998
;INTRO AND LOWLEVEL REVERSE BY TITANIK/CRAZYNATION! - titanik@infomaniak.ch
;

;
; CODE
;

        org  $80130000

mainproc:

        li      t0,$3c08800b       ; Here I replace the first 4 instructions
        sw      t0,($a0000400)     ; located a 80000400, because it's there
        li      t0,$3c090005       ; that I have put the jump in ROM
        sw      t0,($a0000404)
        li      t0,$25084cb0
        sw      t0,($a0000408)
        li      t0,$3529dff0
        sw      t0,($a000040c)

        jal     initn64            ; This function should be called at the
        nop                        ; beggining of the code

        la      a1,ScreenBuffer   
        jal     initscreen         ; Initializes the screen
        li      a0,2               ; (16 bit RGBA)


        ECRAN: equr s4             ; ECRAN contains the ScreenOffset
        NOLETTRE: equr s5          ; NOLETTRE contains the # of the current
                                   ; letter in the scroll
        COLSCROLL: equr s6         ; the column in the current letter
        _16: equr s7               ; just a constant..
        li _16,14
        li COLSCROLL,0

        li     s1,0
        li     s2,0

;
; MAIN LOOP
;

starteffect:

        la      t0,datapad-$80000000   ; Those four lines send the pif-block
        sw      t0,($a4800000)         ; to the pif via SI dma to request
        li      t0,$1fc007c0           ; joypad info
        sw      t0,($a4800010)           



        lui     t0,$a440         ; wait for vertical retrace            
        li      t3,$202          ; (actually wait for the half-line $200 to
        li      t2,$200          ; be drawn)
Retrac: lw      t1,$0010(t0)     ; You can do it in 3 lines, but that one
        beq     t1,t2,endd       ; also works if your code takes less than
        nop                      ; 1 line-refrech time (ok ok who cares;)
        bne     t1,t2,Retrac
        lw      t1,$0010(t0)
endd:

; -- logo moving ----------------------------------

        add    s1,2
        and    s1,$1ff
        add    s2,4
        and    s2,$1ff
        la     t1,screenbuffer+2*320*40+$20000000

        la     at,sintab2
        add    t0,s1,at
        lh     t2,0(t0)
        add    t1,t2

        la     at,sintab640
        add    t0,s2,at
        lh     t2,0(t0)
        add    t1,t2

        la      t0,cznlogo+320*2*40
bigg:
        la      t2,2*320*114
logloop: lh     t3,0(t0)
        and     t3,$fffefffe
        sh      t3,0(t1)
        add     t0,2
        add     t1,2
        bne     t2,zero,logloop
        subu    t2,2

; --  scroll text ---------------------------------

        la      ECRAN,ScreenBuffer+2*320*200+$20000000
        move    t2,ECRAN     

        li      t0,320*16-2       ; scrolls the scroll (hmmm..)
scroll: lw      t1,4(ECRAN)
        sw      t1,0(ECRAN)
        addiu   ECRAN,4
        bne     t0,zero,scroll
        subu    t0,2

aff:    la      t0,texte
        addu     t0,t0,NOLETTRE   ; t0=address of the letter to display     
        lbu     t0,0(t0)          ; t0=letter to display
        li      t9,' '
        bne     t0,t9,no_
        nop
        li      t0,95             ; space=91
no_     li      t9,'#'
        bne     t0,t9,nofin
        nop
        li      t0,91             ; espace juste cette ligne
        or      NOLETTRE,zero,zero

nofin:  subu    t0,65             ; A=0, B=1, etc
        sll     t3,t0,9
        la      t1,lettres
        add     t1,t1,t3

        add     t0,t1,COLSCROLL  
        add     t0,t0,COLSCROLL
        li      t1,16
y_loop:
        add     t2,320*2          ; t2=position of the screen
        lw      t3,0(t0)
        and     t3,$fffefffe
        sw      t3,0(t2)          ; display a letters row
        add     t0,32
        bne     t1,zero,y_loop
        subu    t1,1

        bne     COLSCROLL,_16,nope      ; next letter?        
        add     COLSCROLL,2
nextletter:                             ; yes...
        or      COLSCROLL,zero,zero
        add     NOLETTRE,1
nope:


; -- end of the scroll -------------------------------------

; -- read the joypad ---------------------------------------

        la      t0,datapad2-$80000000  ; here I dma back the result of the
        sw      t0,($a4800000)         ; joypad-info request. I didn't wait
        li      t0,$1fc007c0           ; for SI dma status to be OK, but the
        sw      t0,($a4800004)         ; delay was big enough, so no problem


        lbu     t0,($bfc007ff)         ; ok as you see i'm reading directly
                                       ; from the PIF it works 
        bne     t0,zero,end_intro      
        nop

        lhu     t0,($bfc007c4)         ; read the key of the 1st controller

        andi    t1,t0,$1000            ; start ?
        bne     t1,zero,end_intro      ; yes!

        nop
        beq     zero,zero,starteffect  ; jump to main loop
        nop

;------- jump au vrai jeu
end_intro:

;================

;------- clear the screen (blur-fader)

        li      t0,8*5
        li      s1,1
        li      s2,%1111011110111100
fader:
        li      t1,320*240
        la      t2,ScreenBuffer
fadloop:
        lh      t3,-2(t2)
        lh      t4,+2(t2)
        lh      t5,-640(t2)
        lh      t6,+640(t2)
        and     t3,s2
        and     t4,s2
        addu     t3,t4

        and     t5,s2
        and     t6,s2
        addu     t5,t6
        srl     t3,1
        srl     t5,1
        and     t3,s2
        and     t5,s2
        addu     t3,t5
        srl     t3,1

        or      t3,s1
        sh      t3,0(t2)

        addu     t2,2
        bne     t1,zero,fadloop
        subu     t1,1

        lui     t3,$a440         ; wait for vertical retrace
        li      t2,$188
        li      t2,$200
Retrac2:nop
        bne     t1,t2,Retrac2
        lw      t1,$0010(t3)

        bne     t0,zero,fader
        subu     t0,1

; -- end of the intro! ---------------------------------


        li  t0,$80000400               ; here we jump to the game, it's
        jr  t0                         ; the entrypoint. the jump to the rom 
        nop                            ; was there, but we replaced it at the
                                       ; beginning of the code remember! 

;
; Inits
;

;
;  InitN64
;

initn64:
        li      t0,8           ; Ok that's the magic "initialisation". what's
        sw      t0,($bfc007fc) ; at $bfc007fc ? It's an interface to the
        jr      ra             ; security chip. If you don't put the bit 3
        nop                    ; to 1 after approx 2 sec, the n64 will be
                               ; locked.
                               ; In the games, libraries etc they don't write
                               ; 8 to $bfc007fc but instead just set the
                               ; bit 3 to 1. Still writing 8 is working fine.
                               ;
                               ; and NO this has NOTHING to do with joypad
                               ; initialisation or whatever. If you rip some
                               ; code, at least try to understand what it
                               ; does!
               
;
;  InitScreen
;
; input:
;   a0=Color Mode (0=No Sync, 2=16bit/pixel, 3=32bit/pixel)
;   a1=Screen Buffer

initscreen:
        lui     t0,$a440         ; here I fill the VI registers with the
        li      t1,$13000        ; values (dumped from MARIO64 US;)
        or      t1,a0            ; Those are the values for the NTSC mode 
        sw      t1,0(t0)         ; only!
        move    t1,a1
        sw      t1,4(t0)
        li      t1,$140
        sw      t1,8(t0)
        li      t1,$2
        sw      t1,12(t0)
        li      t1,$0
        sw      t1,16(t0)
        li      t1,$3e52239
        sw      t1,20(t0)
        li      t1,$0000020d
        sw      t1,24(t0)
        li      t1,$00000c15
        sw      t1,28(t0)
        li      t1,$0c150c15
        sw      t1,32(t0)
        li      t1,$06c02ec
        sw      t1,36(t0)
        li      t1,$002501ff
        sw      t1,40(t0)
        li      t1,$000e0204
        sw      t1,44(t0)
        li      t1,$200
        sw      t1,48(t0)
        li      t1,$400
        sw      t1,52(t0)

        jr      ra
        nop

;

;
; VARIABLES
;

SelectOption: dcb 4,0    ; Which trainer-option is selected (ok that has
                         ; nothing to do with a crack, still it's part
                         ; of the ORIGINAL sourcecode of this intro, so
                         ; i'll keep it here;)

cxc0          dcb ((((cxc0)/64)+1)*64)-(cxc0),0
                            ; that's to align the code to a multiple of 64
                            ; this trick is (C) Wildfire 1997 ! ;)

datapad       db $ff,$01,$04,$01,$00,$00,$00,$00
              db $ff,$01,$04,$01,$00,$00,$00,$00
              db $ff,$01,$04,$01,$00,$00,$00,$00
              db $ff,$01,$04,$01,$00,$00,$00,$00
              db $fe,$00,$00,$00,$00,$00,$00,$00
              db $00,$00,$00,$00,$00,$00,$00,$00
              db $00,$00,$00,$00,$00,$00,$00,$00
              db $00,$00,$00,$00,$00,$00,$00,$01

;
; INCLUDES, CONSTANTES, etc
;

cxc4          dcb ((((cxc4)/64)+1)*64)-(cxc4),0

cznlogo:      incbin spectre.rgb     ; the logo
endlogo:
datapad2      dcb      64,0          ; that's for the SI dma-back

lettres:      incbin  let4.rgb       ; the fonts

texte         db      "       CRAZY NATION GIVES YOU THE YOSHI US CRACK      "
              db      "       CRACKED BY TITANIK         "
              db      "       CODE BY TITANIK           "
              db      "       LOGO BY CURSE           "
              db      "       REGARDS TO WILDFIRE LOOM AND CURSE          "
              db      "       BTW THIS IS THE FIRST CRACKINTRO ON THE NINTENDO SIXTYFOUR         "
              db      "       UNFORTUNATELY ITS SHIT HEHE        "
              db      "       THIS INTRO WAS CODED IN A HURRY IN A COUPLE OF MINUTES AFTER I FINISHED THE CRACK         "
              db      "       AS USUAL IT IS HUNDRED PERCENT DEVKIT AND LIBRARY FREE             "
              db      "       GREETINGS TO ALL CONSOLE CODERS OUT THERE         "
              db      "       ENJOY THAT CRACK          "
              db      "       SCROLLER RESTARTS                        #   "

cxc5          dcb ((((cxc5)/64)+1)*64)-(cxc5),0
sintab2:      incbin  sintab2        ; sinustable * 2
sintab640:    incbin  sintab64       ; sinustable * 320 * 2

ScreenBuffer  dch      320*240,0     ; Here is the .. screen buffer

;
