//
//                       __      __      _  __ 
//                   .: (__ (__ (--) >-< ( (-_ :.
//
//
// (c) Copyright 1997 Mikko E. Mononen <memon@inside.org>
//

#include "draw.hh"
#include "globals.hh"

void
DrawGouraudPoly(vertexuv * vtx, int vertices, long didx, char* ramp)
{

#define INNERLOOP \
  while ( width-- ) { \
    *(dst++) = ramp[i >> 16]; \
    i += didx; \
  }

#define __GOURAUD__
#include "affine.tri"
#undef  __GOURAUD__
#undef  INNERLOOP

}

void
DrawFogGouraudPoly(vertexuv * vtx, int vertices, long didx, long dfdx, char* ramp)
{

#define INNERLOOP \
  while ( width-- ) { \
    *(dst++) = IE_globals.fogTable[ramp[i >> 16] + ((f >> 8) & 0xff00)]; \
    i += didx; \
    f += dfdx; \
  }

#define __GOURAUD__
#define __FOG__
#include "affine.tri"
#undef  __FOG__
#undef  __GOURAUD__
#undef  INNERLOOP

}


void DrawTexturePoly(vertexuv * vtx, int vertices,
                     char * bitmap, long dudx, long dvdx )
{

#define INNERLOOP \
  while ( width-- ) { \
    *(dst++) = bitmap[((v >> 8)& 0xff00)+((u >> 16) & 0xff)]; \
    u += dudx; \
    v += dvdx; \
  }

#define __TEXTURE__
#include "affine.tri"
#undef  __TEXTURE__
#undef  INNERLOOP

}

void DrawFogTexturePoly(vertexuv * vtx, int vertices,
                     char * bitmap, long dudx, long dvdx, long dfdx)
{

#define INNERLOOP \
  while ( width-- ) { \
    *(dst++) = IE_globals.fogTable[bitmap[((v >> 8)& 0xff00)+((u >> 16) & 0xff)] + ((f >> 8) & 0xff00)]; \
    u += dudx; \
    v += dvdx; \
    f += dfdx; \
  }

#define __TEXTURE__
#define __FOG__
#include "affine.tri"
#undef  __FOG__
#undef  __TEXTURE__
#undef  INNERLOOP

}


void DrawShadedTexturePoly(vertexuv * vtx, int vertices,
                     char * bitmap, long dudx, long dvdx, long didx)
{

#define INNERLOOP \
  while ( width-- ) { \
    *(dst++) = IE_globals.shadeTable[bitmap[((v >> 8)& 0xff00)+((u >> 16) & 0xff)] + ((i >> 8) & 0xff00)]; \
    u += dudx; \
    v += dvdx; \
    i += didx; \
  }

#define __TEXTURE__
#define __GOURAUD__
#include "affine.tri"
#undef  __GOURAUD__
#undef  __TEXTURE__
#undef  INNERLOOP

}

void DrawFogShadedTexturePoly(vertexuv * vtx, int vertices,
                     char * bitmap, long dudx, long dvdx, long didx, long dfdx)
{



#define INNERLOOP \
  while ( width-- ) { \
    *(dst++) = IE_globals.fogTable[IE_globals.shadeTable[bitmap[((v >> 8)& 0xff00)+((u >> 16) & 0xff)] + ((i >> 8) & 0xff00)] + ((f >> 8) & 0xff00)]; \
    u += dudx; \
    v += dvdx; \
    i += didx; \
    f += dfdx; \
  }

#define __TEXTURE__
#define __GOURAUD__
#define __FOG__
#include "affine.tri"
#undef  __FOG__
#undef  __GOURAUD__
#undef  __TEXTURE__
#undef  INNERLOOP

}

