
/*
 *      Misc declarations
 *
 *      This source is part of the fatmap2.txt document by
 *      Mats Byggmastar, mri@penti.sit.fi
 *      17.4.1997 Jakobstad, Finland
 *
 *      Companies with self respect are encouraged to contact me if
 *      any of this code is to be used as part of a commercial product.
 */


#ifndef _MISC_H
#define _MISC_H

/*
 *
 *      Declarations for mappers
 *
 */


struct vertex
{
    long x,y;       // Screen position in 16:16 bit fixed point
};

struct vertexi
{
    long x,y;       // Screen position in 16:16 bit fixed point
    long i,f;         // Color intensity in 16:16 bit fixed point
};

struct vertexuv
{
    long x,y;       // Screen position in 16:16 bit fixed point
    long u,v;       // Texture u,v in 16:16 bit fixed point
    long i,f;
};

extern void DrawFlatPoly(vertex * vtx, int vertices, int color);
extern void DrawGouraudPoly(vertexuv * vtx, int vertices, long didx, char* ramp);
extern void DrawFogGouraudPoly(vertexuv * vtx, int vertices, long didx, long dfdx, char* ramp);
extern void DrawTexturePoly(vertexuv * vtx, int vertices, char * bitmap, long dudx, long dvdx );
extern void DrawFogTexturePoly(vertexuv * vtx, int vertices, char * bitmap, long dudx, long dvdx, long dfdx );
extern void DrawShadedTexturePoly(vertexuv * vtx, int vertices, char * bitmap, long dudx, long dvdx, long didx);
extern void DrawFogShadedTexturePoly(vertexuv * vtx, int vertices, char * bitmap, long dudx, long dvdx, long didx, long dfdx);


inline long ceil(long x)
{
    x +=  0xffff;
    return (x >> 16);
}


long imul16(long x, long y);        // (x * y) >> 16
#pragma aux imul16 = \
    " imul  edx        "\
    " shrd  eax,edx,16 "\
    parm [eax] [edx] value [eax]


long imul14(long x, long y);        // (x * y) >> 14
#pragma aux imul14 = \
    " imul  edx        "\
    " shrd  eax,edx,14 "\
    parm [eax] [edx] value [eax]


long idiv16(long x, long y);        // (x << 16) / y
#pragma aux idiv16 = \
    " mov   edx,eax    "\
    " sar   edx,16     "\
    " shl   eax,16     "\
    " idiv  ebx        "\
    parm [eax] [ebx] modify exact [eax edx] value [eax]



/*
 *
 *      Declarations for 2d clipper
 *
 */

/*
extern float TopClip;
extern float BotClip;
extern float LeftClip;
extern float RightClip;
*/

#define VISIBLE     0
#define TOP         1
#define BOT         2
#define LEFT        4
#define RIGHT       8

struct vertexclip
{
    float x,y; //, z, iz;
    float u,v;
    float i, f;
    int visible;
};

extern int ClipUV(vertexclip *** final, vertexclip * vbp);



/*
 *
 *      Declarations for drawing functions
 *
 */

struct vertexuvfloat
{
    float x, y; //, z, iz;
    float u,v;
    float i, f;
    int visible;
};

extern void DrawFlatTriangle(vertexuvfloat * vtx, int color);
extern void DrawGouraudTriangle(vertexuvfloat * vtx, char* ramp);
extern void DrawFogGouraudTriangle(vertexuvfloat * vtx, char* ramp);
extern void DrawTextureTriangle(vertexuvfloat * vtx, char * bitmap);
extern void DrawFogTextureTriangle(vertexuvfloat * vtx, char * bitmap);
extern void DrawShadedTextureTriangle(vertexuvfloat * vtx, char * bitmap);
extern void DrawFogShadedTextureTriangle(vertexuvfloat * vtx, char * bitmap);

#endif
